/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.GLBaseTexture;
import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.AnimatedAppearanceResource;
import com.shavenpuppy.jglib.sprites.ImageBank;
import com.shavenpuppy.jglib.sprites.Imaged;
import com.shavenpuppy.jglib.sprites.Style;
import com.shavenpuppy.jglib.util.XMLUtil;
import org.lwjgl.opengl.OpenGLException;
import org.w3c.dom.Element;

public class SpriteImage
extends AnimatedAppearanceResource {
    public static final long serialVersionUID = 1L;
    private transient ImageBank imageBank;
    private String imageBankName;
    private transient GLBaseTexture texture;
    private transient Style style;
    private String styleName;
    private int x;
    private int y;
    private int w;
    private int h;
    private int hotspotx;
    private int hotspoty;
    private boolean offset = true;
    private float tx0;
    private float tx1;
    private float ty0;
    private float ty1;

    protected SpriteImage() {
    }

    SpriteImage(String name, String imageBankName, String styleName) {
        this(name);
        this.imageBankName = imageBankName;
        this.styleName = styleName;
    }

    SpriteImage(String name, String imageBankName, String styleName, int x, int y, int w, int h, int hotspotx, int hotspoty, boolean offset) {
        this(name, imageBankName, styleName);
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.hotspotx = hotspotx;
        this.hotspoty = hotspoty;
        this.offset = offset;
    }

    public SpriteImage(GLBaseTexture texture, Style style, int x, int y, int w, int h, int hotspotx, int hotspoty, boolean offset) {
        this.texture = texture;
        this.style = style;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.hotspotx = hotspotx;
        this.hotspoty = hotspoty;
        this.offset = offset;
    }

    public SpriteImage(String texture, String styleName, int hotspotx, int hotspoty) throws Exception {
        this(String.valueOf(texture) + "-image");
        this.texture = (GLBaseTexture)Resources.get(texture);
        this.style = (Style)((Object)Resources.get(styleName));
        this.hotspotx = hotspotx;
        this.hotspoty = hotspoty;
        this.w = this.texture.getWidth();
        this.h = this.texture.getHeight();
        this.tx1 = 1.0f;
        this.ty1 = 1.0f;
    }

    public SpriteImage(String styleName, int width, int height, int hotspotx, int hotspoty) {
        this(String.valueOf(styleName) + "-" + width + "x" + height);
        this.styleName = styleName;
        this.hotspotx = hotspotx;
        this.hotspoty = hotspoty;
        this.w = width;
        this.h = height;
    }

    private SpriteImage(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        this.x = Integer.parseInt(element.getAttribute("x"));
        this.y = Integer.parseInt(element.getAttribute("y"));
        this.w = Integer.parseInt(element.getAttribute("w"));
        this.h = Integer.parseInt(element.getAttribute("h"));
        this.hotspotx = Integer.parseInt(element.getAttribute("hx"));
        this.hotspoty = Integer.parseInt(element.getAttribute("hy"));
        this.styleName = element.getAttribute("style");
        this.offset = XMLUtil.getBoolean(element, "offset", true);
    }

    private void calculateTextureCoordinates() {
        double tw = this.texture.getWidth();
        double th = this.texture.getHeight();
        if (this.offset) {
            this.tx0 = (float)((double)((float)this.x + 0.5f) / tw);
            this.tx1 = (float)((double)((float)(this.x + this.w) - 0.5f) / tw);
            this.ty0 = (float)((double)((float)this.y + 0.5f) / th);
            this.ty1 = (float)((double)((float)(this.y + this.h) - 0.5f) / th);
        } else {
            this.tx0 = (float)((double)this.x / tw);
            this.tx1 = (float)((double)(this.x + this.w) / tw);
            this.ty0 = (float)((double)this.y / th);
            this.ty1 = (float)((double)(this.y + this.h) / th);
        }
    }

    protected void doCreate() throws Exception {
        if (this.texture == null && this.imageBankName != null) {
            this.imageBank = (ImageBank)Resources.get(this.imageBankName);
            if (this.imageBank == null) {
                throw new OpenGLException("Imagebank " + this.imageBankName + " does not exist");
            }
            this.texture = this.imageBank.texture;
            if (this.texture == null) {
                throw new OpenGLException("Imagebank " + this.imageBankName + " has no texture");
            }
        }
        if (this.style == null) {
            if (this.styleName == null || "".equals(this.styleName)) {
                this.styleName = this.imageBank.getDefaultStyleName();
            }
            this.style = (Style)((Object)Resources.get(this.styleName));
        }
        if (this.texture != null) {
            this.calculateTextureCoordinates();
        }
    }

    protected void doDestroy() {
        this.imageBank = null;
        this.texture = null;
    }

    public final int getWidth() {
        return this.w;
    }

    public final int getHeight() {
        return this.h;
    }

    public final float getTx0() {
        return this.tx0;
    }

    public final float getTx1() {
        return this.tx1;
    }

    public final float getTy0() {
        return this.ty0;
    }

    public final float getTy1() {
        return this.ty1;
    }

    public final int getHotspotX() {
        return this.hotspotx;
    }

    public final int getHotspotY() {
        return this.hotspoty;
    }

    public final GLBaseTexture getTexture() {
        return this.texture;
    }

    protected Class getAllocatorType() {
        return null;
    }

    public Style getStyle() {
        return this.style;
    }

    public void toAnimated(Animated target) {
        ((Imaged)((Object)target)).setImage(this);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

