/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.opengl.GLBaseTexture;
import com.shavenpuppy.jglib.sprites.AbstractAnimated;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.Colored;
import com.shavenpuppy.jglib.sprites.ISprite;
import com.shavenpuppy.jglib.sprites.Imaged;
import com.shavenpuppy.jglib.sprites.SerializedSprite;
import com.shavenpuppy.jglib.sprites.SpriteEngine;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.sprites.Style;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import java.io.ObjectStreamException;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.WritableColor;

public class Sprite
extends AbstractAnimated
implements ISprite,
Imaged,
Colored {
    private static final long serialVersionUID = 1L;
    private static SpriteImage missingImage;
    int index;
    private final SpriteEngine engine;
    private Object owner;
    private boolean allocated;
    private SpriteImage image;
    private Style style;
    private GLBaseTexture texture;
    private int layer;
    private int x;
    private int y;
    private int z;
    private int ox;
    private int oy;
    private int oz;
    private int ySortOffset;
    private boolean flash;
    private float tx00;
    private float ty00;
    private float tx01;
    private float ty01;
    private float tx10;
    private float ty10;
    private float tx11;
    private float ty11;
    private final Color[] color = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(255, 255, 255, 255)};
    private static final int NO_SCALE;
    private int xscale = NO_SCALE;
    private int yscale = NO_SCALE;
    private int alpha = 255;
    private int angle = 0;
    private boolean visible = true;
    private boolean active = true;
    private boolean mirrored;
    private boolean flipped;
    private boolean doChildOffset;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.sprites.Sprite");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        NO_SCALE = FPMath.fpValue(1);
    }

    Sprite(SpriteEngine engine) {
        this.engine = engine;
    }

    public void init(Object newOwner) {
        if (this.allocated) {
            throw new IllegalStateException(this + "Already allocated: " + newOwner + " can't have it!");
        }
        this.allocated = true;
        this.reset();
        this.owner = newOwner;
        this.active = true;
        this.visible = true;
        this.image = null;
        this.flash = false;
        this.ox = 0;
        this.oy = 0;
        this.oz = 0;
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.color[0].set(255, 255, 255, 255);
        this.color[1].set(255, 255, 255, 255);
        this.color[2].set(255, 255, 255, 255);
        this.color[3].set(255, 255, 255, 255);
        this.layer = 0;
        this.xscale = NO_SCALE;
        this.yscale = NO_SCALE;
        this.alpha = 255;
        this.angle = 0;
        this.mirrored = false;
        this.flipped = false;
        this.doChildOffset = false;
    }

    public Object getOwner() {
        return this.owner;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public Vector3i getLocation(Vector3i ret) {
        if (ret == null) {
            ret = new Vector3i(this.x, this.y, this.z);
        } else {
            ret.set(this.x, this.y, this.z);
        }
        return ret;
    }

    public void setLocation(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setLocation(ReadableVector3i newLocation) {
        this.x = newLocation.getX();
        this.y = newLocation.getY();
        this.z = newLocation.getZ();
    }

    public Vector3i getOffset(Vector3i ret) {
        if (ret == null) {
            ret = new Vector3i(this.ox, this.oy, this.oz);
        } else {
            ret.set(this.ox, this.oy, this.oz);
        }
        return ret;
    }

    public void setOffset(int ox, int oy, int oz) {
        this.ox = ox;
        this.oy = oy;
        this.oz = oz;
    }

    public void setOffset(ReadableVector3i location) {
        this.ox = location.getX();
        this.oy = location.getY();
        this.oz = location.getZ();
    }

    public void tick() {
        if (!this.active || this.getAnimation() == null) {
            return;
        }
        if (!this.isPaused()) {
            this.getAnimation().animate(this, this.engine.getTickRate());
        }
    }

    public void setFlash(boolean flash) {
        this.flash = flash;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getXScale() {
        return this.xscale;
    }

    public int getYScale() {
        return this.yscale;
    }

    public void setScale(int scale) {
        this.xscale = scale;
        this.yscale = scale;
    }

    public void setScale(int xscale, int yscale) {
        this.xscale = xscale;
        this.yscale = yscale;
    }

    public void adjustScale(int xscale, int yscale) {
        this.xscale += xscale;
        this.yscale += yscale;
    }

    public void adjustAlpha(int delta) {
        this.alpha = Math.max(0, Math.min(255, this.alpha + delta));
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void hide() {
        this.setVisible(false);
    }

    public void setColor(int index, int r, int g, int b, int a) {
        this.color[index].set(r, g, b, a);
    }

    public void setColors(int r, int g, int b, int a) {
        this.color[0].set(r, g, b, a);
        this.color[1].set(r, g, b, a);
        this.color[2].set(r, g, b, a);
        this.color[3].set(r, g, b, a);
    }

    public void setColor(int index, ReadableColor src) {
        this.color[index].setColor(src);
    }

    public void setColors(ReadableColor src) {
        this.color[0].setColor(src);
        this.color[1].setColor(src);
        this.color[2].setColor(src);
        this.color[3].setColor(src);
    }

    public void setAngle(int angle) {
        this.angle = angle % 65535;
    }

    public int getAngle() {
        return this.angle;
    }

    public void adjustAngle(int delta) {
        this.angle = (this.angle + delta) % 65535;
    }

    public WritableColor getColor(int index, WritableColor dest) {
        if (dest == null) {
            return new Color((ReadableColor)this.color[index]);
        }
        dest.setColor((ReadableColor)this.color[index]);
        return dest;
    }

    public void setImage(SpriteImage image) {
        this.image = image;
        if (image == null) {
            return;
        }
        if (!$assertionsDisabled && !image.isCreated()) {
            throw new AssertionError((Object)("Image " + image + " not created!"));
        }
        if (!$assertionsDisabled && image.getStyle() == null) {
            throw new AssertionError((Object)("Image " + image + " has no style!"));
        }
    }

    public void deactivate() {
        this.setActive(false);
    }

    public SpriteImage getImage() {
        return this.image;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Style getStyle() {
        return this.style != null ? this.style : (this.getImage() != null ? this.getImage().getStyle() : null);
    }

    public void moveLocation(int dx, int dy, int dz) {
        this.x += dx;
        this.y += dy;
        this.z += dz;
    }

    public void moveOffset(int dx, int dy, int dz) {
        this.ox += dx;
        this.oy += dy;
        this.oz += dz;
    }

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    public void deallocate() {
        if (!this.allocated) {
            return;
        }
        this.allocated = false;
        this.engine.deallocate(this);
        this.owner = null;
    }

    void forceDeallocate() {
        if (!$assertionsDisabled && !this.allocated) {
            throw new AssertionError();
        }
        this.allocated = false;
        this.visible = false;
    }

    public String toString() {
        return "Sprite[idx=" + this.index + ", owner=" + this.owner + ", image=" + this.image + ", active=" + this.active + ", visible=" + this.visible + ", position=" + this.x + "," + this.y + "," + this.z + ", " + this.getAnimation() + ", " + this.getStyle() + "]";
    }

    public boolean isFlashing() {
        return this.flash;
    }

    public void setAppearance(AnimatedAppearance appearance) {
        if (appearance == null) {
            this.image = null;
            this.setAnimation(null);
            this.rewind();
        } else {
            appearance.toAnimated(this);
        }
    }

    public boolean isAllocated() {
        return this.allocated;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean flipped) {
        this.flipped = flipped;
    }

    public boolean isMirrored() {
        return this.mirrored;
    }

    public void setMirrored(boolean mirrored) {
        this.mirrored = mirrored;
    }

    public boolean isDoChildOffset() {
        return this.doChildOffset;
    }

    public void setDoChildOffset(boolean doChildOffset) {
        this.doChildOffset = doChildOffset;
    }

    public void rotateToTarget(float dirX, float dirY) {
        this.setAngle(FPMath.fpYaklyDegrees(Util.angleFromDirection(dirX, dirY)));
    }

    private Object writeReplace() throws ObjectStreamException {
        SerializedSprite ss = new SerializedSprite();
        ss.fromSprite(this);
        return ss;
    }

    public static void setMissingImage(SpriteImage missingImage) {
        Sprite.missingImage = missingImage;
    }

    public static SpriteImage getMissingImage() {
        return missingImage;
    }

    public float getTx00() {
        return this.tx00;
    }

    public float getTy00() {
        return this.ty00;
    }

    public float getTx01() {
        return this.tx01;
    }

    public float getTy01() {
        return this.ty01;
    }

    public float getTx10() {
        return this.tx10;
    }

    public float getTy10() {
        return this.ty10;
    }

    public float getTx11() {
        return this.tx11;
    }

    public float getTy11() {
        return this.ty11;
    }

    public void setTextureCoords(float tx00, float ty00, float tx10, float ty10, float tx11, float ty11, float tx01, float ty01) {
        this.tx00 = tx00;
        this.ty00 = ty00;
        this.tx10 = tx10;
        this.ty10 = ty10;
        this.tx11 = tx11;
        this.ty11 = ty11;
        this.tx01 = tx01;
        this.ty01 = ty01;
    }

    public void setTexture(GLBaseTexture texture) {
        this.texture = texture;
    }

    public GLBaseTexture getTexture() {
        return this.texture;
    }

    int getOffsetY() {
        return this.oy;
    }

    public void setYSortOffset(int sortOffset) {
        this.ySortOffset = sortOffset;
    }

    public int getYSortOffset() {
        return this.ySortOffset;
    }
}

