/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.Command;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.IOException;
import org.w3c.dom.Element;

public class RandomDelayCommand
extends Command {
    public static final long serialVersionUID = 1L;
    private int minDelay;
    private int maxDelay;

    public boolean execute(Animated target, int tickRate) {
        int tick = target.getTick();
        if (tick == 0) {
            tick = Util.random(this.minDelay, this.maxDelay);
        }
        target.setTick(tick -= tickRate);
        if (tick == 0) {
            target.setSequence(target.getSequence() + 1);
            return true;
        }
        return false;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        if (XMLUtil.hasAttribute(element, "d")) {
            this.maxDelay = this.minDelay = XMLUtil.getInt(element, "d");
        } else {
            this.minDelay = XMLUtil.getInt(element, "min");
            this.maxDelay = XMLUtil.getInt(element, "max");
        }
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        if (this.minDelay == this.maxDelay) {
            writer.writeAttribute("d", this.minDelay, true);
        } else {
            writer.writeAttribute("min", this.minDelay, true);
            writer.writeAttribute("max", this.maxDelay, true);
        }
    }
}

