/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.Command;
import java.io.IOException;
import org.w3c.dom.Element;

public class FrameCommand
extends Command {
    public static final long serialVersionUID = 1L;
    private int duration;
    private int childXOffset;
    private int childYOffset;
    private String appearanceName;
    private transient AnimatedAppearance spriteAppearance;

    public boolean execute(Animated target, int tickRate) {
        int currentSequence = target.getSequence();
        int currentTick = target.getTick();
        if (currentTick >= this.duration) {
            if (this.duration == 0) {
                if (this.spriteAppearance == null) {
                    System.err.println("frame " + this.appearanceName + " not found");
                } else {
                    this.spriteAppearance.toAnimated(target);
                }
            }
            target.setSequence(++currentSequence);
            target.setTick(0);
            target.setChildXOffset(this.childXOffset);
            target.setChildYOffset(this.childYOffset);
            return true;
        }
        target.setTick(currentTick + tickRate);
        if (this.spriteAppearance == null) {
            System.err.println("frame " + this.appearanceName + " not found");
        } else {
            this.spriteAppearance.toAnimated(target);
        }
        target.setChildXOffset(this.childXOffset);
        target.setChildYOffset(this.childYOffset);
        return false;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        this.appearanceName = element.getAttribute("i");
        this.duration = Integer.parseInt(element.getAttribute("d"));
        this.childXOffset = element.hasAttribute("childXOffset") ? Integer.parseInt(element.getAttribute("childXOffset")) : 0;
        this.childYOffset = element.hasAttribute("childYOffset") ? Integer.parseInt(element.getAttribute("childYOffset")) : 0;
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        writer.writeAttribute("i", this.appearanceName, true);
        writer.writeAttribute("d", this.duration, true);
        writer.writeAttribute("childXOffset", this.childXOffset, false);
        writer.writeAttribute("childYOffset", this.childYOffset, false);
    }

    protected void doCreate() throws Exception {
        this.spriteAppearance = (AnimatedAppearance)((Object)Resources.get(this.appearanceName));
        if (this.spriteAppearance == null) {
            System.err.println("Couldn't find " + this.appearanceName);
        }
    }

    protected void doDestroy() {
        this.spriteAppearance = null;
    }
}

