/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib;

import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import org.lwjgl.util.Color;
import org.lwjgl.util.Dimension;
import org.lwjgl.util.Point;
import org.lwjgl.util.Rectangle;
import org.lwjgl.util.vector.Vector3f;

public class XMLResourceWriter {
    private final Writer writer;
    private int indent;
    private final Stack tags = new Stack();
    private boolean writingAttributes;
    private boolean firstAttribute;
    private boolean compact;

    public XMLResourceWriter(Writer writer) {
        this.writer = writer;
    }

    public void setCompact(boolean compact) {
        this.compact = compact;
    }

    public boolean isCompact() {
        return this.compact;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void writeTag(String tag) throws IOException {
        if (this.writingAttributes) {
            --this.indent;
            if (!this.firstAttribute) {
                this.writeIndent();
            }
            this.writer.write(">\n");
            ++this.indent;
        }
        this.writeIndent();
        this.writer.write("<");
        this.writer.write(tag);
        ++this.indent;
        this.tags.push(tag);
        this.writingAttributes = true;
        this.firstAttribute = true;
    }

    public void closeTag() throws IOException {
        String tag = (String)this.tags.pop();
        --this.indent;
        if (this.writingAttributes) {
            if (!this.firstAttribute && !this.compact) {
                this.writeIndent();
            }
            this.writer.write("/>\n");
        } else {
            this.writeIndent();
            this.writer.write("</");
            this.writer.write(tag);
            this.writer.write(">\n");
        }
        this.writingAttributes = false;
    }

    private void writeIndent() throws IOException {
        int i = 0;
        while (i < this.indent) {
            this.writer.write(9);
            ++i;
        }
    }

    public void writeAttribute(String name, Object data) throws IOException {
        this.writeAttribute(name, data, false);
    }

    public void writeAttribute(String name, Object data, boolean alwaysWrite) throws IOException {
        if (!this.writingAttributes) {
            throw new IOException("Can't write attributes here");
        }
        if (data == null) {
            return;
        }
        if (!alwaysWrite && (data instanceof String ? ((String)data).equals("") : (data instanceof Number ? ((Number)data).doubleValue() == 0.0 : data instanceof Boolean && (Boolean)data == false))) {
            return;
        }
        if (this.firstAttribute) {
            if (!this.compact) {
                this.writer.write(10);
            } else {
                this.writer.write(32);
            }
            this.firstAttribute = false;
        } else if (this.compact) {
            this.writer.write(32);
        }
        if (!this.compact) {
            this.writeIndent();
        }
        this.writer.write(name);
        this.writer.write("=\"");
        if (data instanceof Rectangle) {
            Rectangle r = (Rectangle)data;
            this.writer.write(String.valueOf(r.getX()));
            this.writer.write(", ");
            this.writer.write(String.valueOf(r.getY()));
            this.writer.write(", ");
            this.writer.write(String.valueOf(r.getWidth()));
            this.writer.write(", ");
            this.writer.write(String.valueOf(r.getHeight()));
        } else if (data instanceof Point) {
            Point p = (Point)data;
            this.writer.write(String.valueOf(p.getX()));
            this.writer.write(", ");
            this.writer.write(String.valueOf(p.getY()));
        } else if (data instanceof Vector3f) {
            Vector3f v = (Vector3f)data;
            this.writer.write(String.valueOf(v.getX()));
            this.writer.write(", ");
            this.writer.write(String.valueOf(v.getY()));
            this.writer.write(", ");
            this.writer.write(String.valueOf(v.getZ()));
        } else if (data instanceof Dimension) {
            Dimension d = (Dimension)data;
            this.writer.write(String.valueOf(d.getWidth()));
            this.writer.write(", ");
            this.writer.write(String.valueOf(d.getHeight()));
        } else if (data instanceof Color) {
            Color c = (Color)data;
            this.writer.write(String.valueOf(c.getRed()));
            this.writer.write(", ");
            this.writer.write(String.valueOf(c.getGreen()));
            this.writer.write(", ");
            this.writer.write(String.valueOf(c.getBlue()));
            this.writer.write(", ");
            this.writer.write(String.valueOf(c.getAlpha()));
        } else {
            this.writer.write(data.toString());
        }
        if (this.compact) {
            this.writer.write(34);
        } else {
            this.writer.write("\"\n");
        }
    }

    public void writeText(String text) throws IOException {
        if (this.writingAttributes) {
            this.writingAttributes = false;
            this.writer.write(">");
        }
        this.writer.write(text);
    }

    public void writeAttribute(String name, boolean value) throws IOException {
        this.writeAttribute(name, value, false);
    }

    public void writeAttribute(String name, float value) throws IOException {
        this.writeAttribute(name, value, false);
    }

    public void writeAttribute(String name, double value) throws IOException {
        this.writeAttribute(name, value, false);
    }

    public void writeAttribute(String name, int value) throws IOException {
        this.writeAttribute(name, value, false);
    }

    public void writeAttribute(String name, boolean value, boolean alwaysWrite) throws IOException {
        this.writeAttribute(name, new Boolean(value), alwaysWrite);
    }

    public void writeAttribute(String name, float value, boolean alwaysWrite) throws IOException {
        this.writeAttribute(name, new Float(value), alwaysWrite);
    }

    public void writeAttribute(String name, double value, boolean alwaysWrite) throws IOException {
        this.writeAttribute(name, new Double(value), alwaysWrite);
    }

    public void writeAttribute(String name, int value, boolean alwaysWrite) throws IOException {
        this.writeAttribute(name, new Integer(value), alwaysWrite);
    }
}

