/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib;

import com.shavenpuppy.jglib.Glyph;
import com.shavenpuppy.jglib.Image;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.lwjgl.util.Point;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;
import org.lwjgl.util.WritablePoint;
import org.lwjgl.util.WritableRectangle;

public final class Font
implements Serializable {
    static final long serialVersionUID = 4L;
    private static final Rectangle tempBounds;
    private static final Point tempPoint;
    private String name;
    private boolean bold;
    private boolean italic;
    private int ascent;
    private int descent;
    private int leading;
    private int size;
    private Glyph[] glyph;
    private int[] map;
    private Image image;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.Font");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        tempBounds = new Rectangle();
        tempPoint = new Point();
    }

    public Font() {
    }

    public Font(String name, boolean bold, boolean italic, Image image, Glyph[] glyph, int size, int ascent, int descent, int leading, int[] map) {
        this.name = name;
        this.bold = bold;
        this.italic = italic;
        this.image = image;
        this.size = size;
        this.ascent = ascent;
        this.descent = descent;
        this.leading = leading;
        this.map = map;
        this.glyph = glyph;
    }

    public static Font importSerialised(String filename) throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.Font");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream fIn = clazz.getClassLoader().getResourceAsStream(filename);
        BufferedInputStream bIn = new BufferedInputStream(fIn);
        ObjectInputStream oIn = new ObjectInputStream(bIn);
        return (Font)oIn.readObject();
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public Glyph getGlyph(int i) {
        return this.glyph[i];
    }

    public int getNumGlyphs() {
        return this.glyph.length;
    }

    public Image getImage() {
        if (!$assertionsDisabled && this.image == null) {
            throw new AssertionError((Object)"Font image has been disposed.");
        }
        return this.image;
    }

    public int getLeading() {
        return this.leading;
    }

    public int getSize() {
        return this.size;
    }

    public Glyph map(char c) {
        if (c >= this.map.length) {
            c = '\u0000';
        }
        if (c == '\t') {
            c = (char)32;
        }
        int m = this.map[c];
        if (!$assertionsDisabled && m == -1) {
            throw new AssertionError((Object)("char " + c + " is not valid"));
        }
        if (m >= this.glyph.length) {
            m = 0;
        }
        return this.glyph[m];
    }

    public Rectangle getStringBounds(String text, int start, int end, Rectangle dest) {
        if (dest == null) {
            dest = new Rectangle();
        } else {
            dest.setBounds(0, 0, 0, 0);
        }
        Glyph last = null;
        int penX = 0;
        int i = start;
        while (i < end) {
            Glyph next = this.map(text.charAt(i));
            next.getBounds((WritableRectangle)tempBounds);
            next.getBearing((WritablePoint)tempPoint);
            tempBounds.setLocation(tempPoint.getX() + penX - next.getKerningAfter(last), tempPoint.getY());
            tempBounds.setWidth(Math.max(tempBounds.getWidth(), next.getAdvance()));
            dest.add((ReadableRectangle)tempBounds);
            penX += next.getAdvance() - next.getKerningAfter(last);
            last = next;
            ++i;
        }
        return dest;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isPlain() {
        return !this.bold && !this.italic;
    }
}

