/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.gamecommerce.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.puppygames.gamecommerce.client.LimitedSizeDocument;
import net.puppygames.gamecommerce.client.WizardGUI;
import net.puppygames.gamecommerce.shared.Countries;
import net.puppygames.gamecommerce.shared.PaymentDetails;
import net.puppygames.gamecommerce.shared.ValidateUtil;

class BuyPage3
extends WizardGUI
implements PaymentDetails.CreditCardAddressDetailsEditor {
    private JLabel address_label;
    private JLabel state_label;
    private JLabel postcode_label;
    private JLabel country_label;
    private JTextField address1_textfield;
    private JTextField address2_textfield;
    private JTextField address3_textfield;
    private JTextField county_textfield;
    private JTextField postcode_textfield;
    private JComboBox country_dropdown;
    private final EventHandler eventHandler = new EventHandler();

    BuyPage3() {
        this.address_label = new JLabel("Address");
        this.state_label = new JLabel("State or County");
        this.postcode_label = new JLabel("Zip or Postcode");
        this.country_label = new JLabel("Country");
        this.address1_textfield = new JTextField(32);
        this.address2_textfield = new JTextField(32);
        this.address3_textfield = new JTextField(32);
        this.county_textfield = new JTextField(32);
        this.postcode_textfield = new JTextField(12);
        this.country_dropdown = new JComboBox<Object>(Countries.getCountries().toArray());
        this.address1_textfield.setDocument(new LimitedSizeDocument(32, false));
        this.address2_textfield.setDocument(new LimitedSizeDocument(32, false));
        this.address3_textfield.setDocument(new LimitedSizeDocument(32, false));
        this.county_textfield.setDocument(new LimitedSizeDocument(32, false));
        this.postcode_textfield.setDocument(new LimitedSizeDocument(12, false));
        this.gui.add((Component)this.address_label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.state_label, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.postcode_label, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.country_label, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.address1_textfield, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.address2_textfield, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.address3_textfield, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.county_textfield, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.postcode_textfield, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.country_dropdown, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.address1_textfield.getDocument().addDocumentListener(this.eventHandler);
        this.address2_textfield.getDocument().addDocumentListener(this.eventHandler);
        this.address3_textfield.getDocument().addDocumentListener(this.eventHandler);
        this.county_textfield.getDocument().addDocumentListener(this.eventHandler);
        this.postcode_textfield.getDocument().addDocumentListener(this.eventHandler);
    }

    public String checkValid() {
        String message = null;
        String cty = this.country_dropdown.getSelectedItem().toString().trim();
        if (!ValidateUtil.isAddress(this.address1_textfield.getText().trim())) {
            message = "You must enter an address.";
        } else if (!ValidateUtil.isAddress(this.address2_textfield.getText().trim())) {
            message = "Illegal address.";
        } else if (!ValidateUtil.isAddress(this.address3_textfield.getText().trim())) {
            message = "Illegal address.";
        } else if (!ValidateUtil.isAddress(this.postcode_textfield.getText().trim())) {
            message = "You must enter a zip or postal code.";
        } else if (cty.length() == 0 || cty.charAt(0) == '-') {
            message = "You must enter a country.";
        } else if (!ValidateUtil.isAddress(this.county_textfield.getText().trim())) {
            message = "You must enter a state or county.";
        }
        this.getWizardDialog().setNextButtonEnabled(message == null, message);
        return message;
    }

    public String getInstructions() {
        return "Please enter the billing address for the credit or debit card.<br><br>Be <b>very sure</b> to select the correct country, or you may be billed an incorrect amount due to local sales taxes.";
    }

    public String getTitle() {
        return "Step 4 of 5";
    }

    public String getAddress1() {
        return this.address1_textfield.getText().trim();
    }

    public String getAddress2() {
        return this.address2_textfield.getText().trim();
    }

    public String getAddress3() {
        return this.address3_textfield.getText().trim();
    }

    public String getCountry() {
        return this.country_dropdown.getSelectedItem().toString().trim();
    }

    public String getPostCode() {
        return this.postcode_textfield.getText().trim();
    }

    public String getStateOrCounty() {
        return this.county_textfield.getText().trim();
    }

    public void setAddress1(String address1) {
        this.address1_textfield.setText(address1);
    }

    public void setAddress2(String address2) {
        this.address2_textfield.setText(address2);
    }

    public void setAddress3(String address3) {
        this.address3_textfield.setText(address3);
    }

    public void setCountry(String country) {
        this.country_dropdown.setSelectedItem(country);
    }

    public void setPostCode(String postCode) {
        this.postcode_textfield.setText(postCode);
    }

    public void setStateOrCounty(String stateOrCounty) {
        this.county_textfield.setText(stateOrCounty);
    }

    public void toPaymentDetails(PaymentDetails paymentDetails) {
        paymentDetails.fromCCAddressGetter(this);
    }

    private class EventHandler
    implements DocumentListener,
    ActionListener {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            BuyPage3.this.checkValid();
        }

        public void changedUpdate(DocumentEvent e) {
            BuyPage3.this.checkValid();
        }

        public void insertUpdate(DocumentEvent e) {
            BuyPage3.this.checkValid();
        }

        public void removeUpdate(DocumentEvent e) {
            BuyPage3.this.checkValid();
        }
    }
}

