/*
 * Decompiled with CFR 0.152.
 */
package puppytron.movements;

import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.AnimatedAppearanceResource;
import com.shavenpuppy.jglib.util.Util;
import net.puppygames.applet.Game;
import puppytron.GameScreen;
import puppytron.Moveable;
import puppytron.Movement;
import puppytron.MovementFeature;

public class ScuttleMovementFeature
extends MovementFeature {
    private static final long serialVersionUID = 1L;
    private static final float MIN_DISTANCE = 32.0f;
    private float distance;
    private String stillAppearance;
    private transient AnimatedAppearanceResource stillAppearanceResource;

    public ScuttleMovementFeature() {
    }

    public ScuttleMovementFeature(String name) {
        super(name);
    }

    public Movement spawn(Moveable gidrah) {
        return new ScuttleMovementInstance(gidrah);
    }

    public int getArmour() {
        return 0;
    }

    public int getHitPoints() {
        return 0;
    }

    public int getScore() {
        return 20;
    }

    public String getSpawnType() {
        return "random";
    }

    public int getDifficulty() {
        return 1;
    }

    protected class ScuttleMovementInstance
    extends MovementFeature.MovementInstance {
        private int tick;
        private float vx;
        private float vy;
        private float dist;
        private boolean delay;

        protected ScuttleMovementInstance(Moveable gidrah) {
            super(gidrah);
        }

        private void chooseTarget() {
            float ty;
            float tx;
            if (this.dist == 0.0f) {
                tx = Util.random((int)16, (int)(Game.getWidth() - 16));
                ty = Util.random((int)16, (int)(Game.getHeight() - 16));
            } else {
                int count = 0;
                do {
                    double angle = Math.random() * Math.PI * 2.0;
                    tx = GameScreen.getPlayer().getX() + (float)Math.cos(angle) * Math.max(32.0f, this.dist - (float)GameScreen.getPlayer().getAccumulatedMultiplier());
                    ty = GameScreen.getPlayer().getY() + (float)Math.sin(angle) * Math.max(32.0f, this.dist - (float)GameScreen.getPlayer().getAccumulatedMultiplier());
                } while (++count < 3 && (tx < 16.0f || ty < 16.0f || tx > (float)(Game.getWidth() - 16) || ty > (float)(Game.getHeight() - 16)));
            }
            this.vx = tx - this.gidrah.getX();
            this.vy = ty - this.gidrah.getY();
            this.dist = (float)Math.sqrt((double)(this.vx * this.vx + this.vy * this.vy) + 0.001);
            this.gidrah.setVelocity(this.vx * ScuttleMovementFeature.this.getSpeed() / this.dist, this.vy * ScuttleMovementFeature.this.getSpeed() / this.dist);
            this.tick = (int)(this.dist / ScuttleMovementFeature.this.getSpeed());
            this.delay = false;
        }

        public void tick(Moveable moveableGidrah) {
            if (this.delay) {
                if (moveableGidrah.getEvent() == 2) {
                    moveableGidrah.setEvent(0);
                    this.chooseTarget();
                } else {
                    return;
                }
            }
            --this.tick;
            if (this.tick <= 0) {
                this.delay = true;
                moveableGidrah.setVelocity(0.0f, 0.0f);
                moveableGidrah.setAppearance((AnimatedAppearance)ScuttleMovementFeature.this.stillAppearanceResource);
            }
        }
    }
}

