/*
 * Decompiled with CFR 0.152.
 */
package puppytron;

import com.shavenpuppy.jglib.util.Util;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.effects.LabelEffect;
import org.lwjgl.util.Color;
import puppytron.Bullet;
import puppytron.Entity;
import puppytron.GameScreen;
import puppytron.Player;
import puppytron.Puppytron;
import puppytron.Res;
import puppytron.powerups.AttackDronePowerup;
import puppytron.powerups.BouncyPowerup;
import puppytron.powerups.DamagePowerup;
import puppytron.powerups.DefenceDronePowerup;
import puppytron.powerups.FreezePowerup;
import puppytron.powerups.GunPowerup;
import puppytron.powerups.InvulnerabilityPowerup;
import puppytron.powerups.RechargePowerup;
import puppytron.powerups.ScorePowerup;
import puppytron.powerups.ShieldPowerup;
import puppytron.powerups.SmartBombPowerup;
import puppytron.powerups.ThreeWayPowerup;

public abstract class Powerup
extends Entity {
    protected String type;
    private static final int INSET = 32;

    public Powerup(String type) {
        this.type = type;
        this.x = Util.random((int)0, (int)((Puppytron.getWidth() - 32 - 64) / 16 * 16)) + 16 + 32;
        this.y = Util.random((int)0, (int)((Puppytron.getHeight() - 32 - 64) / 16)) * 16 + 16 + 32;
    }

    protected void respawn(Powerup next) {
    }

    protected void doRespawn() {
    }

    protected abstract Powerup getNextType();

    public boolean canCollide() {
        return true;
    }

    public float getRadius() {
        return 7.0f;
    }

    public void onCollision(Entity entity) {
        entity.onCollisionWithPowerup(this);
    }

    protected final void onCollisionWithPlayer(Player player) {
        this.collect();
        this.remove();
    }

    protected void onCollisionWithBullet(Bullet bullet) {
        Emitter emitter = Res.getPowerupRicochetEmitterFeature().spawn((Screen)GameScreen.getInstance());
        emitter.setLocation(this.x, this.y);
        Powerup newPowerup = this.getNextType();
        if (this.getNextType() == null) {
            return;
        }
        this.remove();
        newPowerup.x = this.x;
        newPowerup.y = this.y;
        newPowerup.spawn(GameScreen.getInstance());
    }

    protected void collect() {
        Emitter emitter = Res.getPowerupCollectEmitterFeature().spawn((Screen)GameScreen.getInstance());
        emitter.setLocation(this.x, this.y);
        LabelEffect le = new LabelEffect(Res.getSmallFont(), this.getMessage(), Color.YELLOW, Color.RED, 40, 20);
        le.setVelocity(0.0f, 2.0f);
        le.setAcceleration(0.0f, -0.05f);
        le.setLocation((float)((int)this.x), (float)((int)this.y));
        le.setVisible(true);
        le.spawn((Screen)GameScreen.getInstance());
    }

    protected String getMessage() {
        return this.type;
    }

    public static Powerup createPowerup() {
        switch (Util.random((int)0, (int)4)) {
            case 0: {
                return new GunPowerup();
            }
            case 1: {
                return new DamagePowerup();
            }
            case 2: {
                return new SmartBombPowerup();
            }
            case 3: {
                return new ShieldPowerup();
            }
        }
        return new ScorePowerup();
    }

    public static Powerup createExoticPowerup() {
        int count = 0;
        block8: while (++count < 4) {
            switch (Util.random((int)0, (int)6)) {
                case 0: {
                    return new AttackDronePowerup();
                }
                case 1: {
                    return new DefenceDronePowerup();
                }
                case 2: {
                    if (GameScreen.getPlayer().isInvulnerable()) continue block8;
                    return new InvulnerabilityPowerup();
                }
                case 3: {
                    if (GameScreen.getPlayer().getShields() > 5) continue block8;
                    return new RechargePowerup();
                }
                case 4: {
                    return new FreezePowerup();
                }
                case 5: {
                    if (GameScreen.getPlayer().isThreeWay()) continue block8;
                    return new ThreeWayPowerup();
                }
                default: {
                    if (GameScreen.getPlayer().isBouncy()) continue block8;
                    return new BouncyPowerup();
                }
            }
        }
        return new DefenceDronePowerup();
    }
}

