/*
 * Decompiled with CFR 0.152.
 */
package puppytron;

import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.Sprite;
import net.puppygames.applet.Binding;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.effects.LabelEffect;
import net.puppygames.applet.effects.StrobeEffect;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.Color;
import puppytron.Bomb;
import puppytron.Bullet;
import puppytron.BulletFeature;
import puppytron.EnemyBullet;
import puppytron.Entity;
import puppytron.GameScreen;
import puppytron.Gidrah;
import puppytron.Mine;
import puppytron.Puppytron;
import puppytron.Res;
import puppytron.Saucer;

public class Player
extends Entity {
    private static final long serialVersionUID = 1L;
    int phase;
    static final int PHASE_SPAWNING = 0;
    static final int PHASE_ALIVE = 1;
    static final int PHASE_DEAD = 2;
    private static final float DEFAULT_RADIUS = 8.0f;
    private static final float SHIELD_RADIUS = 18.0f;
    int tick;
    int shields = 5;
    int facing = 1;
    int bulletTick = 0;
    private int accumulatedMultiplier;
    private int invulnerability;
    private static final int INVULNERABILITY_TIME = 900;
    private Sprite shieldSprite;
    private transient SoundEffect invulnerabilitySound;
    private boolean threeWay;
    private boolean bouncy;
    public static final int DEFAULT_REPEAT_RATE = 12;
    public static final int MAX_REPEAT_RATE = 30;
    public static final int MIN_REPEAT_RATE = 4;
    private int repeatRate = 12;
    private int bulletPower = 1;
    int bonus = 1000;
    private int multiplier = 1;
    private boolean wasDamaged = false;
    public static final int DEFAULT_MEGABONUS = 1000;
    int megaBonus = 1000;
    public static final int MAX_MEGABONUS = 25000;
    public static final int MEGABONUS_ADDER = 1000;
    public static final int BONUS_ADDER = 100;
    private static final int SPEED = 2;
    private Sprite crosshair;
    static final int SPAWN_DURATION = 60;
    static final int EXIT_DURATION = 120;
    static final int DEAD_DURATION = 240;
    int immune;
    static final int IMMUNE_TIME = 8;
    static /* synthetic */ Class class$0;

    protected void doSpawn() {
        this.x = Puppytron.getWidth() / 2;
        this.y = Puppytron.getHeight() / 2;
        this.visible = true;
        this.phase = 0;
        this.tick = 0;
        this.sprite.setAppearance(Res.getPlayerAppearance());
        this.facing = 1;
        this.sprite.setPaused(true);
        this.sprite.setLocation((int)this.x, (int)this.y, 0);
        this.crosshair = GameScreen.instance.allocateSprite(this);
        this.crosshair.setLayer(4);
        this.crosshair.setAppearance((AnimatedAppearance)Res.getCrosshair());
    }

    protected void doRespawn() {
        this.immune = 120;
        if (this.isInvulnerable()) {
            this.invulnerabilitySound = Game.allocateSound((ALBuffer)Res.getInvulnerabilitySound());
        }
    }

    protected void doRemove() {
        if (this.shieldSprite != null) {
            this.shieldSprite.deallocate();
            this.shieldSprite = null;
        }
        if (this.invulnerabilitySound != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("net.puppygames.applet.Game");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.invulnerabilitySound.stop((Object)clazz);
            this.invulnerabilitySound = null;
        }
        if (this.crosshair != null) {
            this.crosshair.deallocate();
            this.crosshair = null;
        }
    }

    protected void doTick() {
        if (this.invulnerability > 0) {
            --this.invulnerability;
            if (this.invulnerability == 0) {
                this.shieldSprite.deallocate();
                this.shieldSprite = null;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("net.puppygames.applet.Game");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.invulnerabilitySound.stop((Object)clazz);
                this.invulnerabilitySound = null;
            } else if (this.invulnerability < 120) {
                if (this.shieldSprite != null) {
                    this.shieldSprite.setVisible((this.invulnerability & 4) == 0);
                }
                if (this.invulnerabilitySound != null) {
                    float f = (this.invulnerability & 4) == 0 ? Game.getSFXVolume() * Res.getInvulnerabilitySound().getGain() : 0.0f;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("net.puppygames.applet.Game");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.invulnerabilitySound.setGain(f, (Object)clazz);
                }
            }
        }
        switch (this.phase) {
            case 0: {
                this.doSpawnTick();
            }
            case 1: {
                this.doAliveTick();
                break;
            }
            case 2: {
                this.doDeadTick();
            }
        }
        if (this.shieldSprite != null) {
            this.shieldSprite.setLocation((int)this.getX(), (int)this.getY(), 0);
        }
    }

    private void doSpawnTick() {
        ++this.tick;
        if (this.tick > 60) {
            this.tick = 0;
            this.phase = 1;
            this.visible = true;
        } else {
            this.visible = (this.tick & 4) == 0;
        }
    }

    private void doAliveTick() {
        this.vy = Binding.isBindingDown((String)"move.up.binding") || Binding.isBindingDown((String)"move.up.binding.alt") ? 2.0f : (Binding.isBindingDown((String)"move.down.binding") || Binding.isBindingDown((String)"move.down.binding.alt") ? -2.0f : 0.0f);
        int oldFacing = this.facing;
        if (Binding.isBindingDown((String)"move.left.binding") || Binding.isBindingDown((String)"move.left.binding.alt")) {
            this.vx = -2.0f;
            this.facing = -1;
        } else if (Binding.isBindingDown((String)"move.right.binding") || Binding.isBindingDown((String)"move.right.binding.alt")) {
            this.vx = 2.0f;
            this.facing = 1;
        } else {
            this.vx = 0.0f;
        }
        if (this.vx != 0.0f && this.vy != 0.0f) {
            this.vx *= 0.707f;
            this.vy *= 0.707f;
        }
        if (this.x + this.vx < 8.0f || this.x + this.vx >= (float)Puppytron.getWidth() - 8.0f) {
            this.vx = 0.0f;
        }
        if (this.y + this.vy < 8.0f || this.y + this.vy >= (float)Puppytron.getHeight() - 8.0f) {
            this.vy = 0.0f;
        }
        int mouseX = GameScreen.instance.getMouseX();
        int mouseY = GameScreen.instance.getMouseY();
        this.crosshair.setLocation(mouseX, mouseY, 0);
        if (this.bulletTick > 0) {
            --this.bulletTick;
        } else {
            boolean fire = false;
            float fx = this.x;
            float fy = this.y;
            if (Binding.isBindingDown((String)"shoot.up.binding") || Binding.isBindingDown((String)"shoot.up.binding.alt")) {
                fire = true;
                fy = this.y + 160.0f;
            } else if (Binding.isBindingDown((String)"shoot.down.binding") || Binding.isBindingDown((String)"shoot.down.binding.alt")) {
                fire = true;
                fy = this.y - 160.0f;
            }
            if (Binding.isBindingDown((String)"shoot.left.binding") || Binding.isBindingDown((String)"shoot.left.binding.alt")) {
                fire = true;
                fx = this.x - 160.0f;
            } else if (Binding.isBindingDown((String)"shoot.right.binding") || Binding.isBindingDown((String)"shoot.right.binding.alt")) {
                fire = true;
                fx = this.x + 160.0f;
            }
            if (Mouse.isButtonDown((int)0)) {
                fx = mouseX;
                fy = mouseY;
                fire = true;
                Puppytron.setUsingMouse(true);
            }
            if (fire) {
                this.fire(fx, fy);
            }
        }
        if (this.vx != 0.0f || this.vy != 0.0f) {
            if (this.facing != oldFacing) {
                this.sprite.setMirrored(this.facing == -1);
            }
            this.sprite.setPaused(false);
        } else {
            this.sprite.setPaused(true);
        }
        if (this.immune > 0) {
            --this.immune;
            this.flash = (this.immune & 2) == 2;
        }
    }

    private void fire(float tx, float ty) {
        this.fire0(tx, ty);
        if (this.threeWay) {
            this.bulletTick = this.repeatRate * 2;
            double dx = tx - this.x;
            double dy = ty - this.y;
            double angle = Math.atan2(dy, dx);
            this.fire0((float)((double)this.x + Math.cos(angle + 0.7853981633974483) * 160.0), (float)((double)this.y + Math.sin(angle + 0.7853981633974483) * 160.0));
            this.fire0((float)((double)this.x + Math.cos(angle - 0.7853981633974483) * 160.0), (float)((double)this.y + Math.sin(angle - 0.7853981633974483) * 160.0));
        } else {
            this.bulletTick = this.repeatRate;
        }
    }

    private void fire0(float tx, float ty) {
        Bullet b = BulletFeature.getGun(this.bulletPower - 1).spawn(GameScreen.getInstance());
        if (!b.isActive()) {
            return;
        }
        b.init(this.x, this.y, tx, ty);
    }

    public boolean isBouncy() {
        return this.bouncy;
    }

    private void doDeadTick() {
        ++this.tick;
        if (this.tick > 240) {
            this.remove();
            Puppytron.gameOver();
        }
    }

    public int getShields() {
        return this.shields;
    }

    public int getRepeatRate() {
        return this.repeatRate;
    }

    public void setRepeatRate(int newRate) {
        this.repeatRate = newRate;
    }

    public void setShields(int shields) {
        this.shields = shields;
    }

    public boolean canCollide() {
        return this.phase == 1;
    }

    public float getRadius() {
        return this.invulnerability > 0 ? 18.0f : 8.0f;
    }

    public void onCollision(Entity entity) {
        entity.onCollisionWithPlayer(this);
    }

    protected void onCollisionWithEnemyBullet(EnemyBullet enemyBullet) {
        this.damage(1);
    }

    protected void onCollisionWithBomb(Bomb bomb) {
        this.damage(1);
    }

    protected void onCollisionWithMine(Mine mine) {
        this.damage(1);
    }

    protected void onCollisionWithSaucer(Saucer saucer) {
        if (GameScreen.isChallengeMode()) {
            return;
        }
        this.damage(1);
    }

    protected void onCollisionWithGidrah(Gidrah gidrah) {
        if (gidrah.isDangerous()) {
            this.damage(1);
        }
    }

    public void damage(int amount) {
        if (this.immune > 0 || GameScreen.isImmune() || this.invulnerability > 0) {
            return;
        }
        this.shields -= amount;
        this.immune = 8;
        this.bouncy = false;
        this.threeWay = false;
        this.deactivateBonus();
        this.wasDamaged = true;
        StrobeEffect se = new StrobeEffect(Color.RED, 30);
        se.spawn((Screen)GameScreen.getInstance());
        if (this.shields < 0) {
            this.kill();
        } else {
            Emitter emitter = Res.getPlayerDamagedEmitter().spawn((Screen)GameScreen.getInstance());
            emitter.setLocation(this.x, this.y);
        }
    }

    public void deactivateBonus() {
        if (this.multiplier < 2) {
            return;
        }
        this.multiplier = 1;
        LabelEffect le = new LabelEffect(Res.getSmallFont(), "Multiplier Deactivated", Color.YELLOW, Color.GREEN, 80, 40);
        le.setVelocity(0.0f, -1.0f);
        le.setAcceleration(0.0f, 0.008f);
        le.setLocation((float)((int)this.x), (float)((int)this.y));
        le.setVisible(true);
        le.setSound(Res.getBonusDeactivated());
        le.spawn((Screen)GameScreen.getInstance());
    }

    public void updateAccumulatedMultiplier() {
        this.accumulatedMultiplier += this.multiplier;
    }

    public int getAccumulatedMultiplier() {
        return this.accumulatedMultiplier;
    }

    public void kill() {
        this.phase = 2;
        this.tick = 0;
        this.visible = false;
        this.vx = 0.0f;
        this.vy = 0.0f;
        Emitter emitter = Res.getPlayerDeathEmitter().spawn((Screen)GameScreen.getInstance());
        emitter.setLocation(this.x, this.y);
        if (this.shieldSprite != null) {
            this.shieldSprite.deallocate();
            this.shieldSprite = null;
        }
        if (this.invulnerabilitySound != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("net.puppygames.applet.Game");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.invulnerabilitySound.stop((Object)clazz);
            this.invulnerabilitySound = null;
        }
        if (this.crosshair != null) {
            this.crosshair.deallocate();
            this.crosshair = null;
        }
    }

    public boolean incMultipler() {
        if (!this.wasDamaged && this.multiplier < 5) {
            ++this.multiplier;
            return true;
        }
        this.wasDamaged = false;
        return false;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public int getBulletPower() {
        return this.bulletPower;
    }

    public void setBulletPower(int bulletPower) {
        this.bulletPower = bulletPower;
    }

    public int getBonus() {
        return this.bonus;
    }

    public void resetMegaBonus() {
        this.megaBonus = 1000;
    }

    public int getMegaBonus() {
        return this.megaBonus;
    }

    public void nextMegaBonus() {
        this.megaBonus = Math.min(25000, this.megaBonus + 1000);
    }

    public void nextBonus() {
        this.bonus += 100;
    }

    public void setInvulnerability() {
        if (this.invulnerability == 0) {
            this.shieldSprite = GameScreen.getInstance().allocateSprite(this);
            this.shieldSprite.setAppearance((AnimatedAppearance)Res.getInvulnerabilityAppearance());
            this.shieldSprite.setLayer(3);
            this.shieldSprite.setLocation((int)this.getX(), (int)this.getY(), 0);
            this.invulnerabilitySound = Game.allocateSound((ALBuffer)Res.getInvulnerabilitySound());
        }
        this.invulnerability += 900;
    }

    public boolean isInvulnerable() {
        return this.invulnerability > 0;
    }

    public void setThreeWay() {
        this.threeWay = true;
    }

    public boolean isThreeWay() {
        return this.threeWay;
    }

    public void setBouncy() {
        this.bouncy = true;
    }
}

