/*
 * Decompiled with CFR 0.152.
 */
package puppytron;

import com.shavenpuppy.jglib.TextLayout;
import com.shavenpuppy.jglib.interpolators.ColorInterpolator;
import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLTextArea;
import net.puppygames.applet.Area;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.widgets.PowerDisplay;
import net.puppygames.applet.widgets.PowerDisplayFeature;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;
import org.lwjgl.util.WritableColor;
import puppytron.Background;
import puppytron.Entity;
import puppytron.Gidrah;
import puppytron.GidrahFeature;
import puppytron.Player;
import puppytron.Puppytron;
import puppytron.PuppytronGameState;
import puppytron.Res;

public class GameScreen
extends Screen {
    private static final long serialVersionUID = 1L;
    static final String GAMEOVER = "gameover";
    static final String PROGRESS = "progress";
    private static final String HUD_FRONT = "hud_front";
    private static final String HUD_BACK = "hud_back";
    private static final String SHIELDS_EMPTY = "shields_empty";
    static final String[] BOSS_NAMES = new String[]{"IEIUNITAS", "BELLUM", "LUES", "LETUM"};
    static GameScreen instance;
    private static final Color cachedColor;
    public static final int LEVELS_PER_BOSS = 10;
    public static final int LEVELS_PER_CHALLENGE = 7;
    public static final int LEVELS_PER_ASSAULT = 5;
    static final int INITIAL_BOT_SPAWN_RATE = 70;
    static final int MIN_BOT_SPAWN_RATE = 30;
    static final int BOT_SPAWN_RATE_ADJUSTER = 2;
    static final int INITIAL_SAUCER_SPAWN_RATE = 3000;
    static final int MIN_SAUCER_SPAWN_RATE = 1000;
    static final int SAUCER_SPAWN_RATE_ADJUSTER = 50;
    static final int GUN_SPAWN_RATE_ADJUSTER = 1;
    static final int PHASE_WAIT = 0;
    static final int PHASE_PLAY = 1;
    static final int PHASE_WAIT_FOR_BOSS = 2;
    static final int PHASE_BOSS = 3;
    static final int PHASE_NOTHING = 4;
    static final int PHASE_GAMEOVER = 5;
    static final int PHASE_WAIT_FOR_CHALLENGE = 6;
    static final int PHASE_CHALLENGE_BEGIN = 7;
    static final int PHASE_CHALLENGE = 8;
    static final int PHASE_CHALLENGE_END = 9;
    static final int CHALLENGE_BEGIN_DURATION = 360;
    static final int CHALLENGE_DURATION = 800;
    static final int CHALLENGE_DURATION_PER_LEVEL = 10;
    static final int CHALLENGE_SPAWN_RATE = 60;
    static final int MIN_CHALLENGE_SPAWN_RATE = 20;
    static final int CHALLENGE_SPAWN_RATE_PER_LEVEL = 2;
    static final int CHALLENGE_END_DURATION = 360;
    static final int BOTS_PER_ASSAULT = 30;
    static final float BOTS_PER_LEVEL_IN_ASSAULT = 0.25f;
    static final int WAIT_DURATION = 240;
    static final int GAMEOVER_DURATION = 240;
    public static final int LEVEL_DURATION = 2200;
    private static int hudAlpha;
    private static Color oldBackgroundColor;
    static PuppytronGameState gameState;
    private static Background background;
    private static int backgroundFadeTick;
    private static int backgroundFadePhase;
    private static final int FADE_OUT = 0;
    private static final int SWAP = 1;
    private static final int FADE_IN = 2;
    private static final int DONE = 3;
    private static boolean immune;
    private PowerDisplayFeature shieldsDisplay;
    PowerDisplayFeature progressDisplay;
    private Rectangle scoreBounds;
    private Rectangle bonusBounds;
    private Rectangle levelBounds;
    private Rectangle timerBounds;
    private Color timeColorLeft;
    private Color timeColorRight;
    private transient GLTextArea scoreLabel;
    private transient GLTextArea bonusLabel;
    private transient GLTextArea levelLabel;
    private transient PowerDisplay shieldPowerInstance;
    private transient int displayedScore;
    private transient int displayedBonus;
    private transient int displayedLevel;
    transient PowerDisplay progressInstance;
    private transient Area shieldsEmpty;

    static {
        cachedColor = new Color();
        hudAlpha = 255;
        oldBackgroundColor = new Color(Color.BLACK);
    }

    public GameScreen(String name) {
        super(name);
    }

    protected void doRegister() {
        instance = this;
    }

    protected void doDeregister() {
        instance = null;
    }

    public static int getLevel() {
        return gameState.getLevel();
    }

    protected void onOpen() {
        this.shieldPowerInstance = this.shieldsDisplay.spawn((Screen)this);
        this.setVisible(PROGRESS, false);
        this.displayedBonus = -1;
        this.displayedScore = -1;
        this.displayedLevel = -1;
    }

    public static boolean isImmune() {
        return immune;
    }

    public static boolean isLevelTimedOut() {
        return gameState.getPhase() == 0;
    }

    protected void doTick() {
        if (Puppytron.isPaused()) {
            return;
        }
        Puppytron.onTicked();
        gameState.tick();
        Player player = gameState.getPlayer();
        if (player != null) {
            this.shieldPowerInstance.setUsed(player.getShields());
            if (player.getShields() == 0 && this.shieldsEmpty != null && !this.shieldsEmpty.isVisible()) {
                this.shieldsEmpty.setVisible(true);
            } else if (this.shieldsEmpty != null && this.shieldsEmpty.isVisible() && player.getShields() > 0) {
                this.shieldsEmpty.setVisible(false);
            }
            if (Keyboard.isKeyDown((int)1) && player.canCollide()) {
                Game.saveGame();
                player.kill();
            }
        }
        while (Keyboard.next()) {
        }
        gameState.tickAllEntities();
        if (player != null && player.getY() > 280.0f) {
            if (hudAlpha > 32) {
                hudAlpha = Math.max(32, hudAlpha - 16);
            }
        } else if (hudAlpha < 255) {
            hudAlpha = Math.min(255, hudAlpha + 16);
        }
        this.getArea(HUD_BACK).setAlpha(hudAlpha);
        this.getArea(HUD_FRONT).setAlpha(hudAlpha);
        this.getArea(SHIELDS_EMPTY).setAlpha(hudAlpha);
        this.shieldPowerInstance.setAlpha(hudAlpha);
    }

    public static int getTick() {
        return gameState.getTick();
    }

    public static int getTotalTicks() {
        int oldTotalTicks = gameState.getTotalTicks();
        gameState.resetTotalTicks();
        return oldTotalTicks;
    }

    public static void beginGame(PuppytronGameState newGameState) {
        gameState = newGameState;
        instance.setVisible(GAMEOVER, false);
        instance.open();
    }

    static void initBackground() {
        boolean advance = false;
        Background newBackground = Background.getBackground(GameScreen.getLevel());
        if (newBackground != background) {
            if (background != null) {
                background.remove();
                oldBackgroundColor = background.getColor();
                background = null;
                backgroundFadePhase = 0;
            } else {
                advance = true;
                backgroundFadePhase = 2;
            }
            backgroundFadeTick = 0;
            background = newBackground;
            background.spawn(instance);
            if (advance) {
                background.advance();
            }
        }
    }

    static void initArena() {
        boolean advance = false;
        if (background != null) {
            background.remove();
            oldBackgroundColor = background.getColor();
            background = null;
            backgroundFadePhase = 0;
        } else {
            advance = true;
            backgroundFadePhase = 2;
        }
        backgroundFadeTick = 0;
        background = Background.getArena(GameScreen.getLevel() / 5 - 1);
        background.spawn(instance);
        if (advance) {
            background.advance();
        }
    }

    static void initLevel() {
        GidrahFeature.resetDifficulty();
        GameScreen.initBackground();
        gameState.setTick(0);
    }

    public static void gameOver() {
        instance.setVisible(GAMEOVER, true);
        Puppytron.playMusic(null, (int)180);
        gameState.setPhase(5);
        gameState.setTick(0);
    }

    protected void doCleanup() {
        if (background != null) {
            background.cleanup();
            background = null;
        }
        this.shieldPowerInstance.cleanup();
        this.shieldPowerInstance = null;
        if (this.progressInstance != null) {
            this.progressInstance.cleanup();
            this.progressInstance = null;
        }
    }

    protected void doCreateScreen() throws Exception {
        this.shieldsEmpty = this.getArea(SHIELDS_EMPTY);
        this.scoreLabel = new GLTextArea();
        this.scoreLabel.setBounds((ReadableRectangle)this.scoreBounds);
        this.scoreLabel.setFont(Res.getSmallFont());
        this.scoreLabel.setHorizontalAlignment(TextLayout.RIGHT);
        this.scoreLabel.setVerticalAlignment(GLTextArea.BOTTOM);
        this.bonusLabel = new GLTextArea();
        this.bonusLabel.setBounds((ReadableRectangle)this.bonusBounds);
        this.bonusLabel.setFont(Res.getSmallFont());
        this.bonusLabel.setVerticalAlignment(GLTextArea.BOTTOM);
        this.levelLabel = new GLTextArea();
        this.levelLabel.setBounds((ReadableRectangle)this.levelBounds);
        this.levelLabel.setHorizontalAlignment(TextLayout.RIGHT);
        this.levelLabel.setFont(Res.getSmallFont());
        this.levelLabel.setVerticalAlignment(GLTextArea.BOTTOM);
        this.setDefaultScreen();
    }

    protected void preRender() {
        switch (backgroundFadePhase) {
            case 0: {
                if (++backgroundFadeTick < 20) {
                    float ratio = (float)backgroundFadeTick / 20.0f;
                    ColorInterpolator.interpolate((ReadableColor)oldBackgroundColor, (ReadableColor)Color.BLACK, (float)ratio, (Interpolator)LinearInterpolator.instance, (WritableColor)cachedColor);
                    ++backgroundFadeTick;
                    break;
                }
                cachedColor.setColor(Color.BLACK);
                backgroundFadePhase = 1;
                backgroundFadeTick = 0;
                break;
            }
            case 1: {
                cachedColor.setColor(Color.BLACK);
                if (++backgroundFadeTick < 20) break;
                backgroundFadePhase = 2;
                backgroundFadeTick = 0;
                break;
            }
            case 2: {
                if (++backgroundFadeTick < 20) {
                    float ratio = (float)backgroundFadeTick / 20.0f;
                    ColorInterpolator.interpolate((ReadableColor)Color.BLACK, (ReadableColor)background.getColor(), (float)ratio, (Interpolator)LinearInterpolator.instance, (WritableColor)cachedColor);
                    break;
                }
                cachedColor.setColor((ReadableColor)background.getColor());
                backgroundFadePhase = 3;
                backgroundFadeTick = 0;
                break;
            }
            case 3: {
                cachedColor.setColor((ReadableColor)background.getColor());
            }
        }
        ColorUtil.setGLColor((ReadableColor)cachedColor);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glRecti((int)0, (int)0, (int)Game.getWidth(), (int)Game.getHeight());
    }

    protected void postRender() {
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)((float)hudAlpha * 0.5f / 255.0f));
        if (this.displayedScore != Puppytron.getScore()) {
            this.displayedScore = Puppytron.getScore();
            this.scoreLabel.setText(String.valueOf(this.displayedScore));
        }
        if (this.displayedLevel != GameScreen.getLevel()) {
            this.displayedLevel = GameScreen.getLevel();
            this.levelLabel.setText(String.valueOf(this.displayedLevel));
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)2.0f, (float)-2.0f, (float)0.0f);
        this.scoreLabel.render();
        this.levelLabel.render();
        GL11.glPopMatrix();
        GL11.glColor4ub((byte)-1, (byte)-1, (byte)-1, (byte)((byte)hudAlpha));
        this.scoreLabel.render();
        this.levelLabel.render();
        int mult = gameState.getPlayer().getMultiplier();
        if (mult != this.displayedBonus) {
            this.bonusLabel.setText(String.valueOf(mult));
            this.displayedBonus = mult;
        }
        if (mult > 1) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)2.0f, (float)-2.0f, (float)0.0f);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)((float)hudAlpha * 0.5f / 255.0f));
            this.bonusLabel.render();
            GL11.glPopMatrix();
            GL11.glColor4ub((byte)-1, (byte)-1, (byte)-1, (byte)((byte)hudAlpha));
            this.bonusLabel.render();
        }
        if (gameState.getPhase() == 1) {
            int ld = GameScreen.isAssaultLevel() ? 550 : 2200;
            GL11.glDisable((int)3553);
            int timeLeft = ld - Math.min(ld, gameState.getTick());
            float ratio = (float)timeLeft / (float)ld;
            ColorInterpolator.interpolate((ReadableColor)this.timeColorLeft, (ReadableColor)this.timeColorRight, (float)ratio, (Interpolator)LinearInterpolator.instance, (WritableColor)cachedColor);
            cachedColor.setAlpha(hudAlpha);
            int x2 = (int)LinearInterpolator.instance.interpolate((float)this.timerBounds.getX(), (float)(this.timerBounds.getX() + this.timerBounds.getWidth()), ratio);
            GL11.glBegin((int)7);
            GL11.glColor4ub((byte)this.timeColorLeft.getRedByte(), (byte)this.timeColorLeft.getGreenByte(), (byte)this.timeColorLeft.getBlueByte(), (byte)((byte)hudAlpha));
            GL11.glVertex2i((int)this.timerBounds.getX(), (int)this.timerBounds.getY());
            ColorUtil.setGLColor((ReadableColor)cachedColor);
            GL11.glVertex2i((int)x2, (int)this.timerBounds.getY());
            GL11.glVertex2i((int)x2, (int)(this.timerBounds.getY() + this.timerBounds.getHeight()));
            GL11.glColor4ub((byte)this.timeColorLeft.getRedByte(), (byte)this.timeColorLeft.getGreenByte(), (byte)this.timeColorLeft.getBlueByte(), (byte)((byte)hudAlpha));
            GL11.glVertex2i((int)this.timerBounds.getX(), (int)(this.timerBounds.getY() + this.timerBounds.getHeight()));
            GL11.glEnd();
        }
    }

    public static Player getPlayer() {
        return gameState.getPlayer();
    }

    public static boolean isChallengeMode() {
        return gameState.getPhase() == 7 || gameState.getPhase() == 9 || gameState.getPhase() == 8;
    }

    static boolean isAssaultLevel() {
        return gameState.getLevel() % 5 == 0 && gameState.getLevel() % 10 != 0;
    }

    public static void addEntity(Entity entity) {
        instance.addTickable(entity);
        gameState.addEntity(entity);
    }

    public static GameScreen getInstance() {
        return instance;
    }

    public static void freezeGidrahs() {
        gameState.freezeGidrahs();
    }

    public static Gidrah getRandomGidrah() {
        return gameState.getRandomGidrah();
    }

    public static void onExit() {
        if (instance != null && instance.isOpen()) {
            Game.saveGame();
        }
    }
}

