/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.openal.ALBuffer;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.Tickable;
import org.lwjgl.util.ReadablePoint;

public abstract class Effect
implements Tickable {
    private int delay = 1;
    private Screen screen;
    private ALBuffer sound;
    private boolean visible = true;
    private ReadablePoint offset;
    private boolean spawned;

    public void setOffset(ReadablePoint offset) {
        this.offset = offset;
    }

    public ReadablePoint getOffset() {
        return this.offset;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void setVisible(boolean visible) {
        this.visible = visible;
        this.onSetVisible();
    }

    protected void onSetVisible() {
    }

    public boolean isStarted() {
        return this.delay == 0;
    }

    public void start() {
        this.delay = 0;
        if (this.sound != null) {
            Game.allocateSound(this.sound);
        }
        this.init();
    }

    public final void spawn(Screen screen) {
        if (this.spawned) {
            return;
        }
        this.screen = screen;
        if (this.isBackgroundEffect()) {
            screen.addBackgroundEffect(this);
        } else {
            screen.addForegroundEffect(this);
        }
        this.doSpawn();
        this.spawned = true;
    }

    protected Screen getScreen() {
        return this.screen;
    }

    protected void doSpawn() {
    }

    public final void setDelay(int delay) {
        this.delay = delay;
    }

    public final void tick() {
        if (this.delay > 0) {
            --this.delay;
            if (this.delay == 0) {
                this.start();
            }
        }
        if (this.delay == 0) {
            this.doTick();
        }
    }

    public void update() {
        if (this.delay == 0) {
            this.doUpdate();
        }
    }

    protected void doUpdate() {
    }

    public final void setSound(ALBuffer sound) {
        this.sound = sound;
    }

    protected void init() {
    }

    protected abstract void doTick();

    public final void render() {
        if (this.delay == 0 && this.visible) {
            this.doRender();
        }
    }

    protected abstract void doRender();

    public void finish() {
        this.remove();
    }

    public boolean isFinished() {
        return !this.isActive();
    }

    public final void remove() {
        if (!this.spawned) {
            return;
        }
        if (this.isBackgroundEffect()) {
            this.screen.removeBackgroundEffect(this);
        } else {
            this.screen.removeForegroundEffect(this);
        }
        this.doRemove();
        this.spawned = false;
    }

    protected void doRemove() {
    }

    public boolean isBackgroundEffect() {
        return false;
    }
}

