/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.interpolators.ColorInterpolator;
import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.WritableColor;

public class ColorSequence {
    public static final long serialVersionUID = 1L;
    private ArrayList sequence;
    private transient int duration;
    private int style;
    private transient int[] index;
    public static final int STOP = 0;
    public static final int REPEAT = 1;

    public ColorSequence(SequenceEntry[] entries, int style) {
        this.style = style;
        this.sequence = new ArrayList(entries.length);
        this.index = new int[entries.length];
        int i = 0;
        while (i < entries.length) {
            this.sequence.add(entries[i]);
            this.index[i] = this.duration;
            this.duration += entries[i].duration;
            ++i;
        }
    }

    public static int decode(String styleS) throws Exception {
        if (styleS.equalsIgnoreCase("repeat")) {
            return 1;
        }
        if (styleS.equalsIgnoreCase("stop")) {
            return 0;
        }
        throw new Exception("Illegal style '" + styleS + "'");
    }

    public boolean isLooped() {
        return this.style == 1;
    }

    public ReadableColor getColor(int time, Color color) {
        int idx;
        if (time < 0) {
            time = 0;
        }
        if (this.style == 1) {
            time %= this.duration;
        }
        if ((idx = Arrays.binarySearch(this.index, time)) < 0) {
            idx = -2 - idx;
        }
        if (idx == this.index.length) {
            --idx;
        }
        SequenceEntry seq = (SequenceEntry)this.sequence.get(idx);
        time -= this.index[idx];
        int fade = seq.duration - seq.fade;
        if (color == null) {
            color = new Color();
        }
        if (time <= fade || idx == this.index.length - 1 && this.style == 0) {
            color.setColor(seq.color);
        } else {
            float fadeRatio = (float)(time - fade) / (float)seq.fade;
            ReadableColor a = seq.color;
            idx = idx == this.index.length - 1 ? 0 : ++idx;
            ReadableColor b = ((SequenceEntry)this.sequence.get(idx)).color;
            ColorInterpolator.interpolate((ReadableColor)a, (ReadableColor)b, (float)fadeRatio, (Interpolator)LinearInterpolator.instance, (WritableColor)color);
        }
        return color;
    }

    public final int getDuration() {
        return this.duration;
    }

    public static class SequenceEntry
    implements Serializable {
        public static final long serialVersionUID = 1L;
        private ReadableColor color;
        private int duration;
        private int fade;

        private SequenceEntry() {
        }

        public SequenceEntry(ReadableColor color, int duration, int fade) {
            this.color = color;
            this.duration = duration;
            this.fade = fade;
        }
    }
}

