/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet;

import com.shavenpuppy.jglib.resources.Feature;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.lwjgl.input.Controller;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class Binding
extends Feature {
    private static final long serialVersionUID = 1L;
    public static final String MOUSE = "mouse";
    public static final String KEYBOARD = "keyboard";
    public static final String CONTROLLER = "controller";
    public static final String DPAD = "dpad";
    public static final String DPAD_RIGHT = "D-Pad Right";
    public static final String DPAD_UP = "D-Pad Up";
    public static final String DPAD_LEFT = "D-Pad Left";
    public static final String DPAD_DOWN = "D-Pad Down";
    public static final int DPAD_RIGHT_INDEX = 0;
    public static final int DPAD_UP_INDEX = 1;
    public static final int DPAD_LEFT_INDEX = 2;
    public static final int DPAD_DOWN_INDEX = 3;
    public static final String FOCUS_UP = "focus.up.binding";
    public static final String FOCUS_DOWN = "focus.down.binding";
    public static final String FOCUS_LEFT = "focus.left.binding";
    public static final String FOCUS_RIGHT = "focus.right.binding";
    public static final String SELECT = "select.binding";
    public static final String YES = "yes.binding";
    public static final String NO = "no.binding";
    public static final String CANCEL = "cancel.binding";
    public static final String FOCUS_UP_ALT = "focus.up.binding.alt";
    public static final String FOCUS_DOWN_ALT = "focus.down.binding.alt";
    public static final String FOCUS_LEFT_ALT = "focus.left.binding.alt";
    public static final String FOCUS_RIGHT_ALT = "focus.right.binding.alt";
    public static final String SELECT_ALT = "select.binding.alt";
    public static final String YES_ALT = "yes.binding.alt";
    public static final String NO_ALT = "no.binding.alt";
    public static final String CANCEL_ALT = "cancel.binding.alt";
    private static final Map BINDINGS;
    private static final List ALL;
    private static boolean enabled;
    private String type;
    private String value;
    private boolean hold;
    private String description;
    private String defaultType;
    private int defaultIndex;
    private transient int index;
    private transient boolean down;
    private transient boolean wasDown;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.puppygames.applet.Binding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        BINDINGS = new HashMap();
        ALL = new LinkedList();
        enabled = true;
    }

    public Binding(String name) {
        super(name);
        this.setAutoCreated();
    }

    protected void doRegister() {
        BINDINGS.put(this.getName(), this);
        ALL.add(this);
    }

    protected void doDeregister() {
        BINDINGS.remove(this.getName());
        ALL.remove((Object)this);
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        if (KEYBOARD.equals(this.type)) {
            this.index = Keyboard.getKeyIndex((String)this.value);
        } else if (MOUSE.equals(this.type)) {
            this.index = Mouse.getButtonIndex((String)this.value);
        } else if (CONTROLLER.equals(this.type)) {
            this.index = -1;
            if (Controllers.getControllerCount() > 0) {
                Controller controller = Controllers.getController((int)0);
                int i = 0;
                while (i < controller.getButtonCount()) {
                    if (controller.getButtonName(i).equals(this.value)) {
                        this.index = i;
                        break;
                    }
                    ++i;
                }
            }
        } else if (DPAD.equals(this.type)) {
            if (DPAD_LEFT.equals(this.value)) {
                this.index = 2;
            } else if (DPAD_RIGHT.equals(this.value)) {
                this.index = 0;
            } else if (DPAD_UP.equals(this.value)) {
                this.index = 1;
            } else if (DPAD_DOWN.equals(this.value)) {
                this.index = 3;
            }
        }
        this.defaultType = this.type;
        this.defaultIndex = this.index;
    }

    private void reset() {
        this.type = this.defaultType;
        this.index = this.defaultIndex;
    }

    public static void resetToDefaults() {
        Iterator i = BINDINGS.values().iterator();
        while (i.hasNext()) {
            Binding b = (Binding)((Object)i.next());
            b.reset();
        }
        Binding.validate();
    }

    public static void load(InputStream stream) throws Exception {
        ObjectInputStream ois = new ObjectInputStream(stream);
        List newBindings = (List)ois.readObject();
        Iterator i = newBindings.iterator();
        while (i.hasNext()) {
            SavedBinding b = (SavedBinding)i.next();
            Binding.setBinding(b.name, b.type, b.index);
        }
        Binding.validate();
    }

    public static void save(OutputStream stream) throws Exception {
        ObjectOutputStream oos = new ObjectOutputStream(stream);
        LinkedList<SavedBinding> output = new LinkedList<SavedBinding>();
        Iterator i = BINDINGS.values().iterator();
        while (i.hasNext()) {
            Binding b = (Binding)((Object)i.next());
            output.add(new SavedBinding(b));
        }
        oos.writeObject(output);
        oos.flush();
        oos.reset();
    }

    public static void validate() {
        Iterator i = BINDINGS.values().iterator();
        while (i.hasNext()) {
            Binding b = (Binding)((Object)i.next());
            if (KEYBOARD.equals(b.type) && !Keyboard.isCreated()) {
                b.type = null;
                continue;
            }
            if (MOUSE.equals(b.type) && !Mouse.isCreated()) {
                b.type = null;
                continue;
            }
            if (CONTROLLER.equals(b.type) && (!Controllers.isCreated() || Controllers.getControllerCount() == 0)) {
                System.out.println("Zapped " + (Object)((Object)b));
                b.type = null;
                continue;
            }
            if (!DPAD.equals(b.type) || Controllers.isCreated() && Controllers.getControllerCount() != 0) continue;
            System.out.println("Zapped " + (Object)((Object)b));
            b.type = null;
        }
    }

    public static List getBindings() {
        return Collections.unmodifiableList(ALL);
    }

    public boolean isDown() {
        if (this.hold) {
            return this.down;
        }
        if (this.wasDown) {
            return false;
        }
        return this.down;
    }

    public static void poll() {
        if (!enabled) {
            return;
        }
        Iterator i = BINDINGS.values().iterator();
        while (i.hasNext()) {
            Binding b = (Binding)((Object)i.next());
            if (b.index == -1) continue;
            b.wasDown = b.down;
            if (KEYBOARD.equals(b.type)) {
                if (Keyboard.isKeyDown((int)b.index)) {
                    b.down = true;
                    continue;
                }
                b.down = false;
                continue;
            }
            if (MOUSE.equals(b.type)) {
                if (Mouse.isButtonDown((int)b.index)) {
                    b.down = true;
                    continue;
                }
                b.down = false;
                continue;
            }
            if (CONTROLLER.equals(b.type)) {
                if (Controllers.getControllerCount() > 0 && Controllers.getController((int)0).isButtonPressed(b.index)) {
                    b.down = true;
                    continue;
                }
                b.down = false;
                continue;
            }
            if (!DPAD.equals(b.type)) continue;
            if (Controllers.getControllerCount() == 0) {
                b.down = false;
                continue;
            }
            float dx = Controllers.getController((int)0).getPovX();
            float dy = Controllers.getController((int)0).getPovY();
            switch (b.index) {
                case 2: {
                    b.down = dx < -0.5f;
                    break;
                }
                case 0: {
                    b.down = dx > 0.5f;
                    break;
                }
                case 1: {
                    b.down = dy < -0.5f;
                    break;
                }
                case 3: {
                    b.down = dy > 0.5f;
                    break;
                }
                default: {
                    b.down = false;
                }
            }
        }
    }

    public static void setEnabled(boolean enabled) {
        Binding.enabled = enabled;
        Iterator i = BINDINGS.values().iterator();
        while (i.hasNext()) {
            Binding b = (Binding)((Object)i.next());
            b.down = false;
            b.wasDown = false;
        }
    }

    public static void setBinding(String name, String type, int index) {
        Binding b = (Binding)((Object)BINDINGS.get(name));
        if (b == null) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("no such binding " + name));
            }
            return;
        }
        b.type = type;
        b.index = index;
        System.out.println("Set binding " + name + " to " + type + ":" + index);
        Binding.validate();
    }

    public static boolean isBindingDown(String name) {
        Binding b = (Binding)((Object)BINDINGS.get(name));
        if (b == null) {
            return false;
        }
        return b.isDown();
    }

    public int getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    private static class SavedBinding
    implements Serializable {
        private static final long serialVersionUID = -389520805784486704L;
        String name;
        String type;
        int index;

        SavedBinding(Binding b) {
            this.name = b.getName();
            this.type = b.type;
            this.index = b.index;
        }
    }
}

