/*
 * Decompiled with CFR 0.152.
 */
package puppytron;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.AnimatedAppearanceResource;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.Util;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Effect;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.effects.EmitterFeature;
import net.puppygames.applet.effects.LabelEffect;
import net.puppygames.applet.widgets.PowerDisplay;
import net.puppygames.applet.widgets.PowerDisplayFeature;
import org.lwjgl.util.Color;
import org.lwjgl.util.Point;
import org.lwjgl.util.ReadableColor;
import org.w3c.dom.Element;
import puppytron.AttackDrone;
import puppytron.Bomb;
import puppytron.Brain;
import puppytron.BrainFeature;
import puppytron.Bullet;
import puppytron.DefenceDrone;
import puppytron.DroneBullet;
import puppytron.EnemyBullet;
import puppytron.Entity;
import puppytron.GameScreen;
import puppytron.Gidrah;
import puppytron.Mine;
import puppytron.Movement;
import puppytron.MovementFeature;
import puppytron.Player;
import puppytron.Powerup;
import puppytron.Puppytron;
import puppytron.Res;
import puppytron.SmartBombShock;
import puppytron.SpawnEffect;
import puppytron.brains.MinelayerBrainFeature;
import puppytron.brains.ShooterBrainFeature;
import puppytron.brains.SpawnerBrainFeature;
import puppytron.movements.PerimeterMovementFeature;
import puppytron.movements.ScuttleMovementFeature;
import puppytron.movements.XYMovementFeature;

public class GidrahFeature
extends Feature {
    private static final long serialVersionUID = 1L;
    private static final List TYPES;
    private static final List EXOTIC;
    private static final List BOSS;
    private static final List ASSAULT;
    private static final float SAFE_DISTANCE = 80.0f;
    private static final int INSET = 10;
    private static final int BOSS_INSET = 60;
    private static final int MIN_FREEZE_TIME = 1800;
    private static final int MAX_FREEZE_TIME = 6400;
    private static final ReadableColor[] SPAWN_COLOR;
    private static final int PHASE_SPAWN = 0;
    private static final int PHASE_WAIT = 1;
    private static final int PHASE_ALIVE = 2;
    private static final int SPAWNWAIT_DURATION = 30;
    private static final int BOSS_SPAWN_DURATION = 300;
    private static int numGidrahs;
    private static int difficultyAdjustment;
    private static int exoticCount;
    private float radius;
    private int level;
    private int armour;
    private int hitPoints;
    private String animation;
    private int score;
    private EmitterFeature spawnEmitter;
    private EmitterFeature deathEmitter;
    private String spawnType;
    private int difficulty;
    private BrainFeature brain;
    private MovementFeature movement;
    private boolean boss;
    private boolean bomber;
    private String spawnSound;
    private String soundEffect;
    private String powerDisplay;
    private Point powerOffset;
    private String deathSound;
    private transient AnimatedAppearanceResource animationAppearance;
    private transient ALBuffer soundEffectResource;
    private transient ALBuffer spawnSoundResource;
    private transient ALBuffer deathSoundResource;
    private transient PowerDisplayFeature powerDisplayFeature;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("puppytron.GidrahFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        TYPES = new ArrayList(64);
        EXOTIC = new ArrayList(64);
        BOSS = new ArrayList(4);
        ASSAULT = new ArrayList(64);
        SPAWN_COLOR = new ReadableColor[]{Color.RED, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.CYAN, Color.BLUE, Color.PURPLE};
        numGidrahs = 0;
        difficultyAdjustment = 0;
    }

    public GidrahFeature(String name) {
        super(name);
        this.setAutoCreated();
    }

    public final Gidrah spawn(Screen screen) {
        GidrahInstance ret = new GidrahInstance(this);
        ret.spawn(screen);
        return ret;
    }

    protected void doRegister() {
        if (this.boss) {
            BOSS.add(this);
        } else if (this.brain instanceof SpawnerBrainFeature || this.brain instanceof MinelayerBrainFeature || this.movement instanceof ScuttleMovementFeature || this.movement instanceof PerimeterMovementFeature) {
            EXOTIC.add(this);
        } else {
            TYPES.add(this);
        }
        if (!this.boss && (this.movement instanceof XYMovementFeature || this.movement instanceof ScuttleMovementFeature) && this.brain instanceof ShooterBrainFeature) {
            ASSAULT.add(this);
            Collections.sort(ASSAULT, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    GidrahFeature g0 = (GidrahFeature)((Object)arg0);
                    GidrahFeature g1 = (GidrahFeature)((Object)arg1);
                    if (g0.level > g1.level) {
                        return 1;
                    }
                    if (g0.level < g1.level) {
                        return -1;
                    }
                    if (g0.score > g1.score) {
                        return 1;
                    }
                    if (g0.score == g1.score) {
                        return 0;
                    }
                    return -1;
                }
            });
        }
    }

    protected void doDeregister() {
        if (this.boss) {
            BOSS.remove((Object)this);
        } else if (this.brain instanceof SpawnerBrainFeature || this.brain instanceof MinelayerBrainFeature || this.movement instanceof ScuttleMovementFeature || this.movement instanceof PerimeterMovementFeature) {
            EXOTIC.remove((Object)this);
        } else {
            TYPES.remove((Object)this);
        }
        if (!this.boss && (this.movement instanceof XYMovementFeature || this.movement instanceof ScuttleMovementFeature) && this.brain instanceof ShooterBrainFeature) {
            ASSAULT.remove((Object)this);
        }
    }

    public static void resetNumGidrahs() {
        numGidrahs = 0;
        difficultyAdjustment = 0;
    }

    public static int getNumGidrahs() {
        return numGidrahs;
    }

    public static void createGidrah() {
        if (++exoticCount > GameScreen.getLevel() || exoticCount >= 3 && difficultyAdjustment == 0) {
            exoticCount = 0;
            GidrahFeature.createExoticGidrah();
        } else {
            int time = GameScreen.getLevel() - 1;
            Player player = GameScreen.getPlayer();
            int shields = player.getShields();
            int extras = (player.isThreeWay() ? 2 : 0) + (player.isBouncy() ? 2 : 0) + (player.isInvulnerable() ? 2 : 0);
            int multiplier = player.getBulletPower() + player.getMultiplier() + (shields > 5 ? shields - 5 : 0) - 2;
            int minBot = Math.min(TYPES.size() - 1, Math.max(0, extras + time + difficultyAdjustment - TYPES.size()));
            int maxBot = Math.min(TYPES.size() - 1, Math.max(minBot, extras + multiplier + time + difficultyAdjustment));
            int bot = Util.random((int)minBot, (int)maxBot);
            GidrahFeature gf = (GidrahFeature)((Object)TYPES.get(bot));
            difficultyAdjustment = Math.min(0, difficultyAdjustment + minBot + player.getMultiplier() + (shields > 5 ? shields - 5 : 0) - gf.difficulty);
            gf.spawn(GameScreen.getInstance());
        }
    }

    public static void createAssault(int type, int number) {
        type = Math.min(ASSAULT.size() - 1, type);
        GidrahFeature gf = (GidrahFeature)((Object)ASSAULT.get(type));
        int i = 0;
        while (i < number) {
            gf.spawn(GameScreen.getInstance());
            ++i;
        }
    }

    public static void createBosses() {
        int level = GameScreen.getLevel() - 1;
        int numBosses = 1 + level / (10 * BOSS.size());
        int boss = level / 10 % BOSS.size();
        int i = 0;
        while (i < numBosses) {
            GidrahFeature gf = (GidrahFeature)((Object)BOSS.get(boss++));
            boss %= BOSS.size();
            gf.spawn(GameScreen.getInstance());
            ++i;
        }
    }

    private static void createExoticGidrah() {
        int time = GameScreen.getLevel() - 1;
        int shields = GameScreen.getPlayer().getShields();
        int multiplier = GameScreen.getPlayer().getBulletPower() + GameScreen.getPlayer().getMultiplier() + (shields > 5 ? shields - 5 : 0) - 1;
        if (multiplier + time < 10) {
            GidrahFeature.createGidrah();
            return;
        }
        int minBot = Math.min(EXOTIC.size() - 1, Math.max(0, time - EXOTIC.size()));
        int maxBot = Math.min(EXOTIC.size() - 1, Math.max(minBot, multiplier + time - 10));
        int bot = Util.random((int)minBot, (int)maxBot);
        GidrahFeature gf = (GidrahFeature)((Object)EXOTIC.get(bot));
        difficultyAdjustment = Math.min(0, minBot + multiplier + difficultyAdjustment - gf.difficulty);
        gf.spawn(GameScreen.getInstance());
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        if (this.boss) {
            this.score = 1000;
            this.hitPoints = 100;
        } else {
            int bhp = this.brain == null ? 1 : this.brain.getHitPoints();
            int mhp = this.movement == null ? 4 : this.movement.getHitPoints();
            this.hitPoints = (bhp + mhp) * (this.level + 1);
            int ba = this.brain == null ? 0 : this.brain.getArmour();
            int ma = this.movement == null ? 0 : this.movement.getArmour();
            this.armour = ba + ma + this.level;
            float hpScore = this.hitPoints < 2 ? 1.0f : (this.hitPoints < 4 ? 1.5f : (this.hitPoints < 6 ? 2.0f : (this.hitPoints < 12 ? 2.5f : (this.hitPoints < 20 ? 3.0f : (this.hitPoints < 30 ? 3.5f : (this.hitPoints < 40 ? 4.0f : (this.hitPoints < 50 ? 4.5f : 5.0f)))))));
            int bd = this.brain == null ? -1 : this.brain.getDifficulty();
            int md = this.movement == null ? -1 : this.movement.getDifficulty();
            this.difficulty = Math.max(0, bd + md + this.level + (this.bomber ? 2 : 0));
            int bs = this.brain == null ? 10 : this.brain.getScore();
            int ms = this.movement == null ? 0 : this.movement.getScore();
            this.score = ((int)((float)(bs + ms) * hpScore) / 50 * 50 + 50) * (this.difficulty + 1);
        }
        if (!$assertionsDisabled && this.hitPoints <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.score <= 0) {
            throw new AssertionError();
        }
        this.spawnType = this.movement == null ? "random" : this.movement.getSpawnType();
    }

    public static void resetDifficulty() {
        difficultyAdjustment = 0;
    }

    protected static class GidrahInstance
    extends Entity
    implements Gidrah {
        private static final long serialVersionUID = 1L;
        private transient GidrahFeature gidrahFeature;
        private String gidrahFeatureName;
        private int phase;
        private int tick;
        private int wounds;
        private int facing = 1;
        private int flashTick;
        private transient Brain brainInstance;
        private transient Movement movementInstance;
        private transient Effect spawnEffect;
        private transient SoundEffect soundEffectInstance;
        private Sprite freezeSprite;
        private int freezeTimer;
        private transient PowerDisplay powerDisplayInstance;
        static /* synthetic */ Class class$0;

        protected GidrahInstance(GidrahFeature gidrahFeature) {
            this.gidrahFeature = gidrahFeature;
        }

        private boolean isBoss() {
            return this.gidrahFeature.boss;
        }

        public void freeze() {
            if (this.isBoss() || this.phase != 2) {
                return;
            }
            if (this.freezeTimer == 0) {
                this.freezeSprite = GameScreen.getInstance().allocateSprite(this);
                this.freezeSprite.setLocation((int)this.getX(), (int)this.getY(), 0);
                this.freezeSprite.setAppearance((AnimatedAppearance)Res.getIceAppearance());
                this.freezeSprite.setLayer(4);
            }
            this.freezeTimer += Util.random((int)1800, (int)6400);
            this.freezeSprite.setAlpha(255);
            this.vx = 0.0f;
            this.vy = 0.0f;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            this.gidrahFeatureName = this.gidrahFeature.getName();
            stream.defaultWriteObject();
        }

        public void setFacing(int facing) {
            this.facing = facing;
        }

        public boolean canCollide() {
            return this.isActive() && (this.phase == 1 || this.phase == 2);
        }

        protected boolean autoRemove() {
            return !this.isBoss();
        }

        public final float getRadius() {
            return this.gidrahFeature.radius;
        }

        public void onCollision(Entity entity) {
            entity.onCollisionWithGidrah(this);
        }

        protected void onCollisionWithBullet(Bullet bullet) {
            this.damage(bullet.getDamage());
        }

        protected void onCollisionWithAttackDrone(AttackDrone drone) {
            if (!this.isBoss() && this.isDangerous()) {
                this.kill(false);
            }
        }

        protected void onCollisionWithDroneBullet(DroneBullet bullet) {
            this.damage(-3);
        }

        protected void onCollisionWithDefenceDrone(DefenceDrone drone) {
            if (!this.isBoss() && this.isDangerous()) {
                this.kill(false);
            }
        }

        protected void onCollisionWithPlayer(Player player) {
            if (!this.isBoss() && this.isDangerous()) {
                this.kill(false);
            }
        }

        protected void onCollisionWithShockwave(SmartBombShock shock) {
            if (!this.isBoss()) {
                this.kill(true);
            }
        }

        private void damage(int amount) {
            boolean dead;
            boolean award = true;
            if (amount < 0) {
                amount = -amount;
                award = this.isBoss();
            }
            if (this.isBoss()) {
                amount = 1;
            } else {
                int arm = this.gidrahFeature.armour + (this.freezeTimer > 0 ? 1 : 0);
                if ((amount = Math.max(0, amount - arm)) <= 0) {
                    int n = amount = Util.random((int)0, (int)(arm + 1)) > arm ? 1 : 0;
                }
                if (amount == 0) {
                    Emitter emitter = Res.getDeflectEmitter().spawn((Screen)GameScreen.getInstance());
                    emitter.setLocation(this.x, this.y);
                    return;
                }
            }
            this.wounds += amount;
            if (this.isBoss()) {
                int maxWounds = Math.max(60, GameScreen.getLevel() * 10 - GameScreen.getPlayer().getRepeatRate() * 5);
                this.powerDisplayInstance.setUsed(11 - 10 * this.wounds / maxWounds);
                dead = this.wounds > maxWounds;
            } else {
                boolean bl = dead = this.wounds >= this.gidrahFeature.hitPoints;
            }
            if (dead) {
                this.kill(award);
            } else {
                this.flash = true;
                this.flashTick = 4;
                Emitter emitter = Res.getRicochetEmitter().spawn((Screen)GameScreen.getInstance());
                emitter.setLocation(this.x, this.y);
            }
        }

        public boolean isDangerous() {
            return this.phase == 2;
        }

        public void kill(boolean award) {
            this.remove();
            if (award) {
                int amount = this.isBoss() ? GameScreen.getLevel() * this.gidrahFeature.score : GameScreen.getPlayer().getMultiplier() * this.gidrahFeature.score;
                Puppytron.addScore(amount);
                LabelEffect le = new LabelEffect(Res.getSmallFont(), String.valueOf(amount), Color.YELLOW, Color.RED, 50, 25);
                le.setVelocity(0.0f, 1.0f);
                le.setAcceleration(0.0f, -0.013f);
                le.setLocation((float)((int)this.x), (float)((int)this.y));
                le.setVisible(true);
                le.spawn((Screen)GameScreen.getInstance());
                if (Puppytron.isPowerupDue() && !this.isBoss()) {
                    Powerup gp = Powerup.createPowerup();
                    gp.x = this.x;
                    gp.y = this.y;
                    gp.spawn(GameScreen.getInstance());
                }
            }
            if (this.freezeTimer > 0) {
                Emitter emitter = Res.getIceEmitter().spawn((Screen)GameScreen.getInstance());
                emitter.setLocation(this.x, this.y);
            } else if (this.gidrahFeature.deathEmitter != null) {
                Emitter emitter = this.gidrahFeature.deathEmitter.spawn((Screen)GameScreen.getInstance());
                emitter.setLocation(this.x, this.y);
            } else if (this.gidrahFeature.deathSoundResource != null) {
                Game.allocateSound((ALBuffer)this.gidrahFeature.deathSoundResource);
            } else {
                Game.allocateSound((ALBuffer)Res.getEnemyDeath());
            }
        }

        protected void doTick() {
            if (this.freezeTimer > 0) {
                --this.freezeTimer;
                if (this.freezeTimer == 0) {
                    this.freezeSprite.deallocate();
                    this.freezeSprite = null;
                } else if (this.freezeTimer < 60) {
                    this.freezeSprite.setAlpha(255 * this.freezeTimer / 60);
                }
                this.updateFlash();
                return;
            }
            ++this.tick;
            switch (this.phase) {
                case 0: {
                    if (this.isBoss()) {
                        if (this.powerDisplayInstance != null) {
                            this.powerDisplayInstance.setLocation((int)this.x + this.gidrahFeature.powerOffset.getX(), (int)(this.y - this.getRadius() + (float)this.gidrahFeature.powerOffset.getX()));
                        }
                        if (this.tick != 300) break;
                        this.phase = 2;
                        this.tick = 0;
                        if (this.gidrahFeature.soundEffectResource == null) break;
                        this.soundEffectInstance = Game.allocateSound((ALBuffer)this.gidrahFeature.soundEffectResource);
                        break;
                    }
                    if (this.spawnEffect == null || !this.spawnEffect.isActive()) {
                        this.tick = 0;
                        this.spawnEffect = null;
                        this.phase = 1;
                        if (this.gidrahFeature.spawnSoundResource != null && (this.isBoss() || Util.random((int)0, (int)4) == 0)) {
                            Puppytron.speak(this.gidrahFeature.spawnSoundResource);
                        }
                    } else {
                        if (this.spawnEffect == null) break;
                        ((SpawnEffect)this.spawnEffect).setLocation(this.x, this.y);
                        break;
                    }
                }
                case 1: {
                    if (this.tick >= 30) {
                        this.tick = 0;
                        this.phase = 2;
                        this.visible = true;
                        if (this.gidrahFeature.soundEffectResource != null) {
                            this.soundEffectInstance = Game.allocateSound((ALBuffer)this.gidrahFeature.soundEffectResource);
                        }
                        if (this.powerDisplayInstance != null) {
                            this.powerDisplayInstance.setVisible(true);
                        }
                    } else {
                        this.visible = (this.tick & 4) == 0;
                        break;
                    }
                }
                case 2: {
                    int oldFacing = this.facing;
                    if (this.brainInstance != null) {
                        this.brainInstance.tick(this);
                    }
                    if (this.movementInstance != null) {
                        this.movementInstance.tick(this);
                    }
                    if (oldFacing != this.facing) {
                        this.sprite.setMirrored(this.facing == -1);
                    }
                    if (this.powerDisplayInstance == null) break;
                    this.powerDisplayInstance.setLocation((int)this.x + this.gidrahFeature.powerOffset.getX(), (int)(this.y - this.getRadius() + (float)this.gidrahFeature.powerOffset.getX()));
                }
            }
            this.updateFlash();
        }

        private void updateFlash() {
            if (this.flashTick > 0) {
                --this.flashTick;
                this.flash = this.flashTick > 0;
            }
        }

        public void shoot(float tx, float ty, int accuracy) {
            if (this.gidrahFeature.bomber) {
                this.bomb(tx, ty, false);
            } else {
                int aim = Util.random((int)0, (int)100);
                if (aim >= accuracy + GameScreen.getLevel()) {
                    tx += (float)Util.random((int)(accuracy - aim), (int)(aim - accuracy));
                    ty += (float)Util.random((int)(accuracy - aim), (int)(aim - accuracy));
                }
                EnemyBullet eb = new EnemyBullet(this.x, this.y, tx, ty);
                eb.spawn(GameScreen.getInstance());
            }
        }

        public void bomb(float tx, float ty, boolean big) {
            Bomb b = new Bomb(this.x, this.y, tx, ty, big ? 90.0f : 45.0f, big ? 60 : 30);
            b.spawn(GameScreen.getInstance());
        }

        public int getLevel() {
            return this.gidrahFeature.level;
        }

        public void layMine() {
            Mine mine = new Mine(this.gidrahFeature.level, this.x, this.y);
            mine.spawn(GameScreen.getInstance());
        }

        protected void doRemove() {
            numGidrahs = numGidrahs - 1;
            if (this.soundEffectInstance != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("net.puppygames.applet.Game");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.soundEffectInstance.stop((Object)clazz);
                this.soundEffectInstance = null;
            }
            if (this.freezeSprite != null) {
                this.freezeSprite.deallocate();
                this.freezeSprite = null;
            }
            if (this.powerDisplayInstance != null) {
                this.powerDisplayInstance.cleanup();
                this.powerDisplayInstance = null;
            }
        }

        protected void doRespawn() {
            try {
                this.gidrahFeature = (GidrahFeature)Resources.get((String)this.gidrahFeatureName);
                this.gidrahFeatureName = null;
                numGidrahs = numGidrahs + 1;
                if (this.isBoss()) {
                    this.powerDisplayInstance = this.gidrahFeature.powerDisplayFeature.spawn((Screen)GameScreen.getInstance());
                    this.powerDisplayInstance.setUsed(10);
                    this.powerDisplayInstance.setVisible(false);
                }
                if (this.gidrahFeature.brain != null) {
                    this.brainInstance = this.gidrahFeature.brain.spawn(this);
                }
                if (this.gidrahFeature.movement != null) {
                    this.movementInstance = this.gidrahFeature.movement.spawn(this);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                this.remove();
            }
        }

        protected void doSpawn() {
            numGidrahs = numGidrahs + 1;
            if (this.isBoss()) {
                this.x = Game.getWidth() / 2;
                this.y = (float)Game.getHeight() + this.getRadius();
                this.vy = -0.5f;
                this.powerDisplayInstance = this.gidrahFeature.powerDisplayFeature.spawn((Screen)GameScreen.getInstance());
                this.powerDisplayInstance.setUsed(10);
            } else {
                float dy;
                float dx;
                float distance = 0.0f;
                int count = 0;
                do {
                    this.setSpawnLocation();
                } while ((distance = (float)Math.sqrt((dx = this.x - GameScreen.getPlayer().x) * dx + (dy = this.y - GameScreen.getPlayer().y) * dy)) < 80.0f && count++ < 8);
                if (this.gidrahFeature.spawnEmitter != null) {
                    this.spawnEffect = this.gidrahFeature.spawnEmitter.spawn((Screen)GameScreen.getInstance());
                    ((Emitter)this.spawnEffect).setLocation(this.x, this.y);
                } else {
                    int d = Math.min(SPAWN_COLOR.length - 1, this.gidrahFeature.difficulty);
                    this.spawnEffect = new SpawnEffect((int)this.x, (int)this.y, SPAWN_COLOR[d], 30 + this.gidrahFeature.difficulty * 10);
                    this.spawnEffect.spawn((Screen)GameScreen.getInstance());
                }
                this.visible = false;
            }
            this.sprite.setAppearance((AnimatedAppearance)this.gidrahFeature.animationAppearance);
            if (this.gidrahFeature.brain != null) {
                this.brainInstance = this.gidrahFeature.brain.spawn(this);
            }
            if (this.gidrahFeature.movement != null) {
                this.movementInstance = this.gidrahFeature.movement.spawn(this);
            }
        }

        private void setSpawnLocation() {
            int inset;
            int n = inset = this.isBoss() ? 60 : 10;
            if (this.gidrahFeature.spawnType != null && this.gidrahFeature.spawnType.charAt(0) == 'e') {
                int edge = Util.random((int)0, (int)3);
                switch (edge) {
                    case 0: {
                        this.x = Util.random((int)0, (int)((Puppytron.getWidth() - 32 - inset * 2) / 16)) * 16 + 16 + inset;
                        this.y = 26.0f;
                        break;
                    }
                    case 1: {
                        this.x = Util.random((int)0, (int)((Puppytron.getWidth() - 32 - inset * 2) / 16)) * 16 + 16 + inset;
                        this.y = Puppytron.getHeight() - 16 - inset;
                        break;
                    }
                    case 2: {
                        this.x = 26.0f;
                        this.y = Util.random((int)0, (int)((Puppytron.getHeight() - 32 - inset * 2) / 16)) * 16 + 16 + inset;
                        break;
                    }
                    case 3: {
                        this.x = Puppytron.getWidth() - 16 - inset;
                        this.y = Util.random((int)0, (int)((Puppytron.getHeight() - 32 - inset * 2) / 16)) * 16 + 16 + inset;
                    }
                }
            } else {
                this.x = Util.random((int)0, (int)((Puppytron.getWidth() - 32 - inset * 2) / 16 * 16)) + 16 + inset;
                this.y = Util.random((int)0, (int)((Puppytron.getHeight() - 32 - inset * 2) / 16)) * 16 + 16 + inset;
            }
        }

        public Movement getMovement() {
            return this.movementInstance;
        }

        public void setMovement(Movement newMovement) {
            this.movementInstance = newMovement;
        }
    }
}

