/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.rmi;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import javax.net.SocketFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletHandler
extends HttpServlet
implements Runnable {
    private static final long serialVersionUID = 1L;
    protected static String initialServerCodebase = null;
    protected static String initialServerClass = null;
    protected static String initialServerBindName = null;
    private static RMICommandHandler[] commands = new RMICommandHandler[]{new ServletForwardCommand(), new ServletGethostnameCommand(), new ServletPingCommand(), new ServletTryHostnameCommand()};
    private static HashMap commandLookup = new HashMap();
    private static SocketFactory defaultSocketFactory;

    static {
        int i = 0;
        while (i < commands.length) {
            commandLookup.put(commands[i].getName(), commands[i]);
            ++i;
        }
        defaultSocketFactory = null;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.setConfigParameters(config);
            if (!this.verifyConfigParameters()) {
                System.err.println("Some optional parameters not set, remote object not exported; ServletHandler is runnning.");
                return;
            }
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
            new Thread(this).start();
            System.out.println("RMI Servlet Handler loaded sucessfully.");
        }
        catch (Exception e) {
            System.err.println("Exception thrown in RMI ServletHandler: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void run() {
        try {
            UnicastRemoteObject server = this.createRemoteObjectUsingDownloadedClass();
            if (server != null) {
                Naming.rebind(initialServerBindName, server);
                System.err.println("Remote object created successfully.");
            }
        }
        catch (Exception e) {
            System.err.println("Exception received while intalling object:");
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    UnicastRemoteObject createRemoteObjectUsingDownloadedClass() throws Exception {
        UnicastRemoteObject server = null;
        Class<?> serverClass = null;
        int MAX_RETRY = 5;
        int retry = 0;
        int sleep = 2000;
        while (retry < MAX_RETRY && serverClass == null) {
            try {
                System.err.println("Attempting to load remote class...");
                serverClass = RMIClassLoader.loadClass(new URL(initialServerCodebase), initialServerClass);
                if (!Class.forName("java.rmi.server.UnicastRemoteObject").isAssignableFrom(serverClass)) {
                    System.err.println("This example requires an  instance of UnicastRemoteObject, remote object not exported.");
                    continue;
                }
                System.out.println("Server class loaded successfully...");
                server = (UnicastRemoteObject)serverClass.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                if (++retry >= MAX_RETRY) {
                    System.err.println("Failed to load remote server  class. Remote object not  exported... ");
                    continue;
                }
                System.err.println("Could not load remote class, trying again...");
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return server;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            String param;
            String command;
            String queryString = req.getQueryString();
            int delim = queryString.indexOf("=");
            if (delim == -1) {
                command = queryString;
                param = "";
            } else {
                command = queryString.substring(0, delim);
                param = queryString.substring(delim + 1);
            }
            RMICommandHandler handler = (RMICommandHandler)commandLookup.get(command);
            if (handler != null) {
                try {
                    handler.execute(req, res, param);
                }
                catch (ServletClientException e) {
                    ServletHandler.returnClientError(res, "client error: " + e.getMessage());
                    e.printStackTrace();
                }
                catch (ServletServerException e) {
                    ServletHandler.returnServerError(res, "internal server error: " + e.getMessage());
                    e.printStackTrace();
                }
            } else {
                ServletHandler.returnClientError(res, "invalid command: " + command);
            }
        }
        catch (Exception e) {
            ServletHandler.returnServerError(res, "internal error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        ServletHandler.returnClientError(res, "GET Operation not supported: Can only forward POST requests.");
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException {
        ServletHandler.returnClientError(res, "PUT Operation not supported: Can only forward POST requests.");
    }

    public String getServletInfo() {
        return "RMI Call Forwarding Servlet Servlet.<br>\n";
    }

    private static void returnClientError(HttpServletResponse res, String message) throws IOException {
        res.sendError(400, "<HTML><HEAD><TITLE>Java RMI Client Error</TITLE></HEAD><BODY><H1>Java RMI Client Error</H1>" + message + "</BODY></HTML>");
        System.err.println("400Java RMI Client Error" + message);
    }

    private static void returnServerError(HttpServletResponse res, String message) throws IOException {
        res.sendError(500, "<HTML><HEAD><TITLE>Java RMI Server Error</TITLE></HEAD><BODY><H1>Java RMI Server Error</H1>" + message + "</BODY></HTML>");
        System.err.println("500Java RMI Server Error: " + message);
    }

    protected synchronized void setConfigParameters(ServletConfig config) {
        try {
            initialServerCodebase = config.getInitParameter("rmi_initialServerCodebase");
            initialServerClass = config.getInitParameter("rmi_initialServerClass");
            initialServerBindName = config.getInitParameter("rmi_initialServerBindName");
        }
        catch (Exception e) {
            System.err.println("");
            System.err.println("Could not access init parameter:");
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    protected synchronized boolean verifyConfigParameters() {
        return this.verifyParameter("rmi_initialServerClass", initialServerClass) && this.verifyParameter("rmi_initialServerBindName", initialServerBindName) && this.verifyParameter("rmi_initialServerCodebase", initialServerCodebase);
    }

    protected boolean verifyParameter(String parameterName, String parameter) {
        if (parameter == null || parameter.equals("")) {
            System.err.println("optional parameter is invalid and will not be used: \n    " + parameterName + " = " + parameter);
            return false;
        }
        System.err.println(String.valueOf(parameterName) + " " + "valid: " + parameter);
        return true;
    }

    private static synchronized SocketFactory getDefaultClientSocketFactory() {
        if (defaultSocketFactory == null) {
            defaultSocketFactory = SocketFactory.getDefault();
        }
        return defaultSocketFactory;
    }

    protected static interface RMICommandHandler {
        public String getName();

        public void execute(HttpServletRequest var1, HttpServletResponse var2, String var3) throws ServletClientException, ServletServerException, IOException;
    }

    protected static class ServletForwardCommand
    implements RMICommandHandler {
        protected ServletForwardCommand() {
        }

        public String getName() {
            return "forward";
        }

        public void execute(HttpServletRequest req, HttpServletResponse res, String param) throws ServletClientException, ServletServerException, IOException {
            String line;
            DataInputStream socketIn;
            Socket socket;
            int port;
            try {
                port = Integer.parseInt(param);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new ServletClientException("invalid port number: " + param);
            }
            if (port <= 0 || port > 65535) {
                throw new ServletClientException("invalid port: " + port);
            }
            if (port < 1024) {
                throw new ServletClientException("permission denied for port: " + port);
            }
            try {
                socket = ServletHandler.getDefaultClientSocketFactory().createSocket("localhost", port);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ServletServerException("could not connect to local port");
            }
            DataInputStream clientIn = new DataInputStream((InputStream)req.getInputStream());
            byte[] buffer = new byte[req.getContentLength()];
            try {
                clientIn.readFully(buffer);
            }
            catch (EOFException e) {
                e.printStackTrace();
                throw new ServletClientException("unexpected EOF reading request body");
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ServletClientException("error reading request body");
            }
            DataOutputStream socketOut = null;
            try {
                socketOut = new DataOutputStream(socket.getOutputStream());
                socketOut.writeBytes("POST / HTTP/1.0\r\n");
                socketOut.writeBytes("Content-length: " + req.getContentLength() + "\r\n\r\n");
                socketOut.write(buffer);
                socketOut.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ServletServerException("error writing to server");
            }
            try {
                socketIn = new DataInputStream(socket.getInputStream());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ServletServerException("error reading from server");
            }
            String key = "Content-length:".toLowerCase();
            boolean contentLengthFound = false;
            int responseContentLength = -1;
            do {
                try {
                    line = socketIn.readLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new ServletServerException("error reading from server");
                }
                if (line == null) {
                    throw new ServletServerException("unexpected EOF reading server response");
                }
                if (!line.toLowerCase().startsWith(key)) continue;
                responseContentLength = Integer.parseInt(line.substring(key.length()).trim());
                contentLengthFound = true;
            } while (line.length() != 0 && line.charAt(0) != '\r' && line.charAt(0) != '\n');
            if (!contentLengthFound || responseContentLength < 0) {
                throw new ServletServerException("missing or invalid content length in server response");
            }
            buffer = new byte[responseContentLength];
            try {
                socketIn.readFully(buffer);
            }
            catch (EOFException e) {
                e.printStackTrace();
                throw new ServletServerException("unexpected EOF reading server response");
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ServletServerException("error reading from server");
            }
            res.setStatus(200);
            res.setContentType("application/octet-stream");
            res.setContentLength(buffer.length);
            try {
                try {
                    ServletOutputStream out = res.getOutputStream();
                    out.write(buffer);
                    out.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new ServletServerException("error writing response");
                }
            }
            finally {
                socketOut.close();
                socketIn.close();
            }
        }
    }

    protected static class ServletGethostnameCommand
    implements RMICommandHandler {
        protected ServletGethostnameCommand() {
        }

        public String getName() {
            return "gethostname";
        }

        public void execute(HttpServletRequest req, HttpServletResponse res, String param) throws IOException {
            byte[] getHostStringBytes = req.getServerName().getBytes();
            res.setStatus(200);
            res.setContentType("application/octet-stream");
            res.setContentLength(getHostStringBytes.length);
            ServletOutputStream out = res.getOutputStream();
            out.write(getHostStringBytes);
            out.flush();
        }
    }

    protected static class ServletPingCommand
    implements RMICommandHandler {
        protected ServletPingCommand() {
        }

        public String getName() {
            return "ping";
        }

        public void execute(HttpServletRequest req, HttpServletResponse res, String param) {
            res.setStatus(200);
            res.setContentType("application/octet-stream");
            res.setContentLength(0);
        }
    }

    protected static class ServletTryHostnameCommand
    implements RMICommandHandler {
        protected ServletTryHostnameCommand() {
        }

        public String getName() {
            return "hostname";
        }

        public void execute(HttpServletRequest req, HttpServletResponse res, String param) throws IOException {
            PrintWriter pw = res.getWriter();
            pw.println("");
            pw.println("<HTML><HEAD><TITLE>Java RMI Server Hostname Info</TITLE></HEAD><BODY>");
            pw.println("<H1>Java RMI Server Hostname Info</H1>");
            pw.println("<H2>Local host name available to Java VM:</H2>");
            pw.print("<P>InetAddress.getLocalHost().getHostName()");
            try {
                String localHostName = InetAddress.getLocalHost().getHostName();
                pw.println(" = " + localHostName);
            }
            catch (UnknownHostException e) {
                pw.println(" threw java.net.UnknownHostException");
            }
            pw.println("<H2>Server host information obtained through Servlet interface from HTTP server:</H2>");
            pw.println("<P>SERVER_NAME = " + req.getServerName());
            pw.println("<P>SERVER_PORT = " + req.getServerPort());
            pw.println("</BODY></HTML>");
        }
    }

    protected static class ServletClientException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ServletClientException(String s) {
            super(s);
        }
    }

    protected static class ServletServerException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ServletServerException(String s) {
            super(s);
        }
    }
}

