/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.gamecommerce.shared;

public final class ValidateUtil {
    private ValidateUtil() {
    }

    public static boolean isName(String name) {
        boolean hasSpace = false;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!Character.isLetter(c)) {
                if (c == ' ') {
                    hasSpace = true;
                } else if (c != '-' && c != '\'') {
                    return false;
                }
            }
            ++i;
        }
        return hasSpace;
    }

    public static boolean isNumber(String number) {
        if (number.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < number.length()) {
            if (!Character.isDigit(number.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isPhone(String phone) {
        int len = 0;
        int i = 0;
        while (i < phone.length()) {
            char c = phone.charAt(i);
            if (Character.isDigit(c)) {
                ++len;
            } else if (c != ' ' && c != '#' && c != '+' && c != '-' && c != '(' && c != ')') {
                return false;
            }
            ++i;
        }
        return len >= 8;
    }

    public static boolean isEmail(String email) {
        int atPos = email.indexOf(64);
        int dotPos = email.indexOf(46);
        if (atPos < 1) {
            return false;
        }
        if (dotPos < 1) {
            return false;
        }
        return Character.isJavaIdentifierPart(email.charAt(0));
    }

    public static boolean isAddress(String address) {
        int len = 0;
        int i = 0;
        while (i < address.length()) {
            char c = address.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                ++len;
            } else if (c != ' ' && c != '.' && c != '/' && c != '\'' && c != '\"' && c != ',' && c != '-' && c != '`') {
                return false;
            }
            ++i;
        }
        return true;
    }
}

