/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.gamecommerce.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.puppygames.gamecommerce.client.WizardGUI;
import net.puppygames.gamecommerce.shared.PaymentDetails;
import net.puppygames.gamecommerce.shared.ValidateUtil;

class BuyPage1
extends WizardGUI
implements PaymentDetails.UserDetailsEditor {
    private JLabel name_label = new JLabel("Your name");
    private JLabel phone_label = new JLabel("Your phone number");
    private JLabel email_label = new JLabel("Your email address");
    private JTextField name_textfield = new JTextField();
    private JTextField phone_textfield = new JTextField();
    private JTextField email_textfield = new JTextField();

    BuyPage1() {
        this.gui.add((Component)this.name_label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.phone_label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.email_label, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.name_textfield, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.phone_textfield, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.email_textfield, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        DocumentListener listener = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                BuyPage1.this.checkValid();
            }

            public void insertUpdate(DocumentEvent e) {
                BuyPage1.this.checkValid();
            }

            public void removeUpdate(DocumentEvent e) {
                BuyPage1.this.checkValid();
            }
        };
        this.name_textfield.getDocument().addDocumentListener(listener);
        this.phone_textfield.getDocument().addDocumentListener(listener);
        this.email_textfield.getDocument().addDocumentListener(listener);
    }

    public String checkValid() {
        String email = this.email_textfield.getText().trim();
        String name = this.name_textfield.getText().trim();
        String phone = this.phone_textfield.getText().trim();
        String message = null;
        boolean valid = true;
        if (!ValidateUtil.isName(name)) {
            message = "You must enter a name.";
            valid = false;
        } else if (!ValidateUtil.isEmail(email)) {
            message = "You must enter a valid e-mail address.";
            valid = false;
        } else if (!ValidateUtil.isPhone(phone)) {
            message = "You must enter a valid phone number";
            valid = false;
        }
        this.getWizardDialog().setNextButtonEnabled(valid, message);
        return message;
    }

    public String getInstructions() {
        return "Firstly we need your name, email address and phone number. We will only use this information in connection with your purchase (see <a href=\"http://" + this.getWizardDialog().getGame().getWebsite() + "\">" + this.getWizardDialog().getGame().getWebsite() + "</a> for our privacy statement).<br><br>" + "If you would like to buy <b>" + this.getWizardDialog().getGame().getTitle() + "</b> as a gift for someone, enter their name and email here instead. " + "Please note that the email address and phone number must be accurate in case our payment processor needs to contact you.";
    }

    public String getTitle() {
        return "Step 2 of 5";
    }

    public void toPaymentDetails(PaymentDetails paymentDetails) {
        paymentDetails.fromUserDetailsGetter(this);
    }

    public String getEmail() {
        return this.email_textfield.getText().trim();
    }

    public char[] getPassword() {
        return null;
    }

    public String getPhone() {
        return this.phone_textfield.getText().trim();
    }

    public String getDeliveryName() {
        return this.name_textfield.getText().trim();
    }

    public void setEmail(String email) {
        this.email_textfield.setText(email);
    }

    public void setPassword(char[] password) {
    }

    public void setPhone(String phone) {
        this.phone_textfield.setText(phone);
    }

    public void setDeliveryName(String name) {
        this.name_textfield.setText(name);
    }
}

