/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.screens;

import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.screens.GenericButtonHandler;
import net.puppygames.applet.widgets.PowerDisplay;
import net.puppygames.applet.widgets.PowerDisplayFeature;
import org.lwjgl.opengl.Display;

public class OptionsScreen
extends Screen {
    private static final long serialVersionUID = 1L;
    private static OptionsScreen instance;
    private static final String MUSICVOLUME = "musicvolume";
    private static final String SFXVOLUME = "sfxvolume";
    private static final String FULLSCREEN_ON = "fullscreen_on";
    private static final String FULLSCREEN_OFF = "fullscreen_off";
    private PowerDisplayFeature musicVolumePowerDisplay;
    private PowerDisplayFeature sfxVolumePowerDisplay;
    private transient PowerDisplay musicVolumePowerDisplayInstance;
    private transient PowerDisplay sfxVolumePowerDisplayInstance;

    public OptionsScreen(String name) {
        super(name);
        this.setAutoCreated();
    }

    protected void doRegister() {
        instance = this;
    }

    protected void doDeregister() {
        instance = null;
    }

    public static void show() {
        instance.open();
    }

    protected void onOpen() {
        GenericButtonHandler.onOpen(this);
        this.musicVolumePowerDisplayInstance = this.musicVolumePowerDisplay.spawn(this);
        this.sfxVolumePowerDisplayInstance = this.sfxVolumePowerDisplay.spawn(this);
        this.musicVolumePowerDisplayInstance.setUsed((int)(Game.getMusicVolume() * (float)this.musicVolumePowerDisplayInstance.getMax()) + 1);
        this.sfxVolumePowerDisplayInstance.setUsed((int)(Game.getSFXVolume() * (float)this.sfxVolumePowerDisplayInstance.getMax()) + 1);
        this.enableButtons();
    }

    protected void enableButtons() {
        if (System.getProperty("os.name").startsWith("Mac OS") && System.getProperty("os.version").startsWith("10.2")) {
            this.setEnabled(FULLSCREEN_ON, false);
            this.setEnabled(FULLSCREEN_OFF, false);
        } else {
            this.setEnabled(FULLSCREEN_ON, true);
            this.setEnabled(FULLSCREEN_OFF, true);
        }
        this.setVisible(FULLSCREEN_ON, Display.isFullscreen());
        this.setVisible(FULLSCREEN_OFF, !Display.isFullscreen());
    }

    protected void doCleanup() {
        this.musicVolumePowerDisplayInstance.cleanup();
        this.sfxVolumePowerDisplayInstance.cleanup();
        this.musicVolumePowerDisplayInstance = null;
        this.sfxVolumePowerDisplayInstance = null;
    }

    protected void onClicked(String id) {
        GenericButtonHandler.onClicked(id);
        if (MUSICVOLUME.equals(id)) {
            int vol = this.musicVolumePowerDisplayInstance.getBarAt(this.getMouseX(), this.getMouseY());
            if (vol >= 0) {
                this.musicVolumePowerDisplayInstance.setUsed(vol + 1);
                Game.setMusicVolume((float)vol / (float)(this.musicVolumePowerDisplayInstance.getMax() - 1));
            }
        } else if (SFXVOLUME.equals(id)) {
            int vol = this.sfxVolumePowerDisplayInstance.getBarAt(this.getMouseX(), this.getMouseY());
            if (vol >= 0) {
                this.sfxVolumePowerDisplayInstance.setUsed(vol + 1);
                Game.setSFXVolume((float)vol / (float)(this.sfxVolumePowerDisplayInstance.getMax() - 1));
            }
        } else if (FULLSCREEN_ON.equals(id)) {
            try {
                Game.setFullscreen(false);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                Game.alert("Your machine won't do windowed mode.");
            }
            this.enableButtons();
        } else if (FULLSCREEN_OFF.equals(id)) {
            try {
                Game.setFullscreen(true);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                Game.alert("Your machine won't do fullscreen mode.");
            }
            this.enableButtons();
        }
    }
}

