/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.screens;

import com.shavenpuppy.jglib.TextLayout;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLTextArea;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.AnimatedAppearanceResource;
import com.shavenpuppy.jglib.sprites.Sprite;
import java.rmi.Naming;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import net.puppygames.applet.AppletHiscoreServerRemote;
import net.puppygames.applet.Game;
import net.puppygames.applet.HiscoresReturn;
import net.puppygames.applet.Res;
import net.puppygames.applet.Score;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.ColorSequence;
import net.puppygames.applet.effects.LabelEffect;
import net.puppygames.applet.effects.ProgressEffect;
import net.puppygames.applet.effects.SFX;
import net.puppygames.applet.screens.GenericButtonHandler;
import net.puppygames.applet.screens.HiscoresScreen;
import net.puppygames.applet.widgets.MessageBox;
import net.puppygames.applet.widgets.TextField;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

public class HiscoresScreen
extends Screen {
    private static final long serialVersionUID = 1L;
    private static HiscoresScreen instance;
    private static final ArrayList rows;
    private static List allScores;
    private int registeredX;
    private int registeredY;
    private String registeredAppearance;
    private int nameX;
    private int rankX;
    private int scoreX;
    private int rankWidth;
    private int pointsWidth;
    private int nameWidth;
    private int yPos;
    private int yGap;
    private int scoresPerPage = 10;
    private Color progressBackgroundColor = new Color(Color.BLUE);
    private Color progressBarColor = new Color(Color.WHITE);
    private String rankFont;
    private String nameFont;
    private String scoreFont;
    private transient AnimatedAppearanceResource registeredAppearanceResource;
    private transient GLFont rankFontResource;
    private transient GLFont nameFontResource;
    private transient GLFont scoreFontResource;
    private transient MessageBox messageBox;
    private transient Score scoreToSubmit;
    private transient boolean doSubmit;
    private transient int page;
    private static final int PHASE_NORMAL = 0;
    private static final int PHASE_EDIT = 1;
    private static final int PHASE_SUBMIT = 2;
    private static final int PHASE_ERROR = 3;
    private static final int PHASE_DOWNLOAD = 4;
    private static final int PHASE_MESSAGE = 5;
    private static final String NEXT = "next";
    private static final String PREV = "prev";
    private int phase;
    private ProgressEffect progress;
    private int colorTick;
    private int tick;
    private static final int DELAY = 60;
    private static final ColorSequence colorSequence;
    private Row editingRow;

    static {
        rows = new ArrayList(100);
        colorSequence = new ColorSequence(new ColorSequence.SequenceEntry[]{new ColorSequence.SequenceEntry(Color.RED, 4, 4), new ColorSequence.SequenceEntry(Color.ORANGE, 4, 4), new ColorSequence.SequenceEntry(Color.YELLOW, 4, 4), new ColorSequence.SequenceEntry(Color.GREEN, 4, 4), new ColorSequence.SequenceEntry(Color.CYAN, 4, 4), new ColorSequence.SequenceEntry(Color.BLUE, 4, 4), new ColorSequence.SequenceEntry(Color.PURPLE, 4, 4)}, 1);
    }

    public HiscoresScreen(String name) {
        super(name);
    }

    protected void doRegister() {
        super.doRegister();
        instance = this;
    }

    protected void doDeregister() {
        super.doDeregister();
        instance = null;
    }

    protected void renderForeground() {
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        int i = 0;
        while (i < rows.size()) {
            Row row = (Row)rows.get(i);
            if (i >= this.page * this.scoresPerPage && i < this.page * this.scoresPerPage + this.scoresPerPage) {
                if (row.registeredSprite != null) {
                    row.registeredSprite.setVisible(row.score.isRegistered());
                }
                row.render();
            } else if (row.registeredSprite != null) {
                row.registeredSprite.setVisible(false);
            }
            ++i;
        }
        switch (this.phase) {
            case 0: {
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.messageBox.render();
            }
        }
    }

    private void waitForKey() {
        if (++this.tick > 60 && Keyboard.next() && Keyboard.getEventKeyState()) {
            Game.showTitleScreen();
        }
    }

    protected void enableButtons() {
        if (this.page == 0) {
            this.setEnabled(PREV, false);
        } else {
            this.setEnabled(PREV, this.phase == 0);
        }
        if (this.page < this.getNumPages() - 1) {
            this.setEnabled(NEXT, this.phase == 0);
        } else {
            this.setEnabled(NEXT, false);
        }
        this.setEnabled("buy", this.phase != 1);
        this.setEnabled("credits", this.phase != 1);
        this.setEnabled("exit", this.phase != 1);
        this.setEnabled("help", this.phase != 1);
        this.setEnabled("hiscores", this.phase != 1);
        this.setEnabled("moregames", this.phase != 1);
        this.setEnabled("options", this.phase != 1);
        this.setEnabled("play", this.phase != 1);
        this.setEnabled("close", true);
    }

    protected void onClicked(String id) {
        if (this.phase == 1) {
            return;
        }
        GenericButtonHandler.onClicked(id);
        if (PREV.equals(id)) {
            this.setPage(Math.max(0, this.page - 1));
        } else if (NEXT.equals(id)) {
            this.setPage(Math.min(this.getNumPages() - 1, this.page + 1));
        }
    }

    public void setPage(int newPage) {
        this.page = newPage;
        this.enableButtons();
    }

    protected final int getNumPages() {
        return (rows.size() - 1) / this.scoresPerPage + 1;
    }

    protected void doTick() {
        if (this.editingRow != null) {
            colorSequence.getColor(this.colorTick++, this.editingRow.color);
        }
        int i = 0;
        while (i < rows.size()) {
            Row row = (Row)rows.get(i);
            row.tick();
            ++i;
        }
        switch (this.phase) {
            case 3: {
                this.waitForKey();
                break;
            }
            case 0: {
                break;
            }
            case 5: {
                if (!Game.wasKeyPressed(1) && !Mouse.isButtonDown((int)0)) break;
                this.messageBox = null;
                this.setEnabled(true);
                this.phase = 0;
                Game.showTitleScreen();
                break;
            }
        }
    }

    protected void doCleanup() {
        Iterator i = rows.iterator();
        while (i.hasNext()) {
            Row row = (Row)i.next();
            row.remove();
        }
        rows.clear();
    }

    public static void show(Score score) {
        HiscoresScreen.instance.doSubmit = score != null && score.getPoints() > 0;
        HiscoresScreen.instance.scoreToSubmit = score;
        instance.open();
    }

    protected void onClose() {
        Game.setPauseEnabled(true);
    }

    protected synchronized void onOpen() {
        GenericButtonHandler.onOpen(this);
        this.tick = 0;
        this.colorTick = 0;
        Game.setPauseEnabled(false);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        this.phase = 4;
        this.progress = new ProgressEffect("DOWNLOADING HISCORES...", (ReadableColor)this.progressBackgroundColor, (ReadableColor)this.progressBarColor);
        this.progress.spawn(this);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        AppletHiscoreServerRemote server = (AppletHiscoreServerRemote)Naming.lookup("//puppygames.net/applet_hiscore_server");
                        List scores = server.getHiscores(Game.getTitle());
                        Game.onRemoteCallSuccess();
                        HiscoresScreen.this.setScoreList(scores);
                        HiscoresScreen.this.phase = 0;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        HiscoresScreen.this.phase = 3;
                        LabelEffect le = new LabelEffect(Res.getBigFont(), "HISCORES UNAVAILABLE", Color.WHITE, Color.RED, 240, 120);
                        le.setLocation(Game.getWidth() / 2, Game.getHeight() / 2);
                        le.setSound(SFX.getGameOverBuffer());
                        le.spawn(instance);
                    }
                }
                catch (Throwable throwable) {
                    HiscoresScreen hiscoresScreen = HiscoresScreen.this;
                    synchronized (hiscoresScreen) {
                        HiscoresScreen.this.tick = 0;
                        if (HiscoresScreen.this.progress != null) {
                            HiscoresScreen.this.progress.setFinished(true);
                            HiscoresScreen.this.progress = null;
                        }
                    }
                    throw throwable;
                }
                HiscoresScreen hiscoresScreen = HiscoresScreen.this;
                synchronized (hiscoresScreen) {
                    HiscoresScreen.this.tick = 0;
                    if (HiscoresScreen.this.progress != null) {
                        HiscoresScreen.this.progress.setFinished(true);
                        HiscoresScreen.this.progress = null;
                    }
                }
            }
        }.start();
    }

    private synchronized void setScoreList(List scores) {
        allScores = scores;
        Iterator i = rows.iterator();
        while (i.hasNext()) {
            Row row = (Row)i.next();
            row.remove();
        }
        rows.clear();
        int rank = 0;
        int page = 0;
        int editingPage = 0;
        int pos = 0;
        boolean done = false;
        this.phase = 0;
        Iterator i2 = allScores.iterator();
        while (i2.hasNext()) {
            Row row;
            Score s = (Score)i2.next();
            if (this.doSubmit && this.scoreToSubmit != null && this.scoreToSubmit.compareTo((Object)s) == -1 && !done) {
                this.scoreToSubmit.setRank(rank++);
                row = new Row(pos, this.scoreToSubmit);
                row.field.setEditing(true);
                this.setKeyboardNavigationEnabled(false);
                rows.add(row);
                editingPage = page++;
                done = true;
                if (++pos == this.scoresPerPage) {
                    pos = 0;
                }
                this.phase = 1;
            }
            s.setRank(rank++);
            row = new Row(pos, s);
            rows.add(row);
            if (++pos != this.scoresPerPage) continue;
            pos = 0;
            ++page;
        }
        if (this.doSubmit && this.scoreToSubmit != null && !done && rank < 100) {
            this.scoreToSubmit.setRank(rank++);
            Row row = new Row(pos, this.scoreToSubmit);
            row.field.setEditing(true);
            this.setKeyboardNavigationEnabled(false);
            rows.add(row);
            editingPage = page;
            this.phase = 1;
        }
        this.setPage(editingPage);
    }

    static /* synthetic */ Color access$13(HiscoresScreen hiscoresScreen) {
        return hiscoresScreen.progressBackgroundColor;
    }

    static /* synthetic */ Color access$14(HiscoresScreen hiscoresScreen) {
        return hiscoresScreen.progressBarColor;
    }

    static /* synthetic */ void access$19(HiscoresScreen hiscoresScreen, boolean bl) {
        hiscoresScreen.doSubmit = bl;
    }

    static /* synthetic */ void access$21(HiscoresScreen hiscoresScreen, MessageBox messageBox) {
        hiscoresScreen.messageBox = messageBox;
    }

    static /* synthetic */ MessageBox access$22(HiscoresScreen hiscoresScreen) {
        return hiscoresScreen.messageBox;
    }

    class Row {
        int pos;
        String rank;
        String points;
        GLTextArea rankLabel;
        GLTextArea pointsLabel;
        Score score;
        TextField field;
        final Color color = new Color(Color.WHITE);
        Sprite registeredSprite;

        Row(int pos, Score score) {
            this.score = score;
            this.pos = pos;
            int rowYPos = HiscoresScreen.this.yPos - pos * HiscoresScreen.this.yGap;
            this.rank = String.valueOf(score.getRank() + 1);
            this.points = String.valueOf(score.getPoints());
            if (HiscoresScreen.this.registeredAppearanceResource != null) {
                this.registeredSprite = HiscoresScreen.this.allocateSprite(this);
                if (this.registeredSprite != null) {
                    this.registeredSprite.setVisible(score.isRegistered());
                    this.registeredSprite.setLocation(HiscoresScreen.this.registeredX, HiscoresScreen.this.registeredY + rowYPos, 0);
                    this.registeredSprite.setAppearance((AnimatedAppearance)HiscoresScreen.this.registeredAppearanceResource);
                    this.registeredSprite.setLayer(4);
                }
            }
            this.rankLabel = new GLTextArea();
            this.rankLabel.setHorizontalAlignment(TextLayout.RIGHT);
            this.rankLabel.setVerticalAlignment(GLTextArea.TOP);
            this.rankLabel.setBounds(HiscoresScreen.this.rankX, rowYPos - Res.getSmallFont().getDescent(), HiscoresScreen.this.rankWidth, Res.getSmallFont().getHeight());
            this.rankLabel.setFont(HiscoresScreen.this.rankFontResource);
            this.rankLabel.setText(this.rank);
            this.pointsLabel = new GLTextArea();
            this.pointsLabel.setHorizontalAlignment(TextLayout.RIGHT);
            this.pointsLabel.setVerticalAlignment(GLTextArea.TOP);
            this.pointsLabel.setBounds(HiscoresScreen.this.scoreX, rowYPos - Res.getSmallFont().getDescent(), HiscoresScreen.this.pointsWidth, Res.getSmallFont().getHeight());
            this.pointsLabel.setFont(HiscoresScreen.this.scoreFontResource);
            this.pointsLabel.setText(this.points);
            this.field = new TextField(this, 24, HiscoresScreen.this.nameWidth){
                final /* synthetic */ Row this$1;
                {
                    this.this$1 = row;
                    super($anonymous0, $anonymous1);
                }

                protected void onEdited() {
                    SFX.keyTyped();
                }

                protected void onChangeFocus() {
                    SFX.textEntered();
                    Row.access$0(this.this$1).setKeyboardNavigationEnabled(true);
                    HiscoresScreen.access$12(Row.access$0(this.this$1), 2);
                    this.this$1.score.setName(this.this$1.field.getText().trim());
                    HiscoresScreen.access$15(Row.access$0(this.this$1), new ProgressEffect("SUBMITTING HISCORE...", (ReadableColor)HiscoresScreen.access$13(Row.access$0(this.this$1)), (ReadableColor)HiscoresScreen.access$14(Row.access$0(this.this$1))));
                    HiscoresScreen.access$16(Row.access$0(this.this$1)).spawn(HiscoresScreen.access$17());
                    new Thread(this){
                        final /* synthetic */ 1 this$2;
                        {
                            this.this$2 = var1_1;
                        }

                        public void run() {
                            try {
                                try {
                                    AppletHiscoreServerRemote server = (AppletHiscoreServerRemote)Naming.lookup("//puppygames.net/applet_hiscore_server");
                                    HiscoresScreen.access$19(Row.access$0(1.access$0(this.this$2)), false);
                                    HiscoresReturn ret = server.submit2(1.access$0(this.this$2).score);
                                    HiscoresScreen.access$20(Row.access$0(1.access$0(this.this$2)), ret.getScores());
                                    if (ret.getMessage() != null) {
                                        StringTokenizer st = new StringTokenizer(ret.getMessage(), "\n", false);
                                        LinkedList<String> tokens = new LinkedList<String>();
                                        while (st.hasMoreTokens()) {
                                            tokens.add(st.nextToken());
                                        }
                                        int h = tokens.size() * Res.getBigFont().getHeight();
                                        int y = (Game.getHeight() - h) / 2 + (tokens.size() - 1) * Res.getBigFont().getHeight();
                                        int delay = 0;
                                        Iterator<E> i = tokens.iterator();
                                        while (i.hasNext()) {
                                            LabelEffect le = new LabelEffect(Res.getBigFont(), (String)i.next(), Color.WHITE, Color.CYAN, 240, 120);
                                            le.setLocation(Game.getWidth() / 2, y);
                                            y -= Res.getBigFont().getHeight();
                                            le.setDelay(delay);
                                            delay += 30;
                                            le.setSound(SFX.getTextEnteredBuffer());
                                            le.spawn(HiscoresScreen.access$17());
                                        }
                                    }
                                    Game.onRemoteCallSuccess();
                                    HiscoresScreen.access$12(Row.access$0(1.access$0(this.this$2)), 0);
                                }
                                catch (SQLException e) {
                                    e.printStackTrace(System.err);
                                    HiscoresScreen.access$12(Row.access$0(1.access$0(this.this$2)), 5);
                                    HiscoresScreen.access$21(Row.access$0(1.access$0(this.this$2)), new MessageBox());
                                    HiscoresScreen.access$22(Row.access$0(1.access$0(this.this$2))).setSize(Game.getWidth() - 20, Game.getHeight() - 20);
                                    HiscoresScreen.access$22(Row.access$0(1.access$0(this.this$2))).setTitle("PROBLEMS");
                                    HiscoresScreen.access$22(Row.access$0(1.access$0(this.this$2))).setMessage(e.getMessage());
                                    Row.access$0(1.access$0(this.this$2)).setEnabled(false);
                                }
                                catch (Exception e) {
                                    e.printStackTrace(System.err);
                                    HiscoresScreen.access$12(Row.access$0(1.access$0(this.this$2)), 3);
                                    LabelEffect le = new LabelEffect(Res.getBigFont(), "COMMUNICATION ERROR", Color.WHITE, Color.RED, 240, 120);
                                    le.setLocation(Game.getWidth() / 2, Game.getHeight() / 2);
                                    le.setSound(SFX.getGameOverBuffer());
                                    le.spawn(HiscoresScreen.access$17());
                                }
                            }
                            finally {
                                HiscoresScreen.access$16(Row.access$0(1.access$0(this.this$2))).setFinished(true);
                                HiscoresScreen.access$15(Row.access$0(1.access$0(this.this$2)), null);
                                HiscoresScreen.access$18(Row.access$0(1.access$0(this.this$2)), 0);
                            }
                        }
                    }.start();
                }

                static /* synthetic */ Row access$0(1 var0) {
                    return var0.this$1;
                }
            };
            this.field.setText(score.getName());
            this.field.setLocation(HiscoresScreen.this.nameX, HiscoresScreen.this.yPos - pos * HiscoresScreen.this.yGap);
            this.field.setFont(HiscoresScreen.this.nameFontResource);
        }

        void render() {
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)1.0f, (float)-1.0f, (float)0.0f);
            this.rankLabel.render();
            this.pointsLabel.render();
            this.field.render();
            GL11.glPopMatrix();
            ColorUtil.setGLColor((ReadableColor)this.color);
            this.rankLabel.render();
            this.pointsLabel.render();
            this.field.render();
        }

        void tick() {
            this.field.tick();
        }

        void remove() {
            if (this.registeredSprite != null) {
                this.registeredSprite.deallocate();
                this.registeredSprite = null;
            }
        }

        static /* synthetic */ HiscoresScreen access$0(Row row) {
            return row.HiscoresScreen.this;
        }
    }
}

