/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.interpolators.SineInterpolator;
import com.shavenpuppy.jglib.opengl.GLBaseTexture;
import net.puppygames.applet.effects.Effect;
import org.lwjgl.opengl.GL11;

public class BlastEffect
extends Effect {
    private static final long serialVersionUID = 1L;
    private int duration;
    private float finalRadius;
    private float width;
    private float radius;
    private int tick;
    private float x;
    private float y;
    private GLBaseTexture texture;
    private int fadeDuration;
    private boolean fading;

    public BlastEffect(float x, float y, int duration, int fadeDuration, float radius, float width, GLBaseTexture texture) {
        this.x = x;
        this.y = y;
        this.duration = duration;
        this.fadeDuration = fadeDuration;
        this.finalRadius = radius;
        this.width = width;
        this.texture = texture;
    }

    protected void doTick() {
        ++this.tick;
        if (!this.fading) {
            this.radius = SineInterpolator.instance.interpolate(0.0f, this.finalRadius, (float)this.tick / (float)this.duration);
            if (this.tick >= this.duration) {
                this.tick = 0;
                this.fading = true;
            }
        }
    }

    protected void doRender() {
        float innerRadius;
        float alpha;
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        GL11.glBlendFunc((int)770, (int)1);
        this.texture.render();
        GL11.glBegin((int)5);
        if (this.fading) {
            alpha = LinearInterpolator.instance.interpolate(1.0f, 0.0f, (float)this.tick / (float)this.fadeDuration);
            innerRadius = SineInterpolator.instance.interpolate(Math.max(0.0f, this.finalRadius - this.width), this.finalRadius, (float)this.tick / (float)this.fadeDuration);
        } else {
            alpha = 1.0f;
            innerRadius = SineInterpolator.instance.interpolate(0.0f, Math.max(0.0f, this.finalRadius - this.width), (float)this.tick / (float)this.duration);
        }
        int i = 0;
        while (i <= 360) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
            GL11.glTexCoord2f((float)i, (float)1.0f);
            GL11.glVertex2f((float)(this.x + (float)Math.cos(Math.toRadians(i)) * innerRadius), (float)(this.y + (float)Math.sin(Math.toRadians(i)) * innerRadius));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            GL11.glTexCoord2f((float)i, (float)0.0f);
            GL11.glVertex2f((float)(this.x + (float)Math.cos(Math.toRadians(i)) * this.radius), (float)(this.y + (float)Math.sin(Math.toRadians(i)) * this.radius));
            i += 8;
        }
        GL11.glEnd();
    }

    public boolean isActive() {
        return !this.fading || this.tick < this.fadeDuration;
    }

    public float getRadius() {
        return this.radius;
    }

    public boolean isFading() {
        return this.fading;
    }
}

