/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet;

import com.shavenpuppy.jglib.MultiBuffer;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.openal.ALStream;
import com.shavenpuppy.jglib.opengl.nvidia.NvidiaInitializer;
import com.shavenpuppy.jglib.resources.DynamicResource;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.resources.TextResource;
import com.shavenpuppy.jglib.sound.OggVorbis;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sound.SoundPlayer;
import com.shavenpuppy.jglib.util.BrowserControl;
import com.shavenpuppy.jglib.util.CheckOnline;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.rmi.Naming;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.puppygames.applet.Binding;
import net.puppygames.applet.Configuration;
import net.puppygames.applet.GameState;
import net.puppygames.applet.Res;
import net.puppygames.applet.Screen;
import net.puppygames.applet.Splash;
import net.puppygames.applet.Support;
import net.puppygames.applet.effects.Effect;
import net.puppygames.applet.effects.EffectFeature;
import net.puppygames.applet.effects.SFX;
import net.puppygames.applet.screens.BindingsScreen;
import net.puppygames.applet.screens.CreditsScreen;
import net.puppygames.applet.screens.HiscoresScreen;
import net.puppygames.applet.screens.InstructionsScreen;
import net.puppygames.applet.screens.NagScreen;
import net.puppygames.applet.screens.RegisterScreen;
import net.puppygames.applet.screens.TitleScreen;
import net.puppygames.gamecommerce.shared.GameInfo;
import net.puppygames.gamecommerce.shared.GameInfoServerRemote;
import net.puppygames.gamecommerce.shared.RegistrationDetails;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.openal.AL;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Display;
import org.lwjgl.util.Rectangle;
import org.lwjgl.util.Timer;

public abstract class Game
extends Feature {
    private static final long serialVersionUID = 1L;
    private static final String RESTORE_GAME_EFFECT_FEATURE = "restore_game.effect";
    private static final String SAVE_GAME_EFFECT_FEATURE = "save_game.effect";
    private static final String DEFAULT_GAME_RESOURCE_NAME = "game.puppygames";
    public static final boolean DEBUG = false;
    private static final boolean REGISTERED = false;
    private static final boolean FORCEUSELOG = false;
    private static final boolean TESTREGISTER = false;
    private static final boolean FORCEUSEOGGCACHE = false;
    private static final boolean[] KEYDOWN = new boolean[256];
    private static final boolean[] KEYWASDOWN = new boolean[256];
    private static final String RESTORE_FILE = "restore.dat";
    private static boolean doBuy;
    private static boolean preventBuy;
    private static boolean pauseEnabled;
    private static boolean sfxEnabled;
    private static boolean musicEnabled;
    private static boolean paused;
    private static boolean finished;
    private static boolean initialised;
    private static RegistrationDetails registrationDetails;
    private static boolean registered;
    private static long installation;
    private static String affiliate;
    private static String scoreGroup;
    private static Preferences PREFS;
    private static Preferences GLOBALPREFS;
    private static Configuration configuration;
    private static int playedThisSession;
    private static boolean shownInstructions;
    private static Game game;
    private static GameInfo gameInfo;
    private static SoundPlayer soundPlayer;
    private static SoundPlayer musicPlayer;
    private static SoundEffect music;
    private static String dirPrefix;
    private static String GAMEINFO_FILE;
    private static int playedTicks;
    private static boolean screenSize;
    private static int musicVolume;
    private static int sfxVolume;
    private static DisplayMode initialMode;
    private static Rectangle viewPort;
    private static GameState gameState;
    public static boolean waitForKey;
    private static boolean allowSave;
    public static Effect questionEffect;
    public static Screen topScreen;
    private static String title;
    private static String internalTitle;
    private static String version;
    private int width;
    private int height;
    private int frameRate;
    private int messageSequence;
    private String supportEmail = "support@puppygames.net";
    private String supportURL = "www.puppygames.net/support/support.php";
    private String contactURL = "www.puppygames.net/contact.php";
    private String website = "www.puppygames.net";
    private String buyURL = "";
    private String moreGamesURL = "www.puppygames.net";
    private int defaultFullscreen = 0;
    private transient int panic;
    static /* synthetic */ Class class$0;

    static {
        pauseEnabled = true;
        sfxEnabled = true;
        musicEnabled = true;
        allowSave = true;
    }

    public Game(String name) {
        super(name);
    }

    public static void setPauseEnabled(boolean pauseEnabled) {
        Game.pauseEnabled = pauseEnabled;
        if (paused && !pauseEnabled) {
            paused = false;
        }
    }

    public static Game getGame() {
        return game;
    }

    public static int getWidth() {
        return Game.game.width;
    }

    public static int getHeight() {
        return Game.game.height;
    }

    public static int getFrameRate() {
        return Game.game.frameRate;
    }

    public static String getTitle() {
        return title;
    }

    public static String getVersion() {
        return version;
    }

    public static String getWebsite() {
        return Game.game.website;
    }

    public static String getSupportURL() {
        return Game.game.supportURL;
    }

    public static String getSupportEmail() {
        return Game.game.supportEmail;
    }

    public static String getContactURL() {
        return Game.game.contactURL;
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    public static GameInfo getGameInfo() {
        return gameInfo;
    }

    public static long getInstallation() {
        return installation;
    }

    public static Preferences getGlobalPreferences() {
        return GLOBALPREFS;
    }

    public static Preferences getPreferences() {
        return PREFS;
    }

    public static RegistrationDetails getRegistrationDetails() {
        return registrationDetails;
    }

    public static boolean isFinished() {
        return finished;
    }

    public static boolean isPaused() {
        return paused;
    }

    public static boolean isRegistered() {
        return registered;
    }

    public static String getAffiliate() {
        return affiliate;
    }

    private static PrintStream redirectOutput(final PrintStream output, String fileName) throws FileNotFoundException {
        if (fileName == null || fileName.equals("")) {
            return output;
        }
        boolean append = true;
        File outFile = new File(fileName);
        if (outFile.exists() && outFile.length() > 32768L) {
            outFile.renameTo(new File(String.valueOf(fileName) + ".old"));
            append = false;
        }
        return new PrintStream((OutputStream)new FileOutputStream(fileName, append)){

            public void println(String s) {
                this.print(new Date());
                this.print('\t');
                super.println(s);
                output.println(s);
            }
        };
    }

    public static synchronized void init(InputStream resourcesStream) throws Exception {
        String gameResourceName;
        if (initialised) {
            return;
        }
        initialised = true;
        Resources.load((InputStream)resourcesStream);
        title = ((TextResource)Resources.get((String)"title")).getText().trim();
        version = ((TextResource)Resources.get((String)"version")).getText().trim();
        System.out.println(new Date() + " Game: " + title + " " + version);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.puppygames.applet.Game");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GLOBALPREFS = Preferences.userNodeForPackage(clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("net.puppygames.applet.Game");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PREFS = Preferences.userNodeForPackage(clazz2).node(title);
        installation = GLOBALPREFS.getLong("installation", 0L);
        if (installation == 0L) {
            installation = (long)(Math.random() * 9.223372036854776E18);
            GLOBALPREFS.putLong("installation", installation);
        }
        Game.initFiles();
        affiliate = PREFS.get("affiliate", "");
        if (affiliate.equals("")) {
            affiliate = System.getProperty("affiliate", "");
            if (affiliate.equals("")) {
                try {
                    FileReader fr = new FileReader("affiliate.id");
                    BufferedReader br = new BufferedReader(fr);
                    affiliate = br.readLine().trim().toLowerCase();
                    fr.close();
                }
                catch (Exception e) {
                    affiliate = "puppygames";
                }
            }
            PREFS.put("affiliate", affiliate);
        }
        game = Resources.exists((String)(gameResourceName = "game." + affiliate)) ? (Game)Resources.peek((String)gameResourceName) : (Game)Resources.peek((String)DEFAULT_GAME_RESOURCE_NAME);
        byte[] cfg = PREFS.getByteArray("configuration", null);
        if (cfg == null) {
            Game.createConfiguration();
        } else {
            ByteArrayInputStream bais = new ByteArrayInputStream(cfg);
            ObjectInputStream ois = new ObjectInputStream(bais);
            try {
                try {
                    configuration = (Configuration)ois.readObject();
                }
                catch (Exception e) {
                    Game.createConfiguration();
                }
            }
            finally {
                ois.close();
            }
        }
        Game.checkRegistration();
        boolean wasBadExit = PREFS.getBoolean("badexit", false);
        gameInfo = new GameInfo(Game.getTitle(), Game.getVersion(), Game.getAffiliate(), Game.getInstallation(), wasBadExit, org.lwjgl.opengl.Display.getAdapter(), org.lwjgl.opengl.Display.getVersion(), configuration.encode());
        System.out.println("Starting " + Game.getTitle() + " " + Game.getVersion());
        if (wasBadExit) {
            Game.alert(String.valueOf(Game.getTitle()) + " did not shut down correctly last time you tried to play.\n\nIf you are experiencing problems or bugs please " + ("".equals(Game.getSupportEmail()) ? "visit " + Game.getContactURL() : "contact " + Game.getSupportEmail()) + "\nand tell us!");
            Support.doSupport("crash");
        }
        PREFS.putBoolean("badexit", true);
        try {
            System.setOut(Game.redirectOutput(System.out, String.valueOf(dirPrefix) + "out.log"));
            System.setErr(Game.redirectOutput(System.err, String.valueOf(dirPrefix) + "err.log"));
        }
        catch (FileNotFoundException ois) {
            // empty catch block
        }
        Game.initSound();
        try {
            Controllers.create();
        }
        catch (Exception e) {
            System.err.println("No gamepads or joysticks enabled due to " + e);
        }
        try {
            Game.initDisplay();
        }
        catch (Exception e) {
            e.printStackTrace();
            gameInfo.setException((Throwable)e);
            Game.alert("You need to get new graphics card drivers in order to play " + Game.getTitle() + ".\nPlease contact your system vendor for assistance.");
            Support.doSupport("opengl");
            Game.exit();
        }
        org.lwjgl.opengl.Display.setVSyncEnabled((boolean)false);
        Splash splash = Splash.getInstance();
        if (splash != null) {
            try {
                splash.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                splash = null;
            }
        }
        OggVorbis.setCacheDirectory((String)dirPrefix);
        DynamicResource.createAll();
        SFX.createSFX();
        Res.createResources();
        Feature.autoCreate();
        Resources.setRunMode((boolean)true);
        String glvendor = GL11.glGetString((int)7936);
        String glrenderer = GL11.glGetString((int)7937);
        String glversion = GL11.glGetString((int)7938);
        String gldriver = null;
        int i = glversion.indexOf(32);
        if (i != -1) {
            gldriver = glversion.substring(i + 1);
            glversion = glversion.substring(0, i);
        }
        gameInfo.update(glvendor, glrenderer, glversion, gldriver, registrationDetails);
        game.create();
        Game.loadBindings();
        if (splash != null) {
            splash.destroy();
            splash = null;
        }
        Game.initVsync();
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glFrustum((double)((double)(-Game.getWidth()) / 64.0), (double)((double)Game.getWidth() / 64.0), (double)((double)(-Game.getHeight()) / 64.0), (double)((double)Game.getHeight() / 64.0), (double)8.0, (double)65536.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        boolean showRegister = PREFS.getBoolean("showregister", false) && !Game.isRegistered();
        PREFS.putBoolean("showregister", false);
        if (Game.isDemoExpired() || showRegister) {
            Game.showRegisterScreen();
        } else {
            Game.showTitleScreen();
        }
        resourcesStream.close();
        resourcesStream = null;
        try {
            try {
                game.run();
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                System.out.println("Set exception to " + t);
                gameInfo.setException(t);
                Game.exit();
            }
        }
        finally {
            Game.exit();
        }
    }

    private static String getSettingsDir() {
        if (System.getProperty("os.name").startsWith("Mac OS")) {
            return String.valueOf(System.getProperty("user.home", "")) + "/Library/Application Support";
        }
        return System.getProperty("user.home", "");
    }

    public static String getDirectoryPrefix() {
        return dirPrefix;
    }

    private static void initFiles() {
        File settingsDir = new File(System.getProperty("workdir", String.valueOf(Game.getSettingsDir()) + File.separator + Game.getTitle() + ' ' + Game.getVersion()));
        boolean dirPrefixExists = !settingsDir.exists() ? settingsDir.mkdir() : true;
        dirPrefix = dirPrefixExists ? String.valueOf(System.getProperty("workdir", String.valueOf(Game.getSettingsDir()) + File.separator + Game.getTitle() + ' ' + Game.getVersion())) + File.separator : Game.getSettingsDir();
        GAMEINFO_FILE = String.valueOf(dirPrefix) + "log.dat";
    }

    private static void writeTix() {
        int tix = PREFS.getInt("tix", 0);
        int newTix = playedTicks / Game.getFrameRate();
        playedTicks = 0;
        gameInfo.addTime(newTix);
        PREFS.putInt("tix", tix += newTix);
    }

    public static void onTicked() {
        ++playedTicks;
    }

    private static void writeLog() {
        if (gameInfo == null) {
            System.out.println("No game info log");
        }
        File log = new File(GAMEINFO_FILE);
        List<Object> logList = null;
        if (log.exists()) {
            ObjectInputStream ois = null;
            BufferedInputStream bis = null;
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(log);
                    bis = new BufferedInputStream(fis);
                    ois = new ObjectInputStream(bis);
                    logList = (List)ois.readObject();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    logList = new ArrayList(1);
                }
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (Exception exception) {}
                }
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception exception) {}
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {}
                }
                ois = null;
                bis = null;
                fis = null;
            }
        } else {
            if (Game.isRegistered() && !Support.isSupportQueued()) {
                return;
            }
            logList = new ArrayList<GameInfo>(1);
        }
        if (gameInfo != null) {
            Game.writeTix();
            logList.add(gameInfo);
        }
        boolean isOnline = Game.isRemoteCallAllowed();
        boolean submitted = false;
        if (CheckOnline.isOnline() && (isOnline || Support.isSupportQueued() || gameInfo.isCrashRecovery() || gameInfo.getException() != null)) {
            try {
                GameInfoServerRemote server = (GameInfoServerRemote)Naming.lookup("//puppygames.net/puppygames_gameinfo_server");
                server.submit(logList);
                Game.onRemoteCallSuccess();
                submitted = true;
                log.delete();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        if (!submitted) {
            FileOutputStream fos = null;
            FilterOutputStream bos = null;
            ObjectOutputStream oos = null;
            try {
                try {
                    fos = new FileOutputStream(log);
                    bos = new BufferedOutputStream(fos);
                    oos = new ObjectOutputStream(bos);
                    oos.writeObject(logList);
                    oos.flush();
                    ((BufferedOutputStream)bos).flush();
                    fos.flush();
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
            finally {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (Exception exception) {}
                }
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (Exception exception) {}
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static void clearBuy() {
        doBuy = false;
    }

    public static void showMoreGames() {
        preventBuy = true;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    String page;
                    PREFS.putBoolean("showregister", true);
                    if (Resources.exists((String)"moregames_url")) {
                        TextResource tr = (TextResource)Resources.get((String)"moregames_url");
                        page = tr.getText();
                    } else {
                        page = game.moreGamesURL != null && !"".equals(game.moreGamesURL) ? game.moreGamesURL : (!System.getProperty("moregames_url", "!").equals("!") ? System.getProperty("moregames_url") : "http://" + Game.getWebsite());
                    }
                    BrowserControl.openURL((String)page);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    Game.alert("Please open your web browser on the page http://" + Game.getWebsite());
                }
            }
        });
        Game.exit();
    }

    public static void buy(boolean doExit) {
        if (!doBuy) {
            doBuy = true;
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    if (Game.isRegistered()) {
                        return;
                    }
                    PREFS.putBoolean("showregister", true);
                    try {
                        String page;
                        if (Resources.exists((String)"buy_url")) {
                            TextResource tr = (TextResource)Resources.get((String)"buy_url");
                            page = tr.getText();
                        } else {
                            page = game.buyURL != null && !"".equals(game.buyURL) ? game.buyURL : (!System.getProperty("buy_url", "!").equals("!") ? System.getProperty("buy_url") : "http://" + Game.getWebsite() + "/purchase/buy.php?game=" + URLEncoder.encode(Game.getTitle(), "utf-8") + "&configuration=" + URLEncoder.encode(configuration.encode(), "utf-8") + "&affiliate=" + URLEncoder.encode(Game.getAffiliate(), "utf-8") + "&installation=" + URLEncoder.encode(String.valueOf(installation), "utf-8"));
                        }
                        BrowserControl.openURL((String)page);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        Game.alert("Please open your web browser on the page http://" + Game.getWebsite());
                    }
                }
            });
        }
        if (doExit) {
            Game.exit();
        }
    }

    public static synchronized void exit() {
        try {
            if (PREFS != null) {
                PREFS.flush();
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace(System.err);
        }
        if (!initialised) {
            return;
        }
        game.onExit();
        initialised = false;
        finished = true;
        if (soundPlayer != null && soundPlayer.isCreated()) {
            soundPlayer.destroy();
        }
        if (musicPlayer != null && musicPlayer.isCreated()) {
            musicPlayer.destroy();
        }
        game.cleanup();
        AL.destroy();
        org.lwjgl.opengl.Display.destroy();
        Game.writeLog();
        PREFS.putBoolean("badexit", false);
        if (!preventBuy) {
            Game.buy(false);
        }
        System.exit(0);
    }

    protected void onExit() {
    }

    public static SoundEffect allocateSound(ALBuffer buffer) {
        SoundEffect effect;
        if (!AL.isCreated() || !Game.isSFXEnabled() || buffer == null || buffer.getWave() == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.puppygames.applet.Game");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((effect = soundPlayer.allocate(buffer, (Object)clazz)) != null) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("net.puppygames.applet.Game");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            effect.setAttenuated(false, (Object)clazz2);
            float f = effect.getBuffer().getGain() * (float)sfxVolume / 100.0f;
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("net.puppygames.applet.Game");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            effect.setGain(f, (Object)clazz3);
            if (buffer.getWave().getType() == 1) {
                Class<?> clazz4 = class$0;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$0 = Class.forName("net.puppygames.applet.Game");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                effect.setPosition(0.0f, 0.0f, 0.0f, (Object)clazz4);
            }
        }
        return effect;
    }

    public static SoundEffect allocateSound(ALStream buffer) {
        SoundEffect effect;
        if (!AL.isCreated() || !Game.isSFXEnabled() || buffer == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.puppygames.applet.Game");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((effect = musicPlayer.allocate(buffer, (Object)clazz)) != null) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("net.puppygames.applet.Game");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            effect.setAttenuated(false, (Object)clazz2);
            float f = effect.getStream().getSourceStream().getGain() * (float)sfxVolume / 100.0f;
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("net.puppygames.applet.Game");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            effect.setGain(f, (Object)clazz3);
            if (effect.getStream().getType() == 1) {
                Class<?> clazz4 = class$0;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$0 = Class.forName("net.puppygames.applet.Game");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                effect.setPosition(0.0f, 0.0f, 0.0f, (Object)clazz4);
            }
        }
        return effect;
    }

    public static boolean isSFXEnabled() {
        return sfxEnabled;
    }

    public static boolean isMusicEnabled() {
        return musicEnabled;
    }

    public static void playMusic(ALStream buf, int fade) {
        boolean xfade;
        if (music == null && buf == null || music != null && buf == music.getStream().getSourceStream()) {
            return;
        }
        boolean bl = xfade = music != null;
        if (xfade) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("net.puppygames.applet.Game");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            music.setFade(fade, 0.0f, true, (Object)clazz);
        }
        if ((music = buf == null || !Game.isMusicEnabled() ? null : Game.allocateSound(buf)) != null) {
            if (xfade) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("net.puppygames.applet.Game");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                music.setGain(0.0f, (Object)clazz);
                float f = buf.getGain() * (float)musicVolume / 100.0f;
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("net.puppygames.applet.Game");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                music.setFade(fade, f, false, (Object)clazz2);
            } else {
                float f = buf.getGain() * (float)musicVolume / 100.0f;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("net.puppygames.applet.Game");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                music.setGain(f, (Object)clazz);
            }
        }
    }

    public static void playMusic(ALBuffer buf, int fade) {
        boolean xfade;
        if (music == null && buf == null || music != null && buf == music.getBuffer()) {
            return;
        }
        boolean bl = xfade = music != null;
        if (xfade) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("net.puppygames.applet.Game");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            music.setFade(fade, 0.0f, true, (Object)clazz);
        }
        if ((music = buf == null || !Game.isMusicEnabled() ? null : Game.allocateSound(buf)) != null) {
            if (xfade) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("net.puppygames.applet.Game");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                music.setGain(0.0f, (Object)clazz);
                float f = buf.getGain() * (float)musicVolume / 100.0f;
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("net.puppygames.applet.Game");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                music.setFade(fade, f, false, (Object)clazz2);
            } else {
                float f = buf.getGain() * (float)musicVolume / 100.0f;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("net.puppygames.applet.Game");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                music.setGain(f, (Object)clazz);
            }
        }
    }

    public static SoundEffect getMusic() {
        return music;
    }

    private static void initSound() {
        try {
            System.out.println("Initing sound");
            AL.create();
            musicPlayer = new SoundPlayer(3);
            musicPlayer.create();
            soundPlayer = new SoundPlayer(15);
            soundPlayer.create();
            musicVolume = PREFS.getInt("musicvolume", 100);
            sfxVolume = PREFS.getInt("sfxvolume", 100);
        }
        catch (Exception e) {
            e.printStackTrace();
            Game.alert("You need a sound card to to hear the sound effects and music in " + Game.getTitle() + ".\nYou may have a suitable card but not have appropriate drivers.\nPlease contact " + Game.getSupportEmail() + " for assistance or visit our website if you need help\n finding drivers for your sound card.");
            Support.doSupport("openal");
        }
    }

    private static void initDisplay() throws Exception {
        org.lwjgl.opengl.Display.setTitle((String)Game.getTitle());
        initialMode = org.lwjgl.opengl.Display.getDisplayMode();
        if ("!".equals(PREFS.get("fullscreen2", "!"))) {
            PREFS.putInt("fullscreen2", Game.game.defaultFullscreen);
        }
        int fs = PREFS.getInt("fullscreen2", 0);
        switch (fs) {
            case 0: {
                Game.setFullscreen(configuration.isFullscreen());
                break;
            }
            case 1: {
                Game.setFullscreen(false);
                break;
            }
            case 2: {
                Game.setFullscreen(true);
            }
        }
        NvidiaInitializer.initialize((int)0x400000, (int)0);
    }

    public static void setFullscreen(boolean fullscreen) throws Exception {
        try {
            if (System.getProperty("os.name").startsWith("Mac OS") && System.getProperty("os.version").startsWith("10.2")) {
                fullscreen = false;
            }
            if (fullscreen) {
                Game.initFullscreen();
            } else {
                Game.initWindow();
            }
            PREFS.putInt("fullscreen2", fullscreen ? 2 : 1);
        }
        catch (Exception e) {
            System.err.println("Failed to set fullscreen=" + fullscreen + " due to " + e);
            throw e;
        }
    }

    private static void initVsync() {
        int freq = org.lwjgl.opengl.Display.getDisplayMode().getFrequency();
        if (freq != Game.getFrameRate()) {
            org.lwjgl.opengl.Display.setVSyncEnabled((boolean)false);
        } else {
            org.lwjgl.opengl.Display.setVSyncEnabled((boolean)true);
        }
    }

    private static void initFullscreen() throws Exception {
        int gw;
        int gh;
        int dh;
        int dw;
        System.out.println("Initialising full screen display");
        org.lwjgl.opengl.Display.setFullscreen((boolean)true);
        if (org.lwjgl.opengl.Display.isCreated()) {
            org.lwjgl.opengl.Display.update();
        }
        Display.setDisplayMode((DisplayMode[])Display.getAvailableDisplayModes((int)640, (int)480, (int)-1, (int)-1, (int)16, (int)32, (int)0, (int)85), (String[])new String[]{"width=" + Game.getWidth(), "height=" + Game.getHeight(), "bpp=" + initialMode.getBitsPerPixel(), "freq=" + Game.getFrameRate()});
        System.out.println("Set displaymode to " + org.lwjgl.opengl.Display.getDisplayMode());
        Game.initVsync();
        if (!org.lwjgl.opengl.Display.isCreated()) {
            org.lwjgl.opengl.Display.create();
        }
        if ((float)(dw = org.lwjgl.opengl.Display.getDisplayMode().getWidth()) / (float)(dh = org.lwjgl.opengl.Display.getDisplayMode().getHeight()) > (float)Game.getWidth() / (float)Game.getHeight()) {
            gh = dh;
            gw = (int)((float)Game.getHeight() * ((float)dh / (float)Game.getWidth()));
        } else {
            gw = dw;
            gh = (int)((float)Game.getWidth() * ((float)dw / (float)Game.getHeight()));
        }
        System.out.println("Game scaled to " + gw + " x " + gh);
        int x = (dw - gw) / 2;
        int y = (dh - gh) / 2;
        viewPort = new Rectangle(x, y, gw, gh);
        GL11.glViewport((int)0, (int)0, (int)org.lwjgl.opengl.Display.getDisplayMode().getWidth(), (int)org.lwjgl.opengl.Display.getDisplayMode().getHeight());
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glClear((int)16384);
        org.lwjgl.opengl.Display.update();
        Game.resetViewport();
        org.lwjgl.opengl.Display.update();
    }

    private static void initWindow() throws Exception {
        System.out.println("Initialising window");
        org.lwjgl.opengl.Display.setFullscreen((boolean)false);
        org.lwjgl.opengl.Display.setVSyncEnabled((boolean)false);
        if (initialMode.getWidth() > Game.getWidth() * 2 && initialMode.getHeight() > Game.getHeight() * 2) {
            org.lwjgl.opengl.Display.setDisplayMode((DisplayMode)new DisplayMode(Game.getWidth() * 2, Game.getHeight() * 2));
            screenSize = true;
        } else {
            org.lwjgl.opengl.Display.setDisplayMode((DisplayMode)new DisplayMode(Game.getWidth(), Game.getHeight()));
            screenSize = false;
        }
        if (!org.lwjgl.opengl.Display.isCreated()) {
            org.lwjgl.opengl.Display.create();
        }
        Mouse.destroy();
        Keyboard.destroy();
        Keyboard.create();
        Mouse.create();
        Mouse.poll();
        Keyboard.poll();
        viewPort = new Rectangle(0, 0, org.lwjgl.opengl.Display.getDisplayMode().getWidth(), org.lwjgl.opengl.Display.getDisplayMode().getHeight());
        Game.resetViewport();
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glClear((int)16384);
    }

    public static void resetViewport() {
        GL11.glViewport((int)viewPort.getX(), (int)viewPort.getY(), (int)viewPort.getWidth(), (int)viewPort.getHeight());
    }

    protected void cleanup() {
    }

    private static void checkRegistration() {
        try {
            RegistrationDetails checkedDetails = RegistrationDetails.checkRegistration((String)Game.getTitle());
            Game.setRegistrationDetails(checkedDetails);
        }
        catch (Exception e) {
            Game.setRegistrationDetails(null);
        }
    }

    public static void setRegistrationDetails(RegistrationDetails registrationDetails) {
        Game.registrationDetails = registrationDetails;
        if (registrationDetails != null) {
            registered = true;
            System.out.println("Game is registered.");
            registrationDetails.toPreferences();
        } else {
            System.out.println("Game is unregistered.");
            registered = false;
            RegistrationDetails.clearRegistration((String)Game.getTitle());
        }
    }

    private static void createConfiguration() throws Exception {
        configuration = new Configuration();
        configuration.init();
        Game.writeConfiguration();
    }

    private static void writeConfiguration() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(configuration);
        oos.flush();
        byte[] cfg = baos.toByteArray();
        PREFS.putByteArray("configuration", cfg);
        oos.close();
    }

    public static void setConfiguration(Configuration newConfiguration) throws Exception {
        configuration = newConfiguration;
        Game.writeConfiguration();
    }

    private void run() {
        while (!finished) {
            org.lwjgl.opengl.Display.update();
            if (org.lwjgl.opengl.Display.isCloseRequested()) {
                Game.exit();
                continue;
            }
            if (org.lwjgl.opengl.Display.isActive()) {
                try {
                    Resources.manage();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                this.tick();
                this.render();
                org.lwjgl.opengl.Display.sync((int)Game.getFrameRate());
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                Resources.manage();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            if (org.lwjgl.opengl.Display.isVisible() || org.lwjgl.opengl.Display.isDirty()) {
                this.render();
            }
            org.lwjgl.opengl.Display.sync((int)Game.getFrameRate());
        }
    }

    public static boolean isDemoExpired() {
        if (Game.isRegistered()) {
            return false;
        }
        int played = PREFS.getInt("played" + Game.getVersion(), 0);
        played ^= 0xAF6AD755;
        played = played >> 16 & 0xFFFF | played << 16;
        if ((played ^= 0xCCCCCABE) == 463037908) {
            played = 0;
        }
        int tix = PREFS.getInt("tix", 0);
        return played < 0 || (played > configuration.getMaxGames() && configuration.getMaxGames() > 0 || configuration.getMaxGames() == 0) && (tix > configuration.getMaxTime() && configuration.getMaxTime() > 0 || configuration.getMaxTime() == 0);
    }

    public static void beginNewGame() {
        System.out.println("Begin new game");
        if (!Game.isRegistered()) {
            if (!shownInstructions) {
                Game.showHelp();
                return;
            }
            int played = PREFS.getInt("played" + Game.getVersion(), 0);
            played ^= 0xAF6AD755;
            played = played >> 16 & 0xFFFF | played << 16;
            if ((played ^= 0xCCCCCABE) == 463037908) {
                played = 0;
            }
            int tix = PREFS.getInt("tix", 0);
            System.out.println("You have played " + Game.getTitle() + " " + played + " times for " + tix / 60 + " minutes");
            System.out.println("Max games " + configuration.getMaxGames() + " / max time " + configuration.getMaxTime() / 60 + " / max level " + configuration.getMaxLevel());
            if (Game.isDemoExpired() && (configuration.isCrippled() || playedThisSession > 0)) {
                NagScreen.show("Your demo has expired!", true);
                return;
            }
            ++played;
            played ^= 0xCCCCCABE;
            played = played >> 16 & 0xFFFF | played << 16;
            PREFS.putInt("played" + Game.getVersion(), played ^= 0xAF6AD755);
            gameInfo.onNewGame();
            ++playedThisSession;
        }
        SFX.newGame();
        if (Game.isRestoreAvailable()) {
            Game.restoreGame();
        } else {
            Game.cleanGame();
        }
    }

    public static void gameOver() {
        SFX.gameOver();
        game.doGameOver();
    }

    protected abstract void doGameOver();

    public static void endGame() {
        Game.writeTix();
        game.doEndGame();
    }

    protected void doEndGame() {
        Game.showTitleScreen();
    }

    public static void showOptions() {
        game.doShowOptions();
    }

    public static void showCredits() {
        game.doShowCredits();
    }

    protected void doShowCredits() {
        CreditsScreen.show();
    }

    public static void showHelp() {
        shownInstructions = true;
        game.doShowHelp();
    }

    protected void doShowHelp() {
        InstructionsScreen.show();
    }

    public static void showTitleScreen() {
        game.doShowTitleScreen();
    }

    public static void showRegisterScreen() {
        game.doShowRegisterScreen();
    }

    protected void doShowRegisterScreen() {
        RegisterScreen.show();
    }

    protected void doShowTitleScreen() {
        TitleScreen.show();
    }

    protected void doShowOptions() {
    }

    public static void showHiscores() {
        game.doShowHiscores();
    }

    protected void doShowHiscores() {
        HiscoresScreen.show(null);
    }

    private static void screenshot() {
        MultiBuffer data = new MultiBuffer(org.lwjgl.opengl.Display.getDisplayMode().getWidth() * org.lwjgl.opengl.Display.getDisplayMode().getHeight() * 3);
        GL11.glReadBuffer((int)1028);
        GL11.glReadPixels((int)0, (int)0, (int)org.lwjgl.opengl.Display.getDisplayMode().getWidth(), (int)org.lwjgl.opengl.Display.getDisplayMode().getHeight(), (int)6407, (int)5121, (ByteBuffer)data.bytes);
        GL11.glReadBuffer((int)1029);
        int i = 0;
        while (i < 99) {
            File f = new File(String.valueOf(dirPrefix) + (i < 10 ? "screenshot0" : "screenshot") + i + ".raw");
            if (!f.exists()) {
                try {
                    FileOutputStream fos = new FileOutputStream(f);
                    byte[] buf = new byte[org.lwjgl.opengl.Display.getDisplayMode().getWidth() * org.lwjgl.opengl.Display.getDisplayMode().getHeight() * 3];
                    data.bytes.get(buf);
                    fos.write(buf);
                    fos.flush();
                    fos.close();
                    System.out.println("Wrote screenshot:" + f.getName());
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                break;
            }
            ++i;
        }
    }

    private void tick() {
        Binding.poll();
        int i = 0;
        while (i < 256) {
            if (Keyboard.isKeyDown((int)i)) {
                Game.KEYDOWN[i] = !KEYWASDOWN[i];
                Game.KEYWASDOWN[i] = true;
            } else {
                Game.KEYWASDOWN[i] = false;
                Game.KEYDOWN[i] = false;
            }
            ++i;
        }
        if (Keyboard.isKeyDown((int)1)) {
            ++this.panic;
            if (this.panic == 60) {
                Game.exit();
            }
        } else {
            this.panic = 0;
        }
        Game.wasKeyPressed(88);
        if (Game.wasKeyPressed(59) && !org.lwjgl.opengl.Display.isFullscreen()) {
            boolean bl = screenSize = !screenSize;
            if (screenSize) {
                try {
                    org.lwjgl.opengl.Display.setDisplayMode((DisplayMode)new DisplayMode(this.width << 1, this.height << 1));
                    GL11.glViewport((int)0, (int)0, (int)(this.width << 1), (int)(this.height << 1));
                    viewPort.setBounds(0, 0, this.width << 1, this.height << 1);
                }
                catch (LWJGLException e) {
                    e.printStackTrace();
                    Game.exit();
                }
            } else {
                try {
                    org.lwjgl.opengl.Display.setDisplayMode((DisplayMode)new DisplayMode(this.width, this.height));
                    GL11.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
                    viewPort.setBounds(0, 0, this.width, this.height);
                }
                catch (LWJGLException e) {
                    e.printStackTrace();
                    Game.exit();
                }
            }
        }
        if (Game.wasKeyPressed(64)) {
            Game.screenshot();
        }
        if (Game.wasKeyPressed(25) && pauseEnabled) {
            boolean bl = paused = !paused;
            if (game != null) {
                if (paused) {
                    this.onPaused();
                } else {
                    this.onResumed();
                }
            }
        }
        if (!paused) {
            Timer.tick();
            Screen.tickAllScreens();
            this.doTick();
            if (AL.isCreated()) {
                soundPlayer.play();
                musicPlayer.play();
            }
        }
    }

    private final void doTick() {
        if (waitForKey) {
            if (Game.wasKeyPressed(21) || Binding.isBindingDown("yes.binding") || Binding.isBindingDown("yes.binding.alt")) {
                Game.doRestoreGame();
                this.stopWaitingForKey();
            } else if (Game.wasKeyPressed(49) || Binding.isBindingDown("no.binding") || Binding.isBindingDown("no.binding.alt")) {
                this.stopWaitingForKey();
                Game.cleanGame();
            } else if (Game.wasKeyPressed(1) || Binding.isBindingDown("cancel.binding") || Binding.isBindingDown("cancel.binding.alt")) {
                this.stopWaitingForKey();
            }
        }
        this.doGameTick();
    }

    protected abstract void doGameTick();

    protected void onPaused() {
    }

    protected void onResumed() {
    }

    private void render() {
        GL11.glClear((int)16384);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)(-Game.getWidth()) / 2.0f), (float)((float)(-Game.getHeight()) / 2.0f), (float)-256.0f);
        Screen.renderAllScreens();
        GL11.glPopMatrix();
        GL11.glFinish();
    }

    public static String getScoreGroup() {
        return scoreGroup;
    }

    public static void setScoreGroup(String scoreGroup) {
        Game.scoreGroup = scoreGroup;
    }

    public static boolean wasKeyPressed(int key) {
        return KEYDOWN[key];
    }

    public static void onRemoteCallSuccess() {
        PREFS.putBoolean("online", true);
    }

    public static boolean isRemoteCallAllowed() {
        return PREFS.getBoolean("online", false);
    }

    public static void setMusicVolume(float vol) {
        musicVolume = (int)Math.max(0.0f, Math.min(100.0f, vol * 100.0f));
        if (music != null) {
            if (music.getStream() != null) {
                float f = music.getStream().getSourceStream().getGain() * vol;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("net.puppygames.applet.Game");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                music.setGain(f, (Object)clazz);
            } else {
                float f = music.getBuffer().getGain() * vol;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("net.puppygames.applet.Game");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                music.setGain(f, (Object)clazz);
            }
        }
        PREFS.putInt("musicvolume", musicVolume);
    }

    public static void setSFXVolume(float vol) {
        sfxVolume = (int)Math.max(0.0f, Math.min(100.0f, vol * 100.0f));
        PREFS.putInt("sfxvolume", sfxVolume);
    }

    public static float getMusicVolume() {
        return (float)musicVolume / 100.0f;
    }

    public static float getSFXVolume() {
        return (float)sfxVolume / 100.0f;
    }

    public static Rectangle getViewPort() {
        return viewPort;
    }

    public static void loadBindings() {
        try {
            byte[] b = PREFS.getByteArray("bindings", null);
            if (b == null) {
                Binding.resetToDefaults();
            } else {
                Binding.load(new ByteArrayInputStream(b));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveBindings() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            Binding.save(baos);
            PREFS.putByteArray("bindings", baos.toByteArray());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void redefineKeys() {
        game.doRedefineKeys();
    }

    public static void saveGame() {
        if (!allowSave) {
            return;
        }
        File file = new File(String.valueOf(Game.getDirectoryPrefix()) + RESTORE_FILE);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            gameState.setMagic(new Random().nextLong());
            PREFS.putLong("tox", gameState.getMagic());
            oos.writeObject(gameState);
            oos.flush();
            fos.close();
            allowSave = false;
            ((EffectFeature)Resources.get((String)SAVE_GAME_EFFECT_FEATURE)).spawn(TitleScreen.getInstance());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        TitleScreen.show();
    }

    public static boolean isRestoreAvailable() {
        File file = new File(String.valueOf(Game.getDirectoryPrefix()) + RESTORE_FILE);
        return file.exists();
    }

    private void stopWaitingForKey() {
        topScreen.setEnabled(true);
        questionEffect.finish();
        questionEffect = null;
        waitForKey = false;
    }

    private static void cleanGame() {
        File file = new File(String.valueOf(Game.getDirectoryPrefix()) + RESTORE_FILE);
        if (file.exists() && !file.delete()) {
            System.out.println("Failed to delete save file");
        }
        allowSave = true;
        game.setGameState(game.createGameState());
        gameState.init();
    }

    protected abstract GameState createGameState();

    private static void restoreGame() {
        if (!Game.isRestoreAvailable()) {
            return;
        }
        topScreen = Screen.getTopScreen();
        if (topScreen == null) {
            return;
        }
        try {
            questionEffect = ((EffectFeature)Resources.get((String)RESTORE_GAME_EFFECT_FEATURE)).spawn(topScreen);
            questionEffect.spawn(topScreen);
            waitForKey = true;
            topScreen.setEnabled(false);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private static void doRestoreGame() {
        allowSave = true;
        File file = new File(String.valueOf(Game.getDirectoryPrefix()) + RESTORE_FILE);
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        ObjectInputStream ois = null;
        try {
            try {
                fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis);
                ois = new ObjectInputStream(bis);
                game.setGameState((GameState)ois.readObject());
                long tox = PREFS.getLong("tox", 0L);
                if (tox != gameState.getMagic()) {
                    throw new Exception("Invalid game state");
                }
                gameState.reinit();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception exception) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
            PREFS.putLong("tox", new Random().nextLong());
            if (!file.delete()) {
                System.out.println("Failed to delete save file");
            }
        }
    }

    protected void setGameState(GameState newGameState) {
        gameState = newGameState;
    }

    protected void doRedefineKeys() {
        BindingsScreen.show();
    }

    public int getMessageSequence() {
        return this.messageSequence;
    }

    public static void alert(String message) {
        Sys.alert((String)Game.getTitle(), (String)message);
    }
}

