/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.resources;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLBaseTexture;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.Dimension;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadableDimension;
import org.lwjgl.util.Renderable;
import org.lwjgl.util.WritableDimension;

public class Background
extends Feature {
    private static final long serialVersionUID = 1L;
    private static GLBaseTexture current;
    private String top_left;
    private String top_right;
    private String bottom_left;
    private String bottom_right;
    private String top;
    private String left;
    private String bottom;
    private String right;
    private String middle;
    private Color color;
    private transient SpriteImage top_left_image;
    private transient SpriteImage top_right_image;
    private transient SpriteImage bottom_left_image;
    private transient SpriteImage bottom_right_image;
    private transient SpriteImage top_image;
    private transient SpriteImage left_image;
    private transient SpriteImage bottom_image;
    private transient SpriteImage right_image;
    private transient SpriteImage middle_image;

    public Background(String name) {
        super(name);
    }

    public Instance spawn() {
        return new Instance();
    }

    public class Instance
    implements Renderable,
    ReadableDimension,
    WritableDimension {
        private final Dimension size = new Dimension();
        private final Color instanceColor = new Color(Color.WHITE);

        private Instance() {
        }

        public void render() {
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            ColorUtil.setGLColor((ReadableColor)Background.this.color, (ReadableColor)this.instanceColor);
            this.drawBottomLeft();
            this.drawBottom();
            this.drawLeft();
            this.drawTopLeft();
            this.drawBottomRight();
            this.drawMiddle();
            this.drawTop();
            this.drawRight();
            this.drawTopRight();
            if (current != null) {
                GL11.glEnd();
                current = null;
            }
        }

        private void drawBottomLeft() {
            int w = Math.min(this.size.getWidth(), Background.this.bottom_left_image.getWidth());
            int h = Math.min(this.size.getHeight(), Background.this.bottom_left_image.getHeight());
            this.drawImage(Background.this.bottom_left_image, 0, 0, w, h);
        }

        private void drawBottom() {
            int w = this.size.getWidth() - (Background.this.bottom_left_image.getWidth() + Background.this.bottom_right_image.getWidth());
            int h = Math.min(Background.this.bottom_image.getHeight(), this.size.getHeight());
            this.drawImage(Background.this.bottom_image, Background.this.bottom_left_image.getWidth(), 0, w, h);
        }

        private void drawLeft() {
            int w = Math.min(Background.this.left_image.getWidth(), this.size.getWidth());
            int h = this.size.getHeight() - (Background.this.bottom_left_image.getHeight() + Background.this.top_left_image.getHeight());
            this.drawImage(Background.this.left_image, 0, Background.this.bottom_left_image.getHeight(), w, h);
        }

        private void drawTopLeft() {
            int y = Math.max(Background.this.top_left_image.getHeight(), this.size.getHeight() - Background.this.top_left_image.getHeight());
            int w = Math.min(this.size.getWidth(), Background.this.top_left_image.getWidth());
            int h = Math.min(this.size.getHeight() - y, Background.this.top_left_image.getHeight());
            this.drawImage(Background.this.top_left_image, 0, y, w, h);
        }

        private void drawBottomRight() {
            int x = Math.max(Background.this.bottom_right_image.getWidth(), this.size.getWidth() - Background.this.bottom_right_image.getWidth());
            int w = Math.min(this.size.getWidth() - x, Background.this.bottom_right_image.getWidth());
            int h = Math.min(this.size.getHeight(), Background.this.bottom_right_image.getHeight());
            this.drawImage(Background.this.bottom_right_image, x, 0, w, h);
        }

        private void drawMiddle() {
            int w = this.size.getWidth() - (Background.this.left_image.getWidth() + Background.this.right_image.getWidth());
            int h = this.size.getHeight() - (Background.this.bottom_image.getHeight() + Background.this.top_image.getHeight());
            this.drawImage(Background.this.middle_image, Background.this.bottom_left_image.getWidth(), Background.this.bottom_left_image.getHeight(), w, h);
        }

        private void drawTop() {
            int y = Math.max(Background.this.top_image.getHeight(), this.size.getHeight() - Background.this.top_image.getHeight());
            int w = this.size.getWidth() - (Background.this.top_left_image.getWidth() + Background.this.top_right_image.getWidth());
            int h = Math.min(Background.this.top_image.getHeight(), this.size.getHeight());
            this.drawImage(Background.this.top_image, Background.this.top_left_image.getWidth(), y, w, h);
        }

        private void drawRight() {
            int x = Math.max(Background.this.right_image.getWidth(), this.size.getWidth() - Background.this.right_image.getWidth());
            int w = Math.min(Background.this.right_image.getWidth(), this.size.getWidth());
            int h = this.size.getHeight() - (Background.this.bottom_right_image.getHeight() + Background.this.top_right_image.getHeight());
            this.drawImage(Background.this.right_image, x, Background.this.bottom_right_image.getHeight(), w, h);
        }

        private void drawTopRight() {
            int x = Math.min(this.size.getWidth() - Background.this.top_right_image.getWidth(), this.size.getWidth());
            int y = Math.min(this.size.getHeight() - Background.this.top_right_image.getHeight(), this.size.getHeight());
            int w = this.size.getWidth() - x;
            int h = this.size.getHeight() - y;
            this.drawImage(Background.this.top_right_image, x, y, w, h);
        }

        private void drawImage(SpriteImage image, int x, int y, int w, int h) {
            if (w < 1 || h < 1) {
                return;
            }
            int nw = w / image.getWidth();
            int nh = h / image.getHeight();
            int rw = w % image.getWidth();
            int rh = h % image.getHeight();
            int yyy = y;
            int yy = 0;
            while (yy < nh) {
                int xxx = x;
                int xx = 0;
                while (xx < nw) {
                    this.blit(image, xxx, yyy, image.getWidth(), image.getHeight());
                    xxx += image.getWidth();
                    ++xx;
                }
                if (rw != 0) {
                    this.blit(image, xxx, yyy, rw, image.getHeight());
                }
                yyy += image.getHeight();
                ++yy;
            }
            if (rh != 0) {
                int xxx = x;
                int xx = 0;
                while (xx < nw) {
                    this.blit(image, xxx, yyy, image.getWidth(), rh);
                    xxx += image.getWidth();
                    ++xx;
                }
                if (rw != 0) {
                    this.blit(image, xxx, yyy, rw, rh);
                }
            }
        }

        private void blit(SpriteImage image, int x, int y, int w, int h) {
            if (current != image.getTexture()) {
                if (current != null) {
                    GL11.glEnd();
                }
                current = image.getTexture();
                current.render();
                GL11.glBegin((int)7);
            }
            GL11.glTexCoord2f((float)image.getTx0(), (float)image.getTy0());
            GL11.glVertex2i((int)x, (int)y);
            float tx1 = this.ip(image.getTx0(), image.getTx1(), w, image.getWidth());
            GL11.glTexCoord2f((float)tx1, (float)image.getTy0());
            GL11.glVertex2i((int)(x + w), (int)y);
            float ty1 = this.ip(image.getTy0(), image.getTy1(), h, image.getHeight());
            GL11.glTexCoord2f((float)tx1, (float)ty1);
            GL11.glVertex2i((int)(x + w), (int)(y + h));
            GL11.glTexCoord2f((float)image.getTx0(), (float)ty1);
            GL11.glVertex2i((int)x, (int)(y + h));
        }

        private float ip(float a, float b, int p, int q) {
            return LinearInterpolator.instance.interpolate(a, b, (float)p / (float)q);
        }

        public int getHeight() {
            return this.size.getHeight();
        }

        public void getSize(WritableDimension dest) {
            this.size.getSize(dest);
        }

        public int getWidth() {
            return this.size.getWidth();
        }

        public void setHeight(int height) {
            this.size.setHeight(height);
        }

        public void setSize(int w, int h) {
            this.size.setSize(w, h);
        }

        public void setSize(ReadableDimension d) {
            this.size.setSize(d);
        }

        public void setWidth(int width) {
            this.size.setWidth(width);
        }

        public void setColor(byte r, byte g, byte b) {
            this.instanceColor.set(r, g, b);
        }

        public void setColor(byte r, byte g, byte b, byte a) {
            this.instanceColor.set(r, g, b, a);
        }

        public void setColor(int r, int g, int b) {
            this.instanceColor.set(r, g, b);
        }

        public void setColor(int r, int g, int b, int a) {
            this.instanceColor.set(r, g, b, a);
        }

        public void setColor(ReadableColor src) {
            this.instanceColor.setColor(src);
        }
    }
}

