/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.openal;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.openal.ALResource;
import com.shavenpuppy.jglib.openal.ALSource;
import com.shavenpuppy.jglib.openal.ALStreamInstance;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import org.lwjgl.openal.AL;
import org.w3c.dom.Element;

public class ALStream
extends ALResource {
    public static final long serialVersionUID = 1L;
    protected String url;
    protected float gain;
    protected float pitch;
    protected int priority;
    protected boolean looped;
    private transient ArrayList instance;

    public ALStream() {
    }

    public ALStream(String name) {
        super(name);
    }

    protected void doALCreate() throws Exception {
        if (!AL.isCreated()) {
            return;
        }
        this.instance = new ArrayList();
        ALStreamInstance ret = new ALStreamInstance(this);
        ret.create();
        this.instance.add(ret);
    }

    protected void doALDestroy() {
        if (this.instance != null) {
            Iterator i = this.instance.iterator();
            while (i.hasNext()) {
                ((ALStreamInstance)i.next()).destroy();
            }
            this.instance = null;
        }
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        this.url = element.getAttribute("url");
        String gainS = element.getAttribute("gain");
        this.gain = gainS != null && !"".equals(gainS) ? Float.parseFloat(gainS) : 1.0f;
        String pitchS = element.getAttribute("pitch");
        this.pitch = pitchS != null && !"".equals(pitchS) ? Float.parseFloat(pitchS) : 1.0f;
        try {
            this.priority = Integer.parseInt(element.getAttribute("priority"));
        }
        catch (NumberFormatException e) {
            throw new Exception(this + " has no priority specified.");
        }
        this.looped = XMLUtil.getBoolean(element, "looped", false);
    }

    public String toString() {
        return "ALStream[" + this.url + "]";
    }

    public float getGain() {
        return this.gain;
    }

    public float getPitch() {
        return this.pitch;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isLooped() {
        return this.looped;
    }

    public String getURL() {
        return this.url;
    }

    public ALStreamInstance getInstance(ALSource source) throws Exception {
        int i = 0;
        while (i < this.instance.size()) {
            ALStreamInstance ret = (ALStreamInstance)this.instance.get(i);
            if (!ret.isPlaying()) {
                ret.setOwner(source);
                return ret;
            }
            ++i;
        }
        ALStreamInstance ret = new ALStreamInstance(this);
        ret.create();
        ret.setOwner(source);
        this.instance.add(ret);
        return ret;
    }
}

