/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import net.java.games.input.Component;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.LinuxEventDevice;
import net.java.games.input.Rumbler;

abstract class LinuxForceFeedbackEffect
implements Rumbler {
    private final LinuxEventDevice device;
    private final int ff_id;

    public LinuxForceFeedbackEffect(LinuxEventDevice device) throws IOException {
        this.device = device;
        this.ff_id = this.upload(-1, 0.0f);
    }

    protected abstract int upload(int var1, float var2) throws IOException;

    private final void write(int value) throws IOException {
        this.device.writeEvent(21, this.ff_id, value);
    }

    protected final LinuxEventDevice getDevice() {
        return this.device;
    }

    public final void rumble(float intensity) {
        try {
            if (intensity > 0.0f) {
                this.upload(this.ff_id, intensity);
                this.write(1);
            } else {
                this.write(0);
            }
        }
        catch (IOException e) {
            ControllerEnvironment.logln("Failed to rumble: " + e);
        }
    }

    public final void erase() throws IOException {
        this.device.eraseEffect(this.ff_id);
    }

    public final String getAxisName() {
        return null;
    }

    public final Component.Identifier getAxisIdentifier() {
        return null;
    }
}

