/*
 * Decompiled with CFR 0.152.
 */
package puppytron.powerups;

import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.LabelEffect;
import org.lwjgl.util.Color;
import puppytron.GameScreen;
import puppytron.Powerup;
import puppytron.Puppytron;
import puppytron.Res;
import puppytron.powerups.SmartBombPowerup;

public class ShieldPowerup
extends Powerup {
    public ShieldPowerup() {
        super("+1 SHIELD");
    }

    protected void doSpawn() {
        this.sprite.setAppearance(Res.getPowerupShieldImage());
    }

    protected void collect() {
        int shields;
        super.collect();
        if (GameScreen.getPlayer().getMultiplier() > 1) {
            GameScreen.getPlayer().deactivateBonus();
        }
        if ((shields = GameScreen.getPlayer().getShields()) < 10) {
            GameScreen.getPlayer().setShields(shields + 1);
            GameScreen.getPlayer().resetMegaBonus();
        } else {
            Puppytron.addScore(GameScreen.getPlayer().getMegaBonus());
            LabelEffect le = new LabelEffect(Res.getSmallFont(), "MEGABONUS", Color.YELLOW, Color.RED, 80, 40);
            le.setVelocity(0.0f, 4.0f);
            le.setAcceleration(0.0f, -0.05f);
            le.setLocation((float)((int)this.x), (float)((int)this.y));
            le.setVisible(true);
            le.spawn((Screen)GameScreen.getInstance());
            LabelEffect le2 = new LabelEffect(Res.getBigFont(), String.valueOf(GameScreen.getPlayer().getMegaBonus()), Color.WHITE, Color.YELLOW, 80, 40);
            le2.setVelocity(0.0f, 2.0f);
            le2.setAcceleration(0.0f, -0.025f);
            le2.setLocation((float)((int)this.x), (float)((int)this.y));
            le2.setVisible(true);
            le2.spawn((Screen)GameScreen.getInstance());
            GameScreen.getPlayer().nextMegaBonus();
        }
    }

    protected Powerup getNextType() {
        return new SmartBombPowerup();
    }
}

