/*
 * Decompiled with CFR 0.152.
 */
package puppytron;

import com.shavenpuppy.jglib.openal.ALBuffer;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.BlastEffect;
import net.puppygames.applet.effects.Emitter;
import puppytron.AttackDrone;
import puppytron.DefenceDrone;
import puppytron.Entity;
import puppytron.GameScreen;
import puppytron.Player;
import puppytron.Res;
import puppytron.SmartBombShock;

public class Mine
extends Entity {
    private static final float BLAST_RADIUS = 60.0f;
    private static final int BLAST_DURATION = 40;
    private static final int FADE_DURATION = 15;
    private static final int PHASE_NORMAL = 0;
    private static final int PHASE_EXPLODE = 1;
    private static final int DURATION = 240;
    private int tick;
    private int level;
    private int phase;
    private int duration;
    private boolean armed = true;
    private boolean dangerous = true;
    private float radius;
    private BlastEffect blast;

    public Mine(int level, float x, float y) {
        this.level = level;
        this.x = x;
        this.y = y;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean canCollide() {
        return this.phase == 0 || this.phase == 1 && this.dangerous && !this.blast.isFading();
    }

    public void onCollision(Entity entity) {
        entity.onCollisionWithMine(this);
    }

    public float getRadius() {
        return this.phase == 0 ? 8.0f : this.radius;
    }

    protected void doSpawn() {
        this.sprite.setAppearance(Res.getMineImage(this.level));
        Game.allocateSound((ALBuffer)Res.getMineLaid());
    }

    protected void doRespawn() {
    }

    protected void doTick() {
        switch (this.phase) {
            case 0: {
                ++this.tick;
                if (this.tick < 240) break;
                this.explode();
                break;
            }
            case 1: {
                this.radius = this.blast.getRadius();
                if (this.blast.isActive()) break;
                this.remove();
            }
        }
    }

    protected void onCollisionWithPlayer(Player player) {
        System.out.println("hit");
        if (this.phase == 0) {
            this.armed = false;
            this.explode();
        } else {
            this.dangerous = false;
        }
    }

    protected void onCollisionWithShockwave(SmartBombShock shock) {
        if (this.phase == 0) {
            this.armed = false;
            this.explode();
        }
    }

    protected void onCollisionWithAttackDrone(AttackDrone drone) {
        if (this.phase == 0) {
            this.armed = false;
            this.explode();
        }
    }

    protected void onCollisionWithDefenceDrone(DefenceDrone drone) {
        if (this.phase == 0) {
            this.armed = false;
            this.explode();
        }
    }

    void explode() {
        Emitter e = Res.getMineExplosion(this.level).spawn((Screen)GameScreen.getInstance());
        e.setLocation(this.x, this.y);
        if (this.armed && this.level == 3) {
            this.phase = 1;
            this.tick = 0;
            this.blast = new BlastEffect(this.x, this.y, 40, 4, 60.0f, 20.0f, Res.getBombTexture());
            this.blast.spawn((Screen)GameScreen.getInstance());
            this.sprite.deallocate();
        } else {
            this.remove();
        }
    }
}

