/*
 * Decompiled with CFR 0.152.
 */
package puppytron;

import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.BlastEffect;
import net.puppygames.applet.effects.Emitter;
import puppytron.Entity;
import puppytron.GameScreen;
import puppytron.Player;
import puppytron.Res;

public class Bomb
extends Entity {
    private static final float BULLET_SPEED = 2.0f;
    public static final float BOSS_BLAST_RADIUS = 90.0f;
    public static final float ULTRA_BLAST_RADIUS = 45.0f;
    public static final int BOSS_BLAST_DURATION = 60;
    public static final int ULTRA_BLAST_DURATION = 30;
    private static final int FADE_DURATION = 20;
    private static final int PHASE_SHOOT = 0;
    private static final int PHASE_EXPLODE = 1;
    private static final int PHASE_FADE = 2;
    private int phase;
    private int tick;
    private int duration;
    private int blastDuration;
    private boolean dangerous = true;
    private float radius;
    private float blastSize;
    private transient Emitter emitter;
    private transient BlastEffect blast;

    public Bomb(float x, float y, float tx, float ty, float blastSize, int blastDuration) {
        this.x = x;
        this.y = y;
        this.blastSize = blastSize;
        this.blastDuration = blastDuration;
        float dist = (float)Math.sqrt((x - tx) * (x - tx) + (y - ty) * (y - ty));
        this.duration = (int)(dist / 2.0f);
        this.vx = 2.0f * (tx - x) / dist;
        this.vy = 2.0f * (ty - y) / dist;
    }

    public boolean canCollide() {
        return this.phase == 1 && this.dangerous && this.blast != null && !this.blast.isFading();
    }

    public void onCollision(Entity entity) {
        entity.onCollisionWithBomb(this);
    }

    protected void onCollisionWithPlayer(Player player) {
        this.dangerous = false;
    }

    public float getRadius() {
        return this.radius;
    }

    protected void doSpawn() {
        this.sprite.setAppearance((AnimatedAppearance)Res.getBombAppearance());
        this.emitter = Res.getBombEmitter().spawn((Screen)GameScreen.getInstance());
        this.emitter.setLocation(this.x, this.y);
        this.sprite.setLayer(2);
    }

    protected void doTick() {
        switch (this.phase) {
            case 0: {
                ++this.tick;
                if (this.tick >= this.duration) {
                    this.phase = 1;
                    this.tick = 0;
                    this.blast = new BlastEffect(this.x, this.y, this.blastDuration, this.blastDuration / 10, this.blastSize, this.blastSize / 3.0f, Res.getBombTexture());
                    this.blast.spawn((Screen)GameScreen.getInstance());
                    if (this.emitter != null) {
                        this.emitter.remove();
                        this.emitter = null;
                    }
                    this.sprite.deallocate();
                    this.vx = 0.0f;
                    this.vy = 0.0f;
                    Game.allocateSound((ALBuffer)Res.getBombDetonated());
                    break;
                }
                if (this.emitter == null) break;
                this.emitter.setLocation(this.x, this.y);
                break;
            }
            case 1: {
                if (this.blast == null) {
                    this.remove();
                    break;
                }
                this.radius = this.blast.getRadius();
                if (this.blast.isActive()) break;
                this.remove();
            }
        }
    }

    protected void doRespawn() {
        this.emitter = Res.getBombEmitter().spawn((Screen)GameScreen.getInstance());
        this.emitter.setLocation(this.x, this.y);
    }

    protected void doRemove() {
        if (this.sprite != null) {
            this.sprite.deallocate();
            this.sprite = null;
        }
        if (this.emitter != null) {
            this.emitter.remove();
            this.emitter = null;
        }
        if (this.blast != null) {
            this.blast.remove();
            this.blast = null;
        }
    }
}

