/*
 * Decompiled with CFR 0.152.
 */
package puppytron;

import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.util.Util;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import puppytron.Bomb;
import puppytron.EnemyBullet;
import puppytron.Entity;
import puppytron.GameScreen;
import puppytron.Gidrah;
import puppytron.Mine;
import puppytron.Movement;
import puppytron.Res;

public class AttackDrone
extends Entity {
    private static final int MAX_WOUNDS = 50;
    private int wounds;
    private int facing = 1;
    private transient Movement movement;

    public AttackDrone() {
        this.x = GameScreen.getPlayer().getX() + (float)Util.random((int)-8, (int)8);
        this.y = GameScreen.getPlayer().getY() + (float)Util.random((int)-8, (int)8);
    }

    protected void doSpawn() {
        this.sprite.setAppearance((AnimatedAppearance)Res.getAttackDroneAppearance());
        this.movement = Res.getAttackDroneMovement().spawn(this);
    }

    protected void doRespawn() {
        this.movement = Res.getAttackDroneMovement().spawn(this);
    }

    public boolean canCollide() {
        return true;
    }

    public void onCollision(Entity entity) {
        entity.onCollisionWithAttackDrone(this);
    }

    private void damage(int amount) {
        this.wounds += amount;
        if (this.wounds > 50) {
            this.kill();
        }
        Emitter emitter = Res.getDeflectEmitter().spawn((Screen)GameScreen.getInstance());
        emitter.setLocation(this.x, this.y);
    }

    private void kill() {
        this.remove();
        Emitter emitter = Res.getPowerupRicochetEmitterFeature().spawn((Screen)GameScreen.getInstance());
        emitter.setLocation(this.x, this.y);
    }

    protected void onCollisionWithEnemyBullet(EnemyBullet enemyBullet) {
        this.damage(1);
    }

    protected void onCollisionWithGidrah(Gidrah gidrah) {
        if (gidrah.isDangerous()) {
            this.damage(gidrah.getLevel() + 1);
        }
    }

    protected void onCollisionWithMine(Mine mine) {
        this.damage(mine.getLevel() + 1);
    }

    protected void onCollisionWithBomb(Bomb bomb) {
        this.damage(1);
    }

    public float getRadius() {
        return 11.0f;
    }

    public void setFacing(int facing) {
        this.facing = facing;
    }

    protected void doTick() {
        this.movement.tick(this);
        this.sprite.setMirrored(this.facing == -1);
    }
}

