/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Memory;
import com.shavenpuppy.jglib.MultiBuffer;
import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.algorithms.RadixSort;
import com.shavenpuppy.jglib.opengl.GLBaseTexture;
import com.shavenpuppy.jglib.opengl.nvidia.AGPMemory;
import com.shavenpuppy.jglib.opengl.nvidia.GLFence;
import com.shavenpuppy.jglib.sprites.FlashStyle;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.sprites.Style;
import com.shavenpuppy.jglib.sprites.TextureRun;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.vector.Vector3i;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.Color;
import org.lwjgl.util.WritableColor;

class SpriteRenderer
extends Resource {
    private static final long serialVersionUID = 1L;
    private static final Vector3i offset = new Vector3i();
    private Memory memory;
    private MultiBuffer buffer;
    private FloatBuffer texCoordBuffer;
    private ByteBuffer colorBuffer;
    private final RadixSort sort = new RadixSort();
    private static final int NO_SCALE = FPMath.ONE;
    private float alpha;
    private final int[] sort_z;
    private final int[] sort_y;
    private final int[] sort_layer;
    private final int[] sort_style;
    private final int[] sort_texture;
    private GLFence fence;
    private static final Color color = new Color();
    private final boolean sortY;
    private TextureRun[] textureRun;
    private int numTextureRuns;
    private final Sprite[] sprite;
    private final Style[] style;
    private int numSprites;
    private final int maxSprites;
    private static final int VERTEX_SIZE = 32;
    private static final int TEXTURE_COORD_OFFSET = 12;
    private static final int COLOR_OFFSET = 20;
    private static final int SPRITE_SIZE = 128;

    SpriteRenderer(boolean sortY, int maxSprites) {
        this.sortY = sortY;
        this.maxSprites = maxSprites;
        this.textureRun = new TextureRun[maxSprites];
        int i = 0;
        while (i < maxSprites) {
            this.textureRun[i] = new TextureRun();
            ++i;
        }
        this.sprite = new Sprite[maxSprites];
        this.style = new Style[maxSprites];
        this.sort_layer = new int[maxSprites];
        this.sort_texture = new int[maxSprites];
        this.sort_style = new int[maxSprites];
        this.sort_z = new int[maxSprites];
        this.sort_y = (int[])(sortY ? new int[maxSprites] : null);
        this.sort.resetIndices();
    }

    protected void doCreate() throws Exception {
        if (GLContext.getCapabilities().GL_NV_vertex_array_range || GLContext.getCapabilities().GL_NV_vertex_array_range2) {
            this.fence = new GLFence();
            this.fence.create();
        }
        this.memory = AGPMemory.allocate(this.maxSprites * 128);
        this.buffer = new MultiBuffer(this.memory.getBuffer());
        this.texCoordBuffer = Memory.chop(this.buffer.bytes, 12).asFloatBuffer();
        this.colorBuffer = Memory.chop(this.buffer.bytes, 20);
        if (FlashStyle.instance == null) {
            FlashStyle.instance = new FlashStyle("flash.style");
            FlashStyle.instance.create();
        }
    }

    protected void doDestroy() {
        this.buffer = null;
        this.texCoordBuffer = null;
        this.colorBuffer = null;
        if (this.fence != null) {
            this.fence.destroy();
            this.fence = null;
        }
        this.memory.destroy();
        this.memory = null;
    }

    public void render(Sprite s) {
        if (s.getImage() == null) {
            return;
        }
        if (s.isFlashing()) {
            if (GLContext.getCapabilities().GL_EXT_secondary_color) {
                this.style[this.numSprites] = FlashStyle.instance;
                this.sprite[this.numSprites++] = s;
            } else {
                this.style[this.numSprites] = s.getImage().getStyle();
                this.sprite[this.numSprites++] = s;
                this.style[this.numSprites] = FlashStyle.instance;
                this.sprite[this.numSprites++] = s;
            }
        } else {
            this.style[this.numSprites] = s.getImage().getStyle();
            this.sprite[this.numSprites++] = s;
        }
    }

    private void writeSpriteToBufferF(int i, Sprite s) {
        float scaledy01;
        float scaledy11;
        float scaledy10;
        float scaledy00;
        float scaledx01;
        float scaledx11;
        float scaledx10;
        float scaledx00;
        SpriteImage image = s.getImage();
        float w = image.getWidth();
        float h = image.getHeight();
        float tx0 = image.getTx0();
        float tx1 = image.getTx1();
        float ty0 = image.getTy0();
        float ty1 = image.getTy1();
        int xscale = s.getXScale();
        int yscale = s.getYScale();
        s.getOffset(offset);
        float x = s.getX();
        float y = s.getY();
        float z = s.getZ();
        int alpha = (int)(this.alpha * (float)s.getAlpha());
        double angle = FPMath.doubleValue(s.getAngle()) * Math.PI * 2.0;
        float scaledx0 = offset.getX() - image.getHotspotX();
        float scaledy0 = offset.getY() - image.getHotspotY();
        float scaledx1 = scaledx0 + w;
        float scaledy1 = scaledy0 + h;
        if (xscale != NO_SCALE || yscale != NO_SCALE) {
            float fxScale = FPMath.floatValue(xscale);
            float fyScale = FPMath.floatValue(yscale);
            scaledx0 *= fxScale;
            scaledx1 *= fxScale;
            scaledy0 *= fyScale;
            scaledy1 *= fyScale;
        }
        if (angle != 0.0) {
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            scaledx00 = (float)(cos * (double)scaledx0 - sin * (double)scaledy0);
            scaledx10 = (float)(cos * (double)scaledx1 - sin * (double)scaledy0);
            scaledx11 = (float)(cos * (double)scaledx1 - sin * (double)scaledy1);
            scaledx01 = (float)(cos * (double)scaledx0 - sin * (double)scaledy1);
            scaledy00 = (float)(sin * (double)scaledx0 + cos * (double)scaledy0);
            scaledy10 = (float)(sin * (double)scaledx1 + cos * (double)scaledy0);
            scaledy11 = (float)(sin * (double)scaledx1 + cos * (double)scaledy1);
            scaledy01 = (float)(sin * (double)scaledx0 + cos * (double)scaledy1);
        } else {
            scaledx00 = scaledx0;
            scaledx10 = scaledx1;
            scaledx11 = scaledx1;
            scaledx01 = scaledx0;
            scaledy00 = scaledy0;
            scaledy10 = scaledy0;
            scaledy11 = scaledy1;
            scaledy01 = scaledy1;
        }
        float x00 = scaledx00 + x;
        float x01 = scaledx01 + x;
        float x11 = scaledx11 + x;
        float x10 = scaledx10 + x;
        float y00 = scaledy00 + y;
        float y01 = scaledy01 + y;
        float y11 = scaledy11 + y;
        float y10 = scaledy10 + y;
        this.buffer.floats.position((i *= 128) >> 2);
        this.buffer.floats.put(x00);
        this.buffer.floats.put(y00);
        this.buffer.floats.put(z);
        this.buffer.floats.put(s.isMirrored() ? tx1 : tx0);
        this.buffer.floats.put(s.isFlipped() ? ty0 : ty1);
        this.buffer.bytes.position(i + 20);
        s.getColor(0, (WritableColor)color);
        this.buffer.bytes.put(color.getRedByte());
        this.buffer.bytes.put(color.getGreenByte());
        this.buffer.bytes.put(color.getBlueByte());
        this.buffer.bytes.put((byte)(color.getAlpha() * alpha >> 8));
        this.buffer.floats.position((i += 32) >> 2);
        this.buffer.floats.put(x10);
        this.buffer.floats.put(y10);
        this.buffer.floats.put(z);
        this.buffer.floats.put(s.isMirrored() ? tx0 : tx1);
        this.buffer.floats.put(s.isFlipped() ? ty0 : ty1);
        this.buffer.bytes.position(i + 20);
        s.getColor(1, (WritableColor)color);
        this.buffer.bytes.put(color.getRedByte());
        this.buffer.bytes.put(color.getGreenByte());
        this.buffer.bytes.put(color.getBlueByte());
        this.buffer.bytes.put((byte)(color.getAlpha() * alpha >> 8));
        this.buffer.floats.position((i += 32) >> 2);
        this.buffer.floats.put(x11);
        this.buffer.floats.put(y11);
        this.buffer.floats.put(z);
        this.buffer.floats.put(s.isMirrored() ? tx0 : tx1);
        this.buffer.floats.put(s.isFlipped() ? ty1 : ty0);
        this.buffer.bytes.position(i + 20);
        s.getColor(2, (WritableColor)color);
        this.buffer.bytes.put(color.getRedByte());
        this.buffer.bytes.put(color.getGreenByte());
        this.buffer.bytes.put(color.getBlueByte());
        this.buffer.bytes.put((byte)(color.getAlpha() * alpha >> 8));
        this.buffer.floats.position((i += 32) >> 2);
        this.buffer.floats.put(x01);
        this.buffer.floats.put(y01);
        this.buffer.floats.put(z);
        this.buffer.floats.put(s.isMirrored() ? tx1 : tx0);
        this.buffer.floats.put(s.isFlipped() ? ty1 : ty0);
        this.buffer.bytes.position(i + 20);
        s.getColor(3, (WritableColor)color);
        this.buffer.bytes.put(color.getRedByte());
        this.buffer.bytes.put(color.getGreenByte());
        this.buffer.bytes.put(color.getBlueByte());
        this.buffer.bytes.put((byte)(color.getAlpha() * alpha >> 8));
    }

    public void postRender() {
        if (this.numSprites == 0) {
            return;
        }
        this.sort();
        this.build();
        GL11.glEnableClientState((int)32884);
        GL11.glVertexPointer((int)3, (int)32, (FloatBuffer)this.buffer.floats);
        GL11.glTexCoordPointer((int)2, (int)32, (FloatBuffer)this.texCoordBuffer);
        GL11.glColorPointer((int)4, (boolean)true, (int)32, (ByteBuffer)this.colorBuffer);
        ContextCapabilities capabilities = GLContext.getCapabilities();
        if (capabilities.GL_NV_vertex_array_range2) {
            GL11.glEnableClientState((int)34099);
        } else if (capabilities.GL_NV_vertex_array_range) {
            GL11.glEnableClientState((int)34077);
        }
        int i = 0;
        while (i < this.numTextureRuns) {
            this.textureRun[i].render();
            ++i;
        }
        if (this.numTextureRuns > 0) {
            this.textureRun[this.numTextureRuns - 1].done();
        }
        if (capabilities.GL_NV_vertex_array_range || capabilities.GL_NV_vertex_array_range2) {
            this.fence.set(34034);
            if (capabilities.GL_NV_vertex_array_range2) {
                GL11.glDisableClientState((int)34099);
            } else if (capabilities.GL_NV_vertex_array_range) {
                GL11.glDisableClientState((int)34077);
            }
        }
    }

    private void build() {
        GLBaseTexture currentTexture = null;
        Style currentStyle = null;
        TextureRun currentTextureRun = null;
        int[] index = this.sort.getIndices();
        int i = 0;
        while (i < this.numSprites) {
            Sprite s = this.sprite[index[i]];
            SpriteImage image = s.getImage();
            GLBaseTexture newTexture = image.getTexture();
            Style newStyle = this.style[index[i]];
            if (newTexture != currentTexture || newStyle != currentStyle) {
                currentTexture = newTexture;
                currentStyle = newStyle;
                currentTextureRun = this.textureRun[this.numTextureRuns++];
                currentTextureRun.init(newTexture, newStyle, i);
            }
            currentTextureRun.add();
            this.writeSpriteToBufferF(i, s);
            ++i;
        }
        this.buffer.floats.flip();
    }

    public void preRender() {
        this.numSprites = 0;
        this.numTextureRuns = 0;
        this.buffer.floats.clear();
        this.buffer.bytes.clear();
        this.buffer.ints.clear();
        if (GLContext.getCapabilities().GL_NV_vertex_array_range || GLContext.getCapabilities().GL_NV_vertex_array_range2) {
            this.fence.finish();
        }
    }

    private void sort() {
        int n = this.numSprites;
        if (this.sortY) {
            int i = 0;
            while (i < n) {
                Sprite s = this.sprite[i];
                this.sort_y[i] = -s.getY();
                this.sort_z[i] = s.getZ();
                this.sort_layer[i] = s.getLayer();
                SpriteImage si = s.getImage();
                this.sort_texture[i] = si.getTexture().getID();
                this.sort_style[i] = this.style[i].getStyleID();
                ++i;
            }
            this.sort.resetIndices().sort(this.sort_texture, n).sort(this.sort_style, n).sort(this.sort_y, n).sort(this.sort_z, n).sort(this.sort_layer, n);
        } else {
            int i = 0;
            while (i < n) {
                Sprite s = this.sprite[i];
                this.sort_z[i] = s.getZ();
                this.sort_layer[i] = s.getLayer();
                SpriteImage si = s.getImage();
                this.sort_texture[i] = si.getTexture().getID();
                this.sort_style[i] = this.style[i].getStyleID();
                ++i;
            }
            this.sort.resetIndices().sort(this.sort_texture, n).sort(this.sort_style, n).sort(this.sort_z, n).sort(this.sort_layer, n);
        }
    }

    void setAlpha(float alpha) {
        this.alpha = alpha;
    }
}

