/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.opengl.GL;
import com.shavenpuppy.jglib.opengl.GLNamedRenderable;
import com.shavenpuppy.jglib.opengl.GLRenderableObject;
import com.shavenpuppy.jglib.opengl.GLResource;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.OpenGLException;
import org.w3c.dom.Element;

public abstract class GLBaseTexture
extends GLResource
implements GLNamedRenderable,
GLRenderableObject {
    public static final long serialVersionUID = 1L;
    protected int target;
    protected int minMode;
    protected int magMode;
    protected boolean wrap;
    protected transient int texture;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.opengl.GLBaseTexture");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public GLBaseTexture(String name) {
        super(name);
    }

    public GLBaseTexture(String name, int target, int minMode, int magMode, boolean wrap) {
        this(name);
        this.target = target;
        this.minMode = minMode;
        this.magMode = magMode;
        this.wrap = wrap;
    }

    protected final void doGLCreate() throws Exception {
        GL.scratch.ints.clear().limit(1);
        GL11.glGenTextures((IntBuffer)GL.scratch.ints);
        this.texture = GL.scratch.ints.get(0);
        this.doCreateTexture();
    }

    protected abstract void doCreateTexture() throws Exception;

    protected void doGLDestroy() throws OpenGLException {
        if (this.texture != 0) {
            GL.scratch.ints.clear();
            GL.scratch.ints.put(0, this.texture);
            GL.scratch.ints.limit(1);
            GL11.glBindTexture((int)3553, (int)0);
            GL11.glDeleteTextures((IntBuffer)GL.scratch.ints);
        }
    }

    public void render() {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError((Object)(this + " is not created yet"));
        }
        GL11.glBindTexture((int)this.target, (int)this.texture);
    }

    public void bind() {
        this.render();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.target = GL.decode(XMLUtil.getString(element, "target"));
        this.minMode = GL.decode(XMLUtil.getString(element, "min"));
        this.magMode = GL.decode(XMLUtil.getString(element, "mag"));
        this.wrap = 1 == GL.decode(XMLUtil.getString(element, "wrap"));
    }

    public final int getID() {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError((Object)(this + " is not created yet"));
        }
        return this.texture;
    }

    public boolean isWrapped() {
        return this.wrap;
    }

    public abstract int getWidth();

    public abstract int getHeight();
}

