/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.openal;

import com.shavenpuppy.jglib.Memory;
import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Wave;
import com.shavenpuppy.jglib.openal.SoundBank;
import com.shavenpuppy.jglib.resources.WaveWrapper;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.InputStream;
import org.w3c.dom.Element;

public class SoundClip
extends Resource
implements WaveWrapper {
    private final SoundBank clipBank;
    private int offset;
    private int length;
    private transient Wave wave;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.openal.SoundClip");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public SoundClip(String name, SoundBank clipBank) {
        super(name);
        this.clipBank = clipBank;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        this.offset = XMLUtil.getInt(element, "offset");
        this.length = XMLUtil.getInt(element, "length");
    }

    protected void doCreate() throws Exception {
        if (!this.clipBank.isCreated()) {
            this.clipBank.create();
        }
        Wave clipBankWave = this.clipBank.getWave();
        this.wave = new Wave(this.length / Wave.getBytesPerSample(clipBankWave.getType()), clipBankWave.getType(), clipBankWave.getFrequency(), Memory.chop(clipBankWave.getData(), this.offset, this.length));
    }

    protected void doDestroy() {
        this.wave = null;
    }

    public Wave getWave() throws Exception {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError();
        }
        if (this.wave.getData() == null) {
            this.doCreate();
        }
        return this.wave;
    }

    public int getFrequency() {
        return this.wave.getFrequency();
    }

    public int getType() {
        return this.wave.getType();
    }

    public InputStream getStream() throws Exception {
        return null;
    }
}

