/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.input;

import java.util.ArrayList;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Controller;
import org.lwjgl.input.ControllerEvent;
import org.lwjgl.input.JInputController;

public class Controllers {
    private static final String WINDOWS_PLUGIN = "net.java.games.input.DirectInputEnvironmentPlugin";
    private static final String LINUX_PLUGIN = "net.java.games.input.LinuxEnvironmentPlugin";
    private static final String MACOS_PLUGIN = "net.java.games.input.OSXEnvironmentPlugin";
    private static ArrayList controllers = new ArrayList();
    private static int controllerCount;
    private static ArrayList events;
    private static ControllerEvent event;
    private static boolean created;

    public static void create() throws LWJGLException {
        if (created) {
            return;
        }
        try {
            String plugins = System.getProperty("jinput.plugins");
            if (plugins == null) {
                if (System.getProperty("os.name").startsWith("Win")) {
                    System.setProperty("jinput.plugins", WINDOWS_PLUGIN);
                }
                if (System.getProperty("os.name").startsWith("Lin")) {
                    System.setProperty("jinput.plugins", LINUX_PLUGIN);
                }
                if (System.getProperty("os.name").startsWith("Mac")) {
                    System.setProperty("jinput.plugins", MACOS_PLUGIN);
                }
            }
            ControllerEnvironment env = ControllerEnvironment.getDefaultEnvironment();
            net.java.games.input.Controller[] found = env.getControllers();
            ArrayList<net.java.games.input.Controller> lollers = new ArrayList<net.java.games.input.Controller>();
            for (int i = 0; i < found.length; ++i) {
                net.java.games.input.Controller c = found[i];
                if (c.getType().equals(Controller.Type.KEYBOARD) || c.getType().equals(Controller.Type.MOUSE)) continue;
                lollers.add(c);
            }
            int length = lollers.size();
            for (int i = 0; i < length; ++i) {
                net.java.games.input.Controller c = (net.java.games.input.Controller)lollers.get(i);
                Controllers.createController(c);
            }
            created = true;
        }
        catch (Throwable e) {
            throw new LWJGLException("Failed to initialise controllers", e);
        }
    }

    private static void createController(net.java.games.input.Controller c) {
        net.java.games.input.Controller[] sub = c.getControllers();
        if (sub.length == 0) {
            JInputController controller = new JInputController(controllerCount, c);
            controllers.add(controller);
            ++controllerCount;
        } else {
            for (int i = 0; i < sub.length; ++i) {
                Controllers.createController(sub[i]);
            }
        }
    }

    public static Controller getController(int index) {
        return (Controller)controllers.get(index);
    }

    public static int getControllerCount() {
        return controllers.size();
    }

    public static void poll() {
        for (int i = 0; i < controllers.size(); ++i) {
            Controllers.getController(i).poll();
        }
    }

    public static void clearEvents() {
        events.clear();
    }

    public static boolean next() {
        if (events.size() == 0) {
            event = null;
            return false;
        }
        event = (ControllerEvent)events.remove(0);
        return event != null;
    }

    public static boolean isCreated() {
        return created;
    }

    public static void destroy() {
    }

    public static Controller getEventSource() {
        return event.getSource();
    }

    public static int getEventControlIndex() {
        return event.getControlIndex();
    }

    public static boolean isEventButton() {
        return event.isButton();
    }

    public static boolean isEventAxis() {
        return event.isAxis();
    }

    public static boolean isEventXAxis() {
        return event.isXAxis();
    }

    public static boolean isEventYAxis() {
        return event.isYAxis();
    }

    public static boolean isEventPovX() {
        return event.isPovX();
    }

    public static boolean isEventPovY() {
        return event.isPovY();
    }

    static void addEvent(ControllerEvent event) {
        if (event != null) {
            events.add(event);
        }
    }

    static {
        events = new ArrayList();
    }
}

