/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.model.loaders;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class XMLUtil {
    XMLUtil() {
    }

    static Element getChild(Element element, String child) throws Exception {
        NodeList nodes = element.getChildNodes();
        Element ret = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node childNode = nodes.item(i);
            if (!childNode.getNodeName().equals(child) || childNode.getNodeType() != 1) continue;
            if (ret != null) {
                throw new Exception("Child element '" + child + "' present multiple times");
            }
            ret = (Element)childNode;
        }
        return ret;
    }

    static List getChildren(Element element, String name) throws Exception {
        NodeList nodes = element.getChildNodes();
        ArrayList<Node> ret = new ArrayList<Node>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node childNode = nodes.item(i);
            if (!childNode.getNodeName().equals(name) || childNode.getNodeType() != 1) continue;
            ret.add(childNode);
        }
        return ret;
    }

    static float getFloat(Element element, String attribute) throws Exception {
        String s = element.getAttribute(attribute);
        if (s == null || "".equals(s)) {
            throw new Exception("Attribute '" + attribute + "' has not been specified for " + element.getNodeName());
        }
        return Float.parseFloat(s);
    }

    static float getFloat(Element element, String attribute, float defaultValue) throws Exception {
        String s = element.getAttribute(attribute);
        if (s == null || "".equals(s)) {
            return defaultValue;
        }
        return Float.parseFloat(s);
    }

    static int getInt(Element element, String attribute) throws Exception {
        String s = element.getAttribute(attribute);
        if (s == null || "".equals(s)) {
            throw new Exception("Attribute '" + attribute + "' has not been specified for " + element.getNodeName());
        }
        return Integer.parseInt(s);
    }

    static int getInt(Element element, String attribute, int defaultValue) throws Exception {
        String s = element.getAttribute(attribute);
        if (s == null || "".equals(s)) {
            return defaultValue;
        }
        return Integer.parseInt(s);
    }

    static String getString(Element element, String attribute) throws Exception {
        String s = element.getAttribute(attribute);
        if (s == null || "".equals(s)) {
            throw new Exception("Attribute '" + attribute + "' has not been specified for " + element.getNodeName());
        }
        return s;
    }

    static String getString(Element element, String attribute, String defaultValue) throws Exception {
        String s = element.getAttribute(attribute);
        if (s == null || "".equals(s)) {
            return defaultValue;
        }
        return s;
    }

    static boolean hasAttribute(Element element, String attribute) {
        String s = element.getAttribute(attribute);
        return s != null && !"".equals(s);
    }
}

