/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.widgets;

import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLString;
import net.puppygames.applet.Game;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Rectangle;

public class TextField {
    private boolean editing;
    private int cursorPos = 0;
    private int flashTick = 0;
    private boolean cursorVisible;
    private GLString display;
    private StringBuffer buffer;
    private int width;

    public TextField(int maxLength, int width) {
        this.display = new GLString(maxLength);
        this.buffer = new StringBuffer(maxLength);
        this.width = width;
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
    }

    public void tick() {
        if (this.editing) {
            this.flashCursor();
            this.processKeyboard();
        }
    }

    private void flashCursor() {
        ++this.flashTick;
        if (this.flashTick > 6) {
            this.flashTick = 0;
            this.cursorVisible = !this.cursorVisible;
        }
    }

    private void processKeyboard() {
        int oldCursorPos = this.cursorPos;
        block9: while (Keyboard.next()) {
            if (!Keyboard.getEventKeyState()) continue;
            int key = Keyboard.getEventKey();
            switch (key) {
                case 207: 
                case 208: {
                    this.cursorPos = this.display.length();
                    break;
                }
                case 199: 
                case 200: {
                    this.cursorPos = 0;
                    break;
                }
                case 203: {
                    if (Keyboard.isKeyDown((int)42)) {
                        this.cursorPos = 0;
                        break;
                    }
                    if (this.cursorPos <= 0) continue block9;
                    --this.cursorPos;
                    break;
                }
                case 205: {
                    if (Keyboard.isKeyDown((int)42)) {
                        this.cursorPos = this.display.length();
                        break;
                    }
                    if (this.cursorPos >= this.display.length()) continue block9;
                    ++this.cursorPos;
                    break;
                }
                case 211: {
                    if (Keyboard.isKeyDown((int)42)) {
                        this.buffer.setLength(0);
                        this.cursorPos = 0;
                        this.display.setText("");
                    } else if (this.cursorPos < this.display.length()) {
                        this.buffer.deleteCharAt(this.cursorPos);
                        this.display.setText(this.buffer.toString());
                    }
                    this.onEdited();
                    break;
                }
                case 14: {
                    if (Keyboard.isKeyDown((int)42)) {
                        this.buffer.setLength(0);
                        this.cursorPos = 0;
                        this.display.setText("");
                    } else if (this.cursorPos > 0) {
                        this.buffer.deleteCharAt(--this.cursorPos);
                        this.display.setText(this.buffer.toString());
                    }
                    this.onEdited();
                    break;
                }
                case 15: 
                case 28: {
                    this.changeFocus();
                    return;
                }
                default: {
                    char c = Keyboard.getEventCharacter();
                    if (c == '\u0016' || key == 210 && Keyboard.isKeyDown((int)42)) {
                        String paste = Sys.getClipboard();
                        if (paste == null) continue block9;
                        int i = 0;
                        while (i < paste.length()) {
                            c = Character.toLowerCase(paste.charAt(i));
                            if (this.buffer.length() >= this.buffer.capacity() || !this.acceptChar(c)) continue block9;
                            this.buffer.insert(this.cursorPos++, c);
                            this.display.setText(this.buffer.toString());
                            this.onEdited();
                            ++i;
                        }
                        continue block9;
                    }
                    if (c < ' ' || c >= '\u007f') continue block9;
                    c = Character.toLowerCase(c);
                    if (this.buffer.length() >= this.buffer.capacity() || !this.acceptChar(c)) continue block9;
                    this.buffer.insert(this.cursorPos++, c);
                    this.display.setText(this.buffer.toString());
                    this.onEdited();
                }
            }
        }
        if (oldCursorPos != this.cursorPos) {
            this.cursorVisible = true;
            this.flashTick = 0;
        }
    }

    public boolean acceptChar(char c) {
        return true;
    }

    public final void changeFocus() {
        this.editing = false;
        this.cursorVisible = false;
        this.flashTick = 0;
        this.onChangeFocus();
    }

    protected void onChangeFocus() {
    }

    protected void onEdited() {
    }

    public boolean isEditing() {
        return this.editing;
    }

    public String getText() {
        return this.display.getText();
    }

    public int length() {
        return this.display.length();
    }

    public void setFont(GLFont font) {
        this.display.setFont(font);
    }

    public void setText(String s) {
        this.display.setText(s);
    }

    public void setLocation(int xp, int yp) {
        this.display.setLocation(xp, yp);
    }

    private int getCursorXPos() {
        if (!this.editing) {
            return 0;
        }
        Rectangle tempBounds = this.display.getGlyphBounds(this.cursorPos - 1, null);
        return tempBounds.getX() + tempBounds.getWidth();
    }

    public void render() {
        int cursorX = this.getCursorXPos();
        GL11.glEnable((int)3089);
        if (cursorX - this.display.getX() > this.width && this.editing) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.width - cursorX + this.display.getX()), (float)0.0f, (float)0.0f);
        }
        float wRatio = (float)Game.getViewPort().getWidth() / (float)Game.getWidth();
        float hRatio = (float)Game.getViewPort().getHeight() / (float)Game.getHeight();
        int sx = (int)((float)this.display.getX() * wRatio) + Game.getViewPort().getX();
        int sw = (int)((float)this.width * wRatio);
        int sy = (int)((float)(this.display.getY() - this.display.getFont().getDescent()) * hRatio) + Game.getViewPort().getY();
        int sh = (int)((float)this.display.getFont().getHeight() * hRatio);
        GL11.glScissor((int)sx, (int)sy, (int)sw, (int)sh);
        this.display.render();
        GL11.glDisable((int)3089);
        if (this.cursorVisible && this.editing) {
            GL11.glDisable((int)3553);
            GL11.glRecti((int)cursorX, (int)(this.display.getY() - this.display.getFont().getDescent()), (int)(cursorX + 4), (int)(this.display.getY() + this.display.getFont().getHeight() - this.display.getFont().getDescent()));
            GL11.glEnable((int)3553);
        }
        if (cursorX - this.display.getX() > this.width && this.editing) {
            GL11.glPopMatrix();
        }
    }
}

