/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.screens;

import com.shavenpuppy.jglib.TextLayout;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLTextArea;
import com.shavenpuppy.jglib.util.CheckOnline;
import java.rmi.Naming;
import net.puppygames.applet.AppletMessageCheckerRemote;
import net.puppygames.applet.Configuration;
import net.puppygames.applet.Game;
import net.puppygames.applet.MessageReturn;
import net.puppygames.applet.Res;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.SFX;
import net.puppygames.applet.screens.GenericButtonHandler;
import net.puppygames.applet.widgets.MessageBox;
import net.puppygames.gamecommerce.shared.ConfigurationDetails;
import net.puppygames.gamecommerce.shared.RegistrationDetails;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;

public class TitleScreen
extends Screen {
    public static final long serialVersionUID = 1L;
    private static TitleScreen instance;
    private Rectangle registrationBounds;
    private Rectangle versionBounds;
    private Color colour;
    private transient GLTextArea registrationDetails;
    private transient GLTextArea versionString;
    private transient boolean messagesChecked;
    private transient MessageReturn pendingMessage;
    private transient MessageBox messageBox;
    private transient boolean deregistrationChecked;

    public TitleScreen(String name) {
        super(name);
    }

    protected void doCreateScreen() throws Exception {
        this.registrationDetails = new GLTextArea();
        this.registrationDetails.setFont(Res.getTinyFont());
        this.registrationDetails.setHorizontalAlignment(TextLayout.CENTERED);
        this.registrationDetails.setVerticalAlignment(GLTextArea.CENTERED);
        this.registrationDetails.setBounds((ReadableRectangle)this.registrationBounds);
        this.versionString = new GLTextArea();
        this.versionString.setFont(Res.getTinyFont());
        this.versionString.setHorizontalAlignment(TextLayout.CENTERED);
        this.versionString.setVerticalAlignment(GLTextArea.CENTERED);
        this.versionString.setBounds((ReadableRectangle)this.versionBounds);
    }

    protected void doRegister() {
        instance = this;
    }

    public static void instantiate() {
        if (!instance.isCreated()) {
            try {
                instance.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static TitleScreen getInstance() {
        return instance;
    }

    public static void show() {
        TitleScreen.instantiate();
        instance.open();
    }

    protected void doTick() {
        if (Game.wasKeyPressed(1)) {
            if (this.messageBox != null) {
                this.messageBox = null;
                this.setEnabled(true);
            } else {
                Game.exit();
            }
        }
        if (this.pendingMessage != null) {
            if (this.pendingMessage.getMessage() != null && this.pendingMessage.getTitle() != null) {
                this.messageBox = new MessageBox();
                this.messageBox.setSize(Game.getWidth() - 20, Game.getHeight() - 20);
                this.messageBox.setTitle(this.pendingMessage.getTitle());
                this.messageBox.setMessage(this.pendingMessage.getMessage());
                this.setEnabled(false);
            }
            if (this.pendingMessage.getReconfigure() != null) {
                try {
                    Game.setConfiguration((Configuration)this.pendingMessage.getReconfigure());
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
            this.pendingMessage = null;
        }
    }

    protected void preRender() {
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
    }

    protected void postRender() {
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)1.0f, (float)-1.0f, (float)0.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.75f);
        this.registrationDetails.render();
        this.versionString.render();
        GL11.glPopMatrix();
        ColorUtil.setGLColor((ReadableColor)this.colour);
        this.registrationDetails.render();
        this.versionString.render();
        if (this.messageBox != null) {
            this.messageBox.render();
        }
    }

    protected void onClicked(String id) {
        GenericButtonHandler.onClicked(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onOpen() {
        GenericButtonHandler.onOpen(this);
        try {
            SFX.createSFX();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.doUpdateRegistrationDetails();
        TitleScreen titleScreen = instance;
        synchronized (titleScreen) {
            if (!this.messagesChecked && this.pendingMessage == null && Game.isRemoteCallAllowed() && CheckOnline.isOnline()) {
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            AppletMessageCheckerRemote amcr = (AppletMessageCheckerRemote)Naming.lookup("//puppygames.net/message_checker");
                            TitleScreen.this.pendingMessage = amcr.checkForMessages(Game.getTitle(), Game.getVersion(), Game.getGame().getMessageSequence(), (ConfigurationDetails)Game.getConfiguration());
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                        TitleScreen titleScreen = instance;
                        synchronized (titleScreen) {
                            TitleScreen.this.messagesChecked = true;
                        }
                    }
                }.start();
            }
        }
        if (Game.isRegistered() && !this.deregistrationChecked) {
            this.deregistrationChecked = true;
            if (Game.isRemoteCallAllowed() && CheckOnline.isOnline()) {
                new Thread(){

                    public void run() {
                        try {
                            AppletMessageCheckerRemote amcr = (AppletMessageCheckerRemote)Naming.lookup("//puppygames.net/message_checker");
                            boolean stillRegistered = amcr.checkRegistrationValid(Game.getRegistrationDetails());
                            if (!stillRegistered) {
                                Game.setRegistrationDetails(null);
                                TitleScreen.updateRegistrationDetails();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                    }
                }.start();
            }
        }
    }

    public static void updateRegistrationDetails() {
        TitleScreen.instantiate();
        instance.doUpdateRegistrationDetails();
    }

    private void doUpdateRegistrationDetails() {
        RegistrationDetails regDetails;
        if (this.getArea("buy") != null) {
            this.getArea("buy").setVisible(!Game.isRegistered());
        }
        if (this.getArea("moregames") != null) {
            this.getArea("moregames").setVisible(!Game.isRegistered());
        }
        if ((regDetails = Game.getRegistrationDetails()) == null) {
            this.registrationDetails.setText("");
        } else {
            this.registrationDetails.setText(regDetails.toTitleScreen().toUpperCase());
        }
        if (Game.isRegistered()) {
            this.versionString.setText("v" + Game.getVersion());
        } else {
            this.versionString.setText("v" + Game.getVersion() + " demo");
        }
    }
}

