/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.screens;

import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.util.CheckOnline;
import java.rmi.Naming;
import net.puppygames.applet.Game;
import net.puppygames.applet.Res;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.SFX;
import net.puppygames.applet.screens.NagScreen;
import net.puppygames.applet.screens.TitleScreen;
import net.puppygames.applet.widgets.MessageBox;
import net.puppygames.applet.widgets.TextField;
import net.puppygames.gamecommerce.shared.ConfigurationDetails;
import net.puppygames.gamecommerce.shared.RegistrationDetails;
import net.puppygames.gamecommerce.shared.RegistrationServerRemote;
import net.puppygames.gamecommerce.shared.ValidateUtil;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

public class RegisterScreen
extends Screen {
    public static final long serialVersionUID = 1L;
    private static RegisterScreen instance;
    private static final String EMAIL = "email";
    private static final String REGISTER = "register";
    private static final String LATER = "later";
    private static final String ORDER = "order";
    private int email_x = 68;
    private int email_y = 313;
    private transient TextField emailField;
    private transient boolean valid;
    private transient MessageBox messageBox;
    private transient int phase;
    private transient RegistrationDetails regDetails;
    private static final int PHASE_NORMAL = 0;
    private static final int PHASE_WAIT_REMOTE = 1;
    private static final int PHASE_WAIT_CLICK0 = 2;
    private static final int PHASE_WAIT_CLICK1 = 3;
    private static final int PHASE_ERROR = 4;
    private static final int PHASE_FATAL_ERROR = 5;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.puppygames.applet.screens.RegisterScreen");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public RegisterScreen(String name) {
        super(name);
    }

    protected void doCreateScreen() throws Exception {
        this.emailField = new TextField(64, this.getArea(EMAIL).getBounds().getWidth()){

            public boolean acceptChar(char c) {
                return Character.isLetterOrDigit(c) || c >= ' ' && c <= '\u007f';
            }

            protected void onChangeFocus() {
                SFX.textEntered();
                RegisterScreen.this.requestFocus(RegisterScreen.this.getArea(RegisterScreen.REGISTER));
            }

            protected void onEdited() {
                SFX.keyTyped();
                RegisterScreen.this.checkValid();
            }
        };
        this.emailField.setFont(Res.getSmallFont());
        this.emailField.setLocation(this.email_x, this.email_y);
    }

    protected void doRegister() {
        instance = this;
    }

    protected void doDeregister() {
        instance = null;
    }

    public static void show() {
        if (!instance.isCreated()) {
            try {
                instance.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        instance.open();
    }

    protected void onOpen() {
        Game.setPauseEnabled(false);
        Game.buy(false);
        this.emailField.setEditing(true);
        this.checkValid();
        this.phase = 0;
    }

    protected void onClose() {
        Game.setPauseEnabled(true);
        this.messageBox = null;
    }

    protected void doCleanup() {
        super.doCleanup();
        this.destroy();
    }

    protected void onClicked(String id) {
        if (id.equals(EMAIL)) {
            this.emailField.setEditing(true);
        } else if (id.equals(REGISTER)) {
            this.registration();
        } else if (id.equals(LATER)) {
            NagScreen.show("You know you want to!", false);
        } else if (id.equals(ORDER)) {
            Game.buy(true);
        }
    }

    private void registration() {
        if (!this.checkValid()) {
            return;
        }
        this.setEnabled(false);
        this.messageBox = new MessageBox();
        this.messageBox.setSize(Game.getWidth() - 20, Game.getHeight() - 20);
        if (!CheckOnline.isOnline()) {
            this.messageBox.setTitle("Registration Failed");
            this.messageBox.setMessage("It appears that you are not connected to the internet! Please exit " + Game.getTitle() + " and connect to the internet, and try again.");
            this.phase = 5;
        } else {
            this.phase = 1;
            this.messageBox.setTitle("Registering");
            this.messageBox.setMessage("Please wait whilst " + Game.getTitle() + " contacts the Puppy Games registration server to unlock your game.");
            new Thread(){

                public void run() {
                    RegistrationServerRemote server;
                    try {
                        server = (RegistrationServerRemote)Naming.lookup("//puppygames.net/registration");
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        RegisterScreen.this.registrationFailed("There has been a problem connecting to the Puppy Games registration server. Please ensure you are online and try again, or alternatively contact us on " + Game.getSupportEmail() + " for assistance.\n\nClick the mouse to continue.", 4);
                        return;
                    }
                    try {
                        RegistrationDetails regDetails = server.register(RegisterScreen.this.emailField.getText(), Game.getTitle(), Game.getVersion(), Game.getAffiliate(), Game.getInstallation(), System.getProperty("os.name"), (ConfigurationDetails)Game.getConfiguration());
                        RegisterScreen.this.registrationSuccess(regDetails);
                    }
                    catch (Throwable e) {
                        e.printStackTrace(System.err);
                        RegisterScreen.this.registrationFailed("There has been a problem registering your game with Puppy Games registration server. Please contact us on " + Game.getSupportEmail() + " for assistance.\n\nClick the mouse to continue.", 5);
                        return;
                    }
                }
            }.start();
        }
    }

    private void registrationFailed(String message, int nextPhase) {
        this.messageBox.setTitle("Failed");
        this.messageBox.setMessage(message);
        this.phase = nextPhase;
        Game.buy(false);
    }

    private void registrationSuccess(RegistrationDetails regDetails) {
        Game.clearBuy();
        Game.onRemoteCallSuccess();
        this.messageBox.setTitle("Success!");
        this.messageBox.setMessage("Congratulations! Your copy of " + Game.getTitle() + " has been unlocked and registered to you.\n\nClick the mouse or hit a key to continue.");
        this.phase = 2;
        this.regDetails = regDetails;
    }

    protected void doTick() {
        switch (this.phase) {
            case 0: {
                this.emailField.tick();
                if (!Keyboard.isKeyDown((int)1)) break;
                TitleScreen.show();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                TitleScreen.instantiate();
                Game.setRegistrationDetails(this.regDetails);
                this.regDetails = null;
                this.phase = 3;
                break;
            }
            case 3: 
            case 5: {
                if (!Mouse.isButtonDown((int)0) && !Keyboard.next()) break;
                TitleScreen.show();
                break;
            }
            case 4: {
                if (!Mouse.isButtonDown((int)0) && !Keyboard.next()) break;
                this.messageBox = null;
                this.phase = 0;
                this.setEnabled(true);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    protected void preRender() {
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glClear((int)16384);
    }

    protected void postRender() {
        GL11.glEnable((int)3553);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        ColorUtil.setGLColor((ReadableColor)Color.WHITE);
        this.emailField.render();
        if (this.messageBox != null) {
            this.messageBox.render();
        }
    }

    private boolean checkValid() {
        this.valid = ValidateUtil.isEmail((String)this.emailField.getText());
        return this.valid;
    }
}

