/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.interpolators.ColorInterpolator;
import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import net.puppygames.applet.Game;
import net.puppygames.applet.effects.Effect;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.WritableColor;

public class StrobeEffect
extends Effect {
    private static StrobeEffect instance;
    private static final Color cachedColor;
    private ReadableColor color;
    private int duration;
    private int tick;

    static {
        cachedColor = new Color();
    }

    public StrobeEffect(ReadableColor color, int duration) {
        if (instance != null) {
            instance.remove();
            instance = this;
        }
        this.color = color;
        this.duration = duration;
    }

    public boolean isActive() {
        return this.tick < this.duration;
    }

    protected void doTick() {
        ++this.tick;
    }

    protected void doRender() {
        if ((this.tick & 4) == 0) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            ColorInterpolator.interpolate((ReadableColor)this.color, (ReadableColor)Color.BLACK, (float)((float)this.tick / (float)this.duration), (Interpolator)LinearInterpolator.instance, (WritableColor)cachedColor);
            GL11.glColor4ub((byte)cachedColor.getRedByte(), (byte)cachedColor.getGreenByte(), (byte)cachedColor.getBlueByte(), (byte)cachedColor.getAlphaByte());
            GL11.glBegin((int)7);
            GL11.glVertex2i((int)0, (int)0);
            GL11.glVertex2i((int)Game.getWidth(), (int)0);
            GL11.glVertex2i((int)Game.getWidth(), (int)Game.getHeight());
            GL11.glVertex2i((int)0, (int)Game.getHeight());
            GL11.glEnd();
            GL11.glDisable((int)3042);
        }
    }

    protected void doRemove() {
        instance = null;
    }

    public boolean isBackgroundEffect() {
        return false;
    }
}

