/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.resources.Range;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.AnimatedAppearanceResource;
import com.shavenpuppy.jglib.util.FPMath;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.effects.Particle;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

public class EmitterFeature
extends Feature {
    private static final long serialVersionUID = 1L;
    private Range duration;
    private boolean infinite;
    private Range particlesPerTick;
    private String appearance;
    private String next;
    private Range velocity;
    private Range acceleration;
    private Range radius;
    private Range scale;
    private Range endScale;
    private Range gravityX;
    private Range gravityY;
    private Range particleDuration;
    private Range fadeDuration;
    private Range startHue;
    private Range startSaturation;
    private Range startBrightness;
    private Range endHue;
    private Range endSaturation;
    private Range endBrightness;
    private Range angle;
    private boolean scaleIn;
    private String sound;
    private float startPitch;
    private float endPitch;
    private float startVolume;
    private float endVolume;
    private EmitterFeature chain;
    private EmitterFeature slave;
    private transient EmitterFeature nextFeature;
    private transient AnimatedAppearanceResource appearanceResource;
    private transient ALBuffer soundResource;

    public EmitterFeature() {
    }

    public EmitterFeature(String name) {
        super(name);
    }

    public Emitter spawn(Screen screen) {
        return new EmitterInstance(null, screen);
    }

    private Emitter spawn(EmitterInstance parent, Screen screen) {
        return new EmitterInstance(parent, screen);
    }

    public Range getAcceleration() {
        return this.acceleration;
    }

    public void setAcceleration(Range acceleration) {
        this.acceleration = acceleration;
    }

    public Range getAngle() {
        return this.angle;
    }

    public void setAngle(Range angle) {
        this.angle = angle;
    }

    public String getAppearance() {
        return this.appearance;
    }

    public void setAppearance(String appearance) {
        this.appearance = appearance;
    }

    public EmitterFeature getChain() {
        return this.chain;
    }

    public void setChain(EmitterFeature chain) {
        this.chain = chain;
    }

    public Range getDuration() {
        return this.duration;
    }

    public void setDuration(Range duration) {
        this.duration = duration;
    }

    public Range getEndBrightness() {
        return this.endBrightness;
    }

    public void setEndBrightness(Range endBrightness) {
        this.endBrightness = endBrightness;
    }

    public Range getEndHue() {
        return this.endHue;
    }

    public void setEndHue(Range endHue) {
        this.endHue = endHue;
    }

    public float getEndPitch() {
        return this.endPitch;
    }

    public void setEndPitch(float endPitch) {
        this.endPitch = endPitch;
    }

    public Range getEndSaturation() {
        return this.endSaturation;
    }

    public void setEndSaturation(Range endSaturation) {
        this.endSaturation = endSaturation;
    }

    public Range getEndScale() {
        return this.endScale;
    }

    public void setEndScale(Range endScale) {
        this.endScale = endScale;
    }

    public float getEndVolume() {
        return this.endVolume;
    }

    public void setEndVolume(float endVolume) {
        this.endVolume = endVolume;
    }

    public Range getFadeDuration() {
        return this.fadeDuration;
    }

    public void setFadeDuration(Range fadeDuration) {
        this.fadeDuration = fadeDuration;
    }

    public Range getGravityX() {
        return this.gravityX;
    }

    public void setGravityX(Range gravityX) {
        this.gravityX = gravityX;
    }

    public Range getGravityY() {
        return this.gravityY;
    }

    public void setGravityY(Range gravityY) {
        this.gravityY = gravityY;
    }

    public boolean isInfinite() {
        return this.infinite;
    }

    public void setInfinite(boolean infinite) {
        this.infinite = infinite;
    }

    public Range getParticleDuration() {
        return this.particleDuration;
    }

    public void setParticleDuration(Range particleDuration) {
        this.particleDuration = particleDuration;
    }

    public Range getParticlesPerTick() {
        return this.particlesPerTick;
    }

    public void setParticlesPerTick(Range particlesPerTick) {
        this.particlesPerTick = particlesPerTick;
    }

    public Range getRadius() {
        return this.radius;
    }

    public void setRadius(Range radius) {
        this.radius = radius;
    }

    public Range getScale() {
        return this.scale;
    }

    public void setScale(Range scale) {
        this.scale = scale;
    }

    public boolean isScaleIn() {
        return this.scaleIn;
    }

    public void setScaleIn(boolean scaleIn) {
        this.scaleIn = scaleIn;
    }

    public EmitterFeature getSlave() {
        return this.slave;
    }

    public void setSlave(EmitterFeature slave) {
        this.slave = slave;
    }

    public String getSound() {
        return this.sound;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    public Range getStartBrightness() {
        return this.startBrightness;
    }

    public void setStartBrightness(Range startBrightness) {
        this.startBrightness = startBrightness;
    }

    public Range getStartHue() {
        return this.startHue;
    }

    public void setStartHue(Range startHue) {
        this.startHue = startHue;
    }

    public float getStartPitch() {
        return this.startPitch;
    }

    public void setStartPitch(float startPitch) {
        this.startPitch = startPitch;
    }

    public Range getStartSaturation() {
        return this.startSaturation;
    }

    public void setStartSaturation(Range startSaturation) {
        this.startSaturation = startSaturation;
    }

    public float getStartVolume() {
        return this.startVolume;
    }

    public void setStartVolume(float startVolume) {
        this.startVolume = startVolume;
    }

    public Range getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Range velocity) {
        this.velocity = velocity;
    }

    public String toXML(String tag, int indent) {
        StringBuffer ret = new StringBuffer();
        ret.append(this.writeIndent(indent));
        ret.append("<");
        ret.append(tag);
        ret.append("\n");
        ret.append(this.write(++indent, "name", this.getName()));
        ret.append(this.write(indent, "duration", this.duration));
        ret.append(this.write(indent, "infinite", this.infinite));
        ret.append(this.write(indent, "particlespertick", this.particlesPerTick));
        ret.append(this.write(indent, "appearance", this.appearance));
        ret.append(this.write(indent, "velocity", this.velocity));
        ret.append(this.write(indent, "acceleration", this.acceleration));
        ret.append(this.write(indent, "radius", this.radius));
        ret.append(this.write(indent, "scale", this.scale));
        ret.append(this.write(indent, "endscale", this.endScale));
        ret.append(this.write(indent, "gravityx", this.gravityX));
        ret.append(this.write(indent, "gravityy", this.gravityY));
        ret.append(this.write(indent, "particleduration", this.particleDuration));
        ret.append(this.write(indent, "fadeduration", this.fadeDuration));
        ret.append(this.write(indent, "starthue", this.startHue));
        ret.append(this.write(indent, "startsaturation", this.startSaturation));
        ret.append(this.write(indent, "startbrightness", this.startBrightness));
        ret.append(this.write(indent, "endhue", this.endHue));
        ret.append(this.write(indent, "endsaturation", this.endSaturation));
        ret.append(this.write(indent, "endbrightness", this.endBrightness));
        ret.append(this.write(indent, "angle", this.angle));
        ret.append(this.write(indent, "scalein", this.scaleIn));
        if (this.chain != null || this.slave != null) {
            ret.append(this.writeIndent(indent - 1));
            ret.append(">\n");
            if (this.chain != null) {
                ret.append(this.writeIndent(indent));
                ret.append("<chain>\n");
                ret.append(this.chain.toXML("emitter", ++indent));
                ret.append(this.writeIndent(--indent));
                ret.append("</chain>\n");
            }
            if (this.slave != null) {
                ret.append(this.writeIndent(indent));
                ret.append("<slave>\n");
                ret.append(this.slave.toXML("emitter", ++indent));
                ret.append(this.writeIndent(--indent));
                ret.append("</slave>\n");
            }
            ret.append(this.writeIndent(--indent));
            ret.append("</");
            ret.append(tag);
            ret.append(">\n");
        } else {
            ret.append(this.writeIndent(--indent));
            ret.append("/>\n");
        }
        return ret.toString();
    }

    private String writeIndent(int indent) {
        StringBuffer ret = new StringBuffer(indent);
        int i = 0;
        while (i < indent) {
            ret.append('\t');
            ++i;
        }
        return ret.toString();
    }

    private String write(int indent, String name, String data) {
        if (data == null) {
            return "";
        }
        StringBuffer ret = new StringBuffer(indent + name.length() + 16);
        ret.append(this.writeIndent(indent));
        ret.append(name);
        ret.append("=\"");
        ret.append(data);
        ret.append("\"\n");
        return ret.toString();
    }

    private String write(int indent, String name, Range range) {
        if (range == null) {
            return "";
        }
        StringBuffer ret = new StringBuffer(indent + name.length() + 16);
        ret.append(this.writeIndent(indent));
        ret.append(name);
        ret.append("=\"");
        ret.append(range.getMin());
        if (range.getMin() != range.getMax()) {
            ret.append(",");
            ret.append(range.getMax());
        }
        ret.append("\"\n");
        return ret.toString();
    }

    private String write(int indent, String name, boolean value) {
        if (!value) {
            return "";
        }
        StringBuffer ret = new StringBuffer(indent + name.length() + 16);
        ret.append(this.writeIndent(indent));
        ret.append(name);
        ret.append("=\"true\"\n");
        return ret.toString();
    }

    public class EmitterInstance
    extends Emitter {
        private int tick;
        private final int actualDuration;
        private float x;
        private float y;
        private final Screen screen;
        private final EmitterInstance parent;
        private boolean finished;
        private SoundEffect soundEffect;
        static /* synthetic */ Class class$0;

        private EmitterInstance(EmitterInstance parent, Screen screen) {
            this.screen = screen;
            this.parent = parent;
            this.actualDuration = EmitterFeature.this.duration == null ? 1 : (int)EmitterFeature.this.duration.getValue();
            if (EmitterFeature.this.nextFeature != null) {
                EmitterFeature.this.nextFeature.spawn(this, screen);
            }
            if (EmitterFeature.this.chain != null) {
                EmitterFeature.this.chain.spawn(this, screen);
            }
            if (EmitterFeature.this.soundResource != null) {
                this.soundEffect = Game.allocateSound(EmitterFeature.this.soundResource);
            }
            this.spawn(screen);
        }

        public void setLocation(float x, float y) {
            this.x = x;
            this.y = y;
        }

        protected void doTick() {
            ++this.tick;
            int n = (int)(EmitterFeature.this.particlesPerTick.getValue() + 0.5f);
            EmitterInstance e = this;
            float xx = this.x;
            float yy = this.y;
            while (e.parent != null) {
                e = e.parent;
                xx += e.x;
                yy += e.y;
            }
            int i = 0;
            while (i < n) {
                Color endColor;
                Color startColor;
                if (EmitterFeature.this.startHue == null) {
                    startColor = new Color(Color.WHITE);
                } else {
                    startColor = new Color();
                    startColor.fromHSB(EmitterFeature.this.startHue.getValue(), EmitterFeature.this.startSaturation == null ? 1.0f : EmitterFeature.this.startSaturation.getValue(), EmitterFeature.this.startBrightness == null ? 1.0f : EmitterFeature.this.startBrightness.getValue());
                }
                if (EmitterFeature.this.endHue == null) {
                    endColor = startColor;
                } else {
                    endColor = new Color();
                    endColor.fromHSB(EmitterFeature.this.endHue.getValue(), EmitterFeature.this.endSaturation == null ? 1.0f : EmitterFeature.this.endSaturation.getValue(), EmitterFeature.this.endBrightness == null ? 1.0f : EmitterFeature.this.endBrightness.getValue());
                }
                float xxx = xx;
                float yyy = yy;
                if (EmitterFeature.this.radius != null) {
                    float r = EmitterFeature.this.radius.getValue();
                    double angle = Math.random() * 2.0 * Math.PI;
                    xxx = (float)((double)xxx + (double)r * Math.cos(angle));
                    yyy = (float)((double)yyy + (double)r * Math.sin(angle));
                }
                Particle p = new Particle(xxx, yyy, EmitterFeature.this.angle == null ? (float)Math.random() * 360.0f : EmitterFeature.this.angle.getValue(), EmitterFeature.this.velocity == null ? 0.0f : EmitterFeature.this.velocity.getValue(), EmitterFeature.this.acceleration == null ? 0.0f : EmitterFeature.this.acceleration.getValue(), (int)EmitterFeature.this.particleDuration.getValue(), (int)EmitterFeature.this.fadeDuration.getValue(), (ReadableColor)startColor, (ReadableColor)endColor);
                if (EmitterFeature.this.slave != null) {
                    p.setEmitter(EmitterFeature.this.slave.spawn(this.screen));
                }
                p.setAx(EmitterFeature.this.gravityX == null ? 0.0f : EmitterFeature.this.gravityX.getValue());
                p.setAy(EmitterFeature.this.gravityY == null ? 0.0f : EmitterFeature.this.gravityY.getValue());
                p.setAppearance((AnimatedAppearance)EmitterFeature.this.appearanceResource);
                p.setScaleIn(EmitterFeature.this.scaleIn);
                p.setEndScale(EmitterFeature.this.endScale == null ? FPMath.ONE : FPMath.fpValue((float)EmitterFeature.this.endScale.getValue()));
                if (EmitterFeature.this.scale != null) {
                    p.setScale(FPMath.fpValue((float)EmitterFeature.this.scale.getValue()));
                }
                if (this.ceilingSet) {
                    p.setCeiling(this.ceiling);
                }
                if (this.floorSet) {
                    p.setFloor(this.floor);
                }
                if (this.leftWallSet) {
                    p.setLeftWall(this.leftWall);
                }
                if (this.rightWallSet) {
                    p.setRightWall(this.rightWall);
                }
                p.spawn(this.screen);
                ++i;
            }
            if (this.tick > this.actualDuration && !EmitterFeature.this.infinite) {
                this.finished = true;
            } else if (this.soundEffect != null && !EmitterFeature.this.infinite) {
                float ratio = (float)this.tick / (float)this.actualDuration;
                if (EmitterFeature.this.startVolume != EmitterFeature.this.endVolume) {
                    float f = LinearInterpolator.instance.interpolate(EmitterFeature.this.startVolume, EmitterFeature.this.endVolume, ratio);
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("net.puppygames.applet.Game");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.soundEffect.setGain(f, (Object)clazz);
                }
                if (EmitterFeature.this.startPitch != EmitterFeature.this.endPitch) {
                    float f = LinearInterpolator.instance.interpolate(EmitterFeature.this.startPitch, EmitterFeature.this.endPitch, ratio);
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("net.puppygames.applet.Game");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.soundEffect.setPitch(f, (Object)clazz);
                }
            }
        }

        protected void doRender() {
        }

        protected void doRemove() {
            this.finished = true;
            this.soundEffect = null;
        }

        public boolean isActive() {
            return !this.finished;
        }
    }
}

