/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet;

import com.shavenpuppy.jglib.resources.Feature;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class Binding
extends Feature {
    private static final long serialVersionUID = 1L;
    public static final String MOUSE = "mouse";
    public static final String KEYBOARD = "keyboard";
    public static final String CONTROLLER = "controller";
    private static final Map BINDINGS;
    private static final List ALL;
    private static boolean enabled;
    private String type;
    private String value;
    private boolean hold;
    private String description;
    private String defaultType;
    private int defaultIndex;
    private transient int index;
    private transient boolean down;
    private transient boolean wasDown;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.puppygames.applet.Binding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        BINDINGS = new HashMap();
        ALL = new LinkedList();
        enabled = true;
    }

    public Binding(String name) {
        super(name);
        this.setAutoCreated();
    }

    protected void doRegister() {
        BINDINGS.put(this.getName(), this);
        ALL.add(this);
    }

    protected void doDeregister() {
        BINDINGS.remove(this.getName());
        ALL.remove((Object)this);
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        if (KEYBOARD.equals(this.type)) {
            this.index = Keyboard.getKeyIndex((String)this.value);
        } else if (MOUSE.equals(this.type)) {
            this.index = Mouse.getButtonIndex((String)this.value);
        } else {
            CONTROLLER.equals(this.type);
        }
        this.defaultType = this.type;
        this.defaultIndex = this.index;
    }

    private void reset() {
        this.type = this.defaultType;
        this.index = this.defaultIndex;
    }

    public static void resetToDefaults() {
        Iterator i = BINDINGS.values().iterator();
        while (i.hasNext()) {
            Binding b = (Binding)((Object)i.next());
            b.reset();
        }
        Binding.validate();
    }

    public static void load(InputStream stream) throws Exception {
        ObjectInputStream ois = new ObjectInputStream(stream);
        List newBindings = (List)ois.readObject();
        Iterator i = newBindings.iterator();
        while (i.hasNext()) {
            SavedBinding b = (SavedBinding)i.next();
            Binding.setBinding(b.name, b.type, b.index);
        }
        Binding.validate();
    }

    public static void save(OutputStream stream) throws Exception {
        ObjectOutputStream oos = new ObjectOutputStream(stream);
        LinkedList<SavedBinding> output = new LinkedList<SavedBinding>();
        Iterator i = BINDINGS.values().iterator();
        while (i.hasNext()) {
            Binding b = (Binding)((Object)i.next());
            output.add(new SavedBinding(b));
        }
        oos.writeObject(output);
        oos.flush();
        oos.reset();
    }

    public static void validate() {
        Iterator i = BINDINGS.values().iterator();
        while (i.hasNext()) {
            Binding b = (Binding)((Object)i.next());
            if (KEYBOARD.equals(b.type) && !Keyboard.isCreated()) {
                b.type = null;
                continue;
            }
            if (MOUSE.equals(b.type) && !Mouse.isCreated()) {
                b.type = null;
                continue;
            }
            if (!CONTROLLER.equals(b.type) || Controllers.isCreated()) continue;
            b.type = null;
        }
    }

    public static List getBindings() {
        return Collections.unmodifiableList(ALL);
    }

    public boolean isDown() {
        if (this.hold) {
            return this.down;
        }
        if (this.wasDown) {
            return false;
        }
        return this.down;
    }

    public static void poll() {
        if (!enabled) {
            return;
        }
        Iterator i = BINDINGS.values().iterator();
        while (i.hasNext()) {
            Binding b = (Binding)((Object)i.next());
            b.wasDown = b.down;
            if (KEYBOARD.equals(b.type)) {
                if (Keyboard.isKeyDown((int)b.index)) {
                    b.down = true;
                    continue;
                }
                b.down = false;
                continue;
            }
            if (MOUSE.equals(b.type)) {
                if (Mouse.isButtonDown((int)b.index)) {
                    b.down = true;
                    continue;
                }
                b.down = false;
                continue;
            }
            if (!CONTROLLER.equals(b.type)) continue;
            b.down = Controllers.getController((int)0).isButtonPressed(b.index);
        }
    }

    public static void setEnabled(boolean enabled) {
        Binding.enabled = enabled;
        Iterator i = BINDINGS.values().iterator();
        while (i.hasNext()) {
            Binding b = (Binding)((Object)i.next());
            b.down = false;
            b.wasDown = false;
        }
    }

    public static void setBinding(String name, String type, int index) {
        Binding b = (Binding)((Object)BINDINGS.get(name));
        if (b == null) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("no such binding " + name));
            }
            return;
        }
        b.type = type;
        b.index = index;
        if (type != null) {
            Iterator i = BINDINGS.values().iterator();
            while (i.hasNext()) {
                Binding existing = (Binding)((Object)i.next());
                if (existing.name.equals(name) || !b.type.equals(existing.type) || b.index != existing.index) continue;
                existing.type = null;
                existing.index = 0;
            }
        }
        Binding.validate();
    }

    public static boolean isBindingDown(String name) {
        Binding b = (Binding)((Object)BINDINGS.get(name));
        if (b == null) {
            return false;
        }
        return b.isDown();
    }

    public int getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    private static class SavedBinding
    implements Serializable {
        String name;
        String type;
        int index;

        SavedBinding(Binding b) {
            this.name = b.getName();
            this.type = b.type;
            this.index = b.index;
        }
    }
}

