/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.util;

import org.lwjgl.Sys;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.glu.GLU;

public class FpsGraph {
    private int[] samples;
    private long previousTime;

    public FpsGraph() {
        this.samples = new int[400];
        this.reset();
    }

    public FpsGraph(int numSamples) {
        this.samples = new int[numSamples];
        this.reset();
    }

    public void reset() {
        this.previousTime = Sys.getTime();
    }

    public void tick() {
        long currentTime = Sys.getTime();
        long diff = currentTime - this.previousTime;
        this.previousTime = currentTime;
        float timeDelta = (float)diff / (float)Sys.getTimerResolution();
        if (timeDelta > 0.2f) {
            timeDelta = 0.2f;
        }
        this.logFrameTime(timeDelta);
    }

    public void logFrameTime(float timeInSeconds) {
        int i = 1;
        while (i < this.samples.length) {
            this.samples[i - 1] = this.samples[i];
            ++i;
        }
        this.samples[this.samples.length - 1] = (int)(1.0f / timeInSeconds);
    }

    public void render() {
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GLU.gluOrtho2D((float)0.0f, (float)Display.getDisplayMode().getWidth(), (float)0.0f, (float)Display.getDisplayMode().getHeight());
        GL11.glDisable((int)2929);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)10.0f, (float)10.0f, (float)0.0f);
        int width = this.samples.length;
        int height = 120;
        GL11.glBegin((int)1);
        GL11.glColor3f((float)0.8f, (float)0.8f, (float)0.8f);
        GL11.glVertex2f((float)0.0f, (float)30.0f);
        GL11.glVertex2f((float)width, (float)30.0f);
        GL11.glVertex2f((float)0.0f, (float)60.0f);
        GL11.glVertex2f((float)width, (float)60.0f);
        GL11.glVertex2f((float)0.0f, (float)100.0f);
        GL11.glVertex2f((float)width, (float)100.0f);
        GL11.glEnd();
        GL11.glBegin((int)3);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        int i = 0;
        while (i < this.samples.length) {
            float GREEN_CUTOFF = 60.0f;
            float ORANGE_CUTOFF = 30.0f;
            if ((float)this.samples[i] >= GREEN_CUTOFF) {
                GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
            } else if ((float)this.samples[i] >= ORANGE_CUTOFF) {
                GL11.glColor3f((float)1.0f, (float)0.6f, (float)0.1f);
            } else {
                GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
            }
            float y = Math.min(this.samples[i], height);
            GL11.glVertex2f((float)i, (float)y);
            ++i;
        }
        GL11.glEnd();
        GL11.glBegin((int)2);
        GL11.glColor3f((float)0.4f, (float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)width, (float)0.0f);
        GL11.glVertex2f((float)width, (float)height);
        GL11.glVertex2f((float)0.0f, (float)height);
        GL11.glEnd();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
    }
}

