/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteEngine;
import com.shavenpuppy.jglib.sprites.SpriteRenderer;

public class StaticSpriteEngine
extends Resource
implements SpriteEngine {
    private Sprite[] sprites;
    private int numAllocated;
    private int numVisible;
    private final SpriteRenderer renderer;
    private int tickRate;
    private float alpha = 1.0f;
    static int totalAllocated;

    public static int getTotalAllocated() {
        return totalAllocated;
    }

    public StaticSpriteEngine(boolean sortY, int maxSprites, int tickRate) throws Exception {
        if (tickRate < 1) {
            throw new IllegalArgumentException("tickRate must be > 0");
        }
        if (maxSprites < 1) {
            throw new IllegalArgumentException("maxSprites must be > 0");
        }
        this.sprites = new Sprite[maxSprites];
        this.tickRate = tickRate;
        int i = 0;
        while (i < maxSprites) {
            this.sprites[i] = new Sprite(this);
            this.sprites[i].index = i;
            ++i;
        }
        this.renderer = new SpriteRenderer(sortY, maxSprites);
    }

    protected void doCreate() throws Exception {
        this.renderer.create();
    }

    protected void doDestroy() {
        this.renderer.destroy();
    }

    public void setTickRate(int newTickRate) {
        this.tickRate = newTickRate;
    }

    public int getTickRate() {
        return this.tickRate;
    }

    public Sprite allocate(Object owner) {
        if (this.numAllocated == this.sprites.length) {
            return null;
        }
        if (owner == null) {
            throw new NullPointerException("No owner specified");
        }
        ++totalAllocated;
        Sprite s = this.sprites[this.numAllocated++];
        s.init(owner);
        return s;
    }

    public void deallocate(Sprite sprite) {
        --totalAllocated;
        this.sprites[sprite.index] = this.sprites[--this.numAllocated];
        this.sprites[sprite.index].index = sprite.index;
        this.sprites[this.numAllocated] = sprite;
        sprite.index = this.numAllocated;
    }

    public void clear() {
        int i = this.numAllocated;
        while (--i >= 0) {
            this.sprites[i].deallocate();
        }
    }

    public void tick() {
        int n = this.numAllocated;
        int i = 0;
        while (i < n) {
            Sprite s = this.sprites[i];
            if (s.isActive()) {
                s.tick();
            }
            ++i;
        }
    }

    public void render() {
        this.numVisible = 0;
        int n = this.numAllocated;
        this.renderer.setAlpha(this.alpha);
        this.renderer.preRender();
        int i = 0;
        while (i < n) {
            Sprite s = this.sprites[i];
            if (s.isVisible() && s.isActive()) {
                this.renderer.render(s);
                ++this.numVisible;
            }
            ++i;
        }
        this.renderer.postRender();
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }
}

