/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.AnimatedAppearanceResource;
import com.shavenpuppy.jglib.sprites.Command;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Animation
extends AnimatedAppearanceResource {
    public static final long serialVersionUID = 1L;
    private static final HashMap commandTagMap = new HashMap();
    private Command[] command;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.sprites.AngleCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        commandTagMap.put("angle", clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.shavenpuppy.jglib.sprites.ScaleCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        commandTagMap.put("scale", clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("com.shavenpuppy.jglib.sprites.FrameCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        commandTagMap.put("frame", clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("com.shavenpuppy.jglib.sprites.GotoCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        commandTagMap.put("goto", clazz4);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("com.shavenpuppy.jglib.sprites.NextCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        commandTagMap.put("next", clazz5);
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("com.shavenpuppy.jglib.sprites.RandomDelayCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        commandTagMap.put("delay", clazz6);
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("com.shavenpuppy.jglib.sprites.RandomGotoCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        commandTagMap.put("random", clazz7);
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("com.shavenpuppy.jglib.sprites.EventCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        commandTagMap.put("event", clazz8);
    }

    public Animation() {
    }

    public Animation(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        try {
            loader.pushMap(commandTagMap);
            NodeList childTagList = element.getChildNodes();
            ArrayList<Resource> commandList = new ArrayList<Resource>(childTagList.getLength());
            int i = 0;
            while (i < childTagList.getLength()) {
                if (childTagList.item(i) instanceof Element) {
                    Element childElement = (Element)childTagList.item(i);
                    Resource childResource = loader.load(childElement);
                    if (!(childResource instanceof Command)) {
                        throw new Exception("Only Command resources are allowed inside an Animation");
                    }
                    commandList.add(childResource);
                }
                ++i;
            }
            this.command = new Command[commandList.size()];
            commandList.toArray(this.command);
        }
        finally {
            loader.popMap();
        }
    }

    protected void doCreate() throws Exception {
        int i = 0;
        while (i < this.command.length) {
            this.command[i].create();
            ++i;
        }
    }

    protected void doDestroy() {
        int i = 0;
        while (i < this.command.length) {
            this.command[i].destroy();
            ++i;
        }
    }

    public void animate(Animated animated, int tickRate) {
        int currentSequence;
        do {
            if ((currentSequence = animated.getSequence()) >= 0 && currentSequence < this.command.length) continue;
            return;
        } while (this.command[currentSequence].execute(animated, tickRate));
    }

    public void toAnimated(Animated target) {
        target.setAnimation(this);
    }
}

