/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl;

import com.shavenpuppy.jglib.Font;
import com.shavenpuppy.jglib.Glyph;
import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.GLGlyph;
import com.shavenpuppy.jglib.opengl.GLGlyphBuffer;
import com.shavenpuppy.jglib.opengl.GLNamedRenderable;
import com.shavenpuppy.jglib.opengl.GLResource;
import com.shavenpuppy.jglib.opengl.GLTexture;
import com.shavenpuppy.jglib.resources.FontResource;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.BufferedInputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import org.lwjgl.util.Point;
import org.lwjgl.util.WritablePoint;
import org.w3c.dom.Element;

public class GLFont
extends GLResource
implements GLNamedRenderable {
    public static final long serialVersionUID = 1L;
    private static final Point tempPoint;
    protected String url;
    protected boolean ascii;
    private boolean linear = true;
    protected transient FontResource fontResource;
    protected transient Font font;
    protected transient GLTexture texture;
    protected transient boolean discardFontImage;
    protected transient boolean discardFontResource;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.opengl.GLFont");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        tempPoint = new Point();
    }

    public GLFont(String name) {
        super(name);
    }

    public GLFont(String name, String url, boolean ascii) {
        super(name);
        this.url = url;
        this.ascii = ascii;
        this.discardFontImage = true;
        this.discardFontResource = true;
    }

    public GLFont(String name, Font font, boolean ascii) {
        super(name);
        this.font = font;
        this.ascii = ascii;
        this.discardFontResource = true;
    }

    public GLFont(String name, FontResource fontResource, boolean ascii) {
        super(name);
        this.fontResource = fontResource;
        this.ascii = ascii;
    }

    protected void doGLCreate() throws Exception {
        if (this.url != null) {
            if (this.url.startsWith("classpath:")) {
                ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream(this.url.substring(10))));
                this.font = (Font)ois.readObject();
                ois.close();
            } else if (this.url.startsWith("resource:")) {
                this.fontResource = (FontResource)Resources.get(this.url.substring(9));
            } else {
                ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new URL(this.url).openStream()));
                this.font = (Font)ois.readObject();
                ois.close();
            }
        }
        if (this.fontResource != null) {
            this.font = this.fontResource.getFont();
        }
        if (this.font == null) {
            throw new Exception("No font specified for GLFont " + this);
        }
        this.texture = new GLTexture(this.getName(), this.font.getImage(), 3553, 6410, 9987, this.linear ? 9729 : 9728, false);
        this.texture.create();
        if (this.discardFontImage) {
            this.font.getImage().dispose();
        }
        if (this.discardFontResource) {
            this.fontResource = null;
        }
    }

    protected void doGLDestroy() {
        this.texture.destroy();
        this.texture = null;
    }

    public int getAscent() {
        return this.font.getAscent();
    }

    public int getDescent() {
        return this.font.getDescent();
    }

    public Font getFont() {
        return this.font;
    }

    public int getHeight() {
        return this.font.getAscent() + this.font.getDescent();
    }

    public int getLeading() {
        return this.font.getLeading();
    }

    public GLTexture getTexture() {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError((Object)(this + " is not created yet"));
        }
        return this.texture;
    }

    public void render() {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError((Object)(this + " is not created yet"));
        }
        this.texture.render();
    }

    public GLGlyphBuffer getGlyphBuffer(char[] text, int start, int end, GLGlyphBuffer buffer) {
        if (buffer == null || buffer.capacity() < end - start) {
            buffer = new GLGlyphBuffer(end - start);
        }
        int count = 0;
        Glyph last = null;
        int penX = 0;
        int i = start;
        while (i < end) {
            Glyph next = this.font.map(text[i]);
            if (buffer.glyph[count] == null) {
                buffer.glyph[count] = new GLGlyph(this.texture, next);
            } else {
                buffer.glyph[count].init(this.texture, next);
            }
            next.getBearing((WritablePoint)tempPoint);
            buffer.glyph[count++].setLocation(tempPoint.getX() + penX - next.getKerningAfter(last), tempPoint.getY());
            penX += next.getAdvance() + next.getKerningAfter(last);
            last = next;
            ++i;
        }
        buffer.length = count;
        return buffer;
    }

    public GLGlyph map(char c) {
        return new GLGlyph(this.texture, this.font.map(c));
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.url = XMLUtil.getString(element, "url");
        this.ascii = XMLUtil.getBoolean(element, "ascii", true);
        this.linear = XMLUtil.getBoolean(element, "linear", true);
    }
}

