/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.interpolators;

import com.shavenpuppy.jglib.interpolators.InterpolatorBase;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.util.FPMath;
import java.io.ObjectInput;
import java.io.ObjectStreamException;

public final class SineInterpolator
extends InterpolatorBase {
    public static final SineInterpolator instance = new SineInterpolator();

    private SineInterpolator() {
    }

    public float interpolate(float a, float b, float ratio) {
        if (ratio < 0.0f) {
            ratio = 0.0f;
        } else if (ratio > 1.0f) {
            ratio = 1.0f;
        }
        double ft = (double)ratio * Math.PI / 2.0;
        double f = Math.sin(ft);
        return (float)((double)a * (1.0 - f) + (double)b * f);
    }

    public int interpolate(int a, int b, int ratio) {
        if (ratio < 0) {
            ratio = 0;
        } else if (ratio > FPMath.ONE) {
            ratio = FPMath.ONE;
        }
        int f = FPMath.sin(ratio >> 2);
        return LinearInterpolator.instance.interpolate(a, b, f);
    }

    private Object readResolve(ObjectInput oi) throws ObjectStreamException {
        return instance;
    }
}

