/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.gamecommerce.client;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.Naming;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.puppygames.gamecommerce.client.BuyPage1;
import net.puppygames.gamecommerce.client.BuyPage2;
import net.puppygames.gamecommerce.client.BuyPage3;
import net.puppygames.gamecommerce.client.BuyPageFirst;
import net.puppygames.gamecommerce.client.BuyPageLast;
import net.puppygames.gamecommerce.client.HTMLTextArea;
import net.puppygames.gamecommerce.client.WindowUtil;
import net.puppygames.gamecommerce.client.WizardDialog;
import net.puppygames.gamecommerce.client.WizardGUI;
import net.puppygames.gamecommerce.shared.ConfigurationDetails;
import net.puppygames.gamecommerce.shared.Game;
import net.puppygames.gamecommerce.shared.PaymentDetails;
import net.puppygames.gamecommerce.shared.PaymentResult;
import net.puppygames.gamecommerce.shared.PaymentServerRemote;
import net.puppygames.gamecommerce.shared.RegistrationDetails;
import net.puppygames.gamecommerce.shared.UnknownConfigurationDetails;

public class PurchaseWindow
implements WizardDialog {
    private final Game game;
    private JDialog window;
    private HTMLTextArea jtaInstructions;
    private JPanel jpPages;
    private JButton jbNext;
    private JButton jbPrevious;
    private JButton jbCancel;
    private JPanel jpButtons;
    private CardLayout cardLayout;
    private WizardGUI[] page = new WizardGUI[]{new BuyPageFirst(), new BuyPage1(), new BuyPage2(), new BuyPage3(), new BuyPageLast()};
    private String[] pageName = new String[]{"1", "2", "3", "4", "5"};
    private int current;

    public PurchaseWindow(Game game) {
        this.game = game;
        this.window = new JDialog();
        this.window.setSize(400, 300);
        this.window.setTitle("Purchase " + game.getTitle());
        this.window.setModal(true);
        this.window.setResizable(false);
        this.window.setDefaultCloseOperation(0);
        this.jbCancel = new JButton("Cancel");
        this.jbNext = new JButton("Next >");
        this.jbPrevious = new JButton("< Previous");
        this.cardLayout = new CardLayout(){

            public Dimension minimumLayoutSize(Container parent) {
                return PurchaseWindow.this.page[PurchaseWindow.this.current].getComponent().getMinimumSize();
            }
        };
        this.jpPages = new JPanel(this.cardLayout);
        this.jpButtons = new JPanel(new GridBagLayout());
        this.jpButtons.add((Component)this.jbCancel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jpButtons.add((Component)this.jbPrevious, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jpButtons.add((Component)this.jbNext, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jtaInstructions = new HTMLTextArea("");
        int i = 0;
        while (i < this.page.length) {
            this.jpPages.add(this.page[i].getComponent(), this.pageName[i]);
            this.page[i].setWizardDialog(this);
            ++i;
        }
        this.window.getContentPane().setLayout(new GridBagLayout());
        this.window.getContentPane().add((Component)this.jtaInstructions, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.window.getContentPane().add((Component)this.jpPages, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.window.getContentPane().add((Component)this.jpButtons, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 15, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.jbCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PurchaseWindow.this.close();
            }
        });
        this.jbPrevious.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PurchaseWindow.this.previous();
            }
        });
        this.jbNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (PurchaseWindow.this.page[PurchaseWindow.this.current].validate()) {
                    if (PurchaseWindow.this.current == PurchaseWindow.this.page.length - 1) {
                        PurchaseWindow.this.finish();
                    } else {
                        PurchaseWindow.this.next();
                    }
                }
            }
        });
        this.window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PurchaseWindow.this.close();
            }
        });
    }

    public void open() {
        new Thread(){

            public void run() {
                int i = 0;
                while (i < PurchaseWindow.this.page.length) {
                    PurchaseWindow.this.page[i].init();
                    ++i;
                }
                PurchaseWindow.this.setCurrent(0);
                WindowUtil.centre(PurchaseWindow.this.window);
                PurchaseWindow.this.window.toFront();
                PurchaseWindow.this.jbNext.requestFocus();
                PurchaseWindow.this.window.validate();
                PurchaseWindow.this.window.setVisible(true);
                PurchaseWindow.this.window.requestFocus();
            }
        }.start();
    }

    public void close() {
        this.window.setVisible(false);
        this.window.dispose();
    }

    public Game getGame() {
        return this.game;
    }

    public void setNextButtonEnabled(boolean enable, String disabledToolTip) {
        this.jbNext.setEnabled(enable);
        if (enable) {
            this.jbNext.setToolTipText(null);
        } else {
            this.jbNext.setToolTipText(disabledToolTip);
        }
    }

    private void next() {
        if (this.current < this.page.length - 1) {
            this.setCurrent(this.current + 1);
        }
    }

    private void previous() {
        if (this.current > 0) {
            this.setCurrent(this.current - 1);
        }
    }

    private void finish() {
        PaymentDetails paymentDetails = new PaymentDetails(this.game);
        int i = 0;
        while (i < this.page.length) {
            this.page[i].toPaymentDetails(paymentDetails);
            ++i;
        }
        SecretKey secretKey = null;
        SealedObject sealedPaymentDetails = null;
        try {
            SecretKey[] ret = new SecretKey[1];
            sealedPaymentDetails = paymentDetails.seal(ret);
            secretKey = ret[0];
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.window, "Purchase Failed - Unable to Encrypt.");
            return;
        }
        PaymentServerRemote server = null;
        try {
            server = (PaymentServerRemote)Naming.lookup("//puppygames.net/ingamepayment");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.window, "Purchase Failed - Unabled to connect.");
            return;
        }
        PaymentResult result = null;
        try {
            result = server.register(secretKey.getEncoded(), sealedPaymentDetails);
            if (result.getErrorMessage() != null) {
                throw new Exception(result.getErrorMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.window, "Purchase Failed - Unable to Pay");
            return;
        }
        this.game.setRegistrationDetails(result.getRegistrationDetails());
        JOptionPane.showMessageDialog(this.window, "Purchase Successful");
        this.window.setVisible(false);
    }

    private void setCurrent(int newCurrent) {
        this.current = newCurrent;
        this.cardLayout.show(this.jpPages, this.pageName[this.current]);
        this.page[this.current].checkValid();
        this.jbPrevious.setEnabled(this.current > 0);
        this.jbNext.setText(this.current < this.page.length - 1 ? "Next >" : "Finish");
        this.jtaInstructions.setText(this.page[this.current].getInstructions());
        this.window.setTitle("Purchase " + this.game.getTitle() + " - " + this.page[this.current].getTitle());
    }

    public static void main(String[] args) {
        new PurchaseWindow(new Game(){

            public String getTitle() {
                return "Test Game";
            }

            public String getVersion() {
                return "1.0";
            }

            public String getAffiliate() {
                return "puppygames";
            }

            public ConfigurationDetails getConfiguration() {
                return new UnknownConfigurationDetails();
            }

            public long getInstallation() {
                return 0L;
            }

            public String getWebsite() {
                return "www.puppygames.net";
            }

            public String getPriceUSD() {
                return "$19.95";
            }

            public String getPriceGBP() {
                return "\u00a319.95";
            }

            public String getPriceEUR() {
                return "E19.95";
            }

            public String getDiscountPriceUSD() {
                return "$4.95";
            }

            public String getDiscountPriceGBP() {
                return "\u00a34.95";
            }

            public String getDiscountPriceEUR() {
                return "E4.95";
            }

            public void setRegistrationDetails(RegistrationDetails newDetails) {
            }
        }).open();
    }
}

