/*
 * Decompiled with CFR 0.152.
 */
package puppytron.movements;

import com.shavenpuppy.jglib.util.Util;
import puppytron.Moveable;
import puppytron.Movement;
import puppytron.MovementFeature;
import puppytron.Puppytron;

public class RandomMovementFeature
extends MovementFeature {
    private static final long serialVersionUID = 1L;
    private static final int INSET = 8;
    private int moveAmount;
    private int delayAmount;

    public Movement spawn(Moveable gidrah) {
        return new RandomMovementInstance(gidrah);
    }

    public int getArmour() {
        return 0;
    }

    public int getHitPoints() {
        return 0;
    }

    public int getScore() {
        return 0;
    }

    public String getSpawnType() {
        return "random";
    }

    public int getDifficulty() {
        return 0;
    }

    protected class RandomMovementInstance
    extends MovementFeature.MovementInstance {
        private boolean delay;
        private int moveTick;

        protected RandomMovementInstance(Moveable gidrah) {
            super(gidrah);
        }

        public void tick(Moveable gidrah) {
            ++this.moveTick;
            float vx = gidrah.getVX();
            float vy = gidrah.getVY();
            if (this.delay) {
                if (this.moveTick < RandomMovementFeature.this.delayAmount) {
                    return;
                }
                this.delay = false;
                this.moveTick = 0;
                switch (Util.random((int)0, (int)3)) {
                    case 0: {
                        vx = -RandomMovementFeature.this.getSpeed();
                        vy = 0.0f;
                        gidrah.setFacing(-1);
                        break;
                    }
                    case 1: {
                        vx = RandomMovementFeature.this.getSpeed();
                        vy = 0.0f;
                        gidrah.setFacing(1);
                        break;
                    }
                    case 2: {
                        vx = 0.0f;
                        vy = -RandomMovementFeature.this.getSpeed();
                        break;
                    }
                    case 3: {
                        vx = 0.0f;
                        vy = RandomMovementFeature.this.getSpeed();
                    }
                }
                gidrah.setVelocity(vx, vy);
            } else {
                if (gidrah.getX() + vx < gidrah.getRadius() + 8.0f || gidrah.getY() + vy < gidrah.getRadius() + 8.0f || gidrah.getX() + vx > (float)Puppytron.getWidth() - gidrah.getRadius() - 8.0f || gidrah.getY() + vy > (float)Puppytron.getHeight() - gidrah.getRadius() - 8.0f) {
                    vx = -vx;
                    vy = -vy;
                    gidrah.setVelocity(vx, vy);
                }
                if (this.moveTick < RandomMovementFeature.this.moveAmount) {
                    return;
                }
                this.delay = true;
                this.moveTick = 0;
                gidrah.setVelocity(0.0f, 0.0f);
            }
        }
    }
}

