/*
 * Decompiled with CFR 0.152.
 */
package puppytron.brains;

import puppytron.Brain;
import puppytron.BrainFeature;
import puppytron.GameScreen;
import puppytron.Gidrah;
import puppytron.GidrahFeature;

public class SpawnerBrainFeature
extends BrainFeature {
    private static final long serialVersionUID = 1L;
    private static final int MIN_INTERVAL = 45;
    private int interval;
    private String gidrah;
    private transient GidrahFeature gidrahFeature;

    public Brain spawn(Gidrah gidrah) {
        return new SpawnerBrainInstance(gidrah);
    }

    public int getArmour() {
        return 1;
    }

    public int getHitPoints() {
        return 4;
    }

    public int getScore() {
        return 50;
    }

    public int getDifficulty() {
        return 1;
    }

    protected class SpawnerBrainInstance
    extends BrainFeature.BrainInstance {
        private int tick;

        protected SpawnerBrainInstance(Gidrah gidrah) {
            super(gidrah);
        }

        public void tick(Gidrah gidrah) {
            ++this.tick;
            if (this.tick > Math.max(45, SpawnerBrainFeature.this.interval - GameScreen.getPlayer().getAccumulatedMultiplier() * 2)) {
                if (GameScreen.isLevelTimedOut()) {
                    gidrah.shoot(GameScreen.getPlayer().getX(), GameScreen.getPlayer().getY(), 0);
                } else {
                    Gidrah newGidrah = SpawnerBrainFeature.this.gidrahFeature.spawn(GameScreen.getInstance());
                    newGidrah.setLocation(gidrah.getX(), gidrah.getY());
                }
                this.tick = 0;
            }
        }
    }
}

