/*
 * Decompiled with CFR 0.152.
 */
package puppytron.brains;

import com.shavenpuppy.jglib.resources.Range;
import com.shavenpuppy.jglib.util.Util;
import puppytron.Brain;
import puppytron.BrainFeature;
import puppytron.GameScreen;
import puppytron.Gidrah;

public class ShooterBrainFeature
extends BrainFeature {
    private static final long serialVersionUID = 1L;
    private static final int MIN_INTERVAL = 20;
    private int accuracy;
    private Range minInterval;
    private Range maxInterval;

    public Brain spawn(Gidrah gidrah) {
        return new ShooterBrainInstance(gidrah);
    }

    public int getArmour() {
        return 0;
    }

    public int getHitPoints() {
        return 2;
    }

    public int getScore() {
        return 10;
    }

    public int getDifficulty() {
        return 0;
    }

    protected class ShooterBrainInstance
    extends BrainFeature.BrainInstance {
        private int tick;
        private int interval;

        protected ShooterBrainInstance(Gidrah gidrah) {
            super(gidrah);
            this.setInterval();
        }

        private void setInterval() {
            int min = ShooterBrainFeature.this.minInterval == null ? 0 : (int)ShooterBrainFeature.this.minInterval.getValue() - GameScreen.getPlayer().getAccumulatedMultiplier();
            int max = ShooterBrainFeature.this.maxInterval == null ? 0 : (int)ShooterBrainFeature.this.maxInterval.getValue() - GameScreen.getPlayer().getAccumulatedMultiplier() * 2;
            this.interval = Math.max(20, Util.random((int)min, (int)max));
            this.tick = 0;
        }

        public void tick(Gidrah gidrah) {
            ++this.tick;
            if (this.tick > this.interval) {
                gidrah.shoot(GameScreen.getPlayer().getX(), GameScreen.getPlayer().getY(), ShooterBrainFeature.this.accuracy);
                this.setInterval();
            }
        }
    }
}

