/*
 * Decompiled with CFR 0.152.
 */
package puppytron;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import net.puppygames.applet.Game;
import net.puppygames.applet.GameState;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.LabelEffect;
import org.lwjgl.util.Color;
import puppytron.EnemyBullet;
import puppytron.Entity;
import puppytron.GameScreen;
import puppytron.Gidrah;
import puppytron.GidrahFeature;
import puppytron.Player;
import puppytron.Puppytron;
import puppytron.Res;
import puppytron.Saucer;

class PuppytronGameState
extends GameState {
    private static final long serialVersionUID = 1L;
    private static int randomGidrahOffset;
    private int score;
    private int powerupScore;
    private int POWERUP_SCORE = 1000;
    private int POWERUP_DELAY_RATE = 100;
    private int powerupDelay;
    private final ArrayList entities = new ArrayList();
    private int tick;
    private int totalTicks;
    private int saucerTick;
    private int level;
    private int phase;
    private int waitTick;
    private Player player;
    private int nextBot;

    public void init() {
        GameScreen.beginGame(this);
        this.powerupScore = this.POWERUP_SCORE;
        this.powerupDelay = 0;
        this.setTick(0);
        this.setLevel(1);
        this.setPhase(1);
        this.entities.clear();
        GidrahFeature.resetNumGidrahs();
        EnemyBullet.reset();
        this.player = new Player();
        this.player.spawn(GameScreen.instance);
        GameScreen.initBackground();
        this.doInitMessages("PREPARE TO DIE", "Hit ESC to save game and quit");
    }

    private void doInitMessages(String big, String small) {
        LabelEffect newLevelEffect = new LabelEffect(Res.getBigFont(), big, Color.WHITE, Color.RED, 40, 160);
        newLevelEffect.setLocation((float)(Puppytron.getWidth() / 2), (float)(Puppytron.getHeight() / 2));
        newLevelEffect.setVisible(true);
        newLevelEffect.spawn((Screen)GameScreen.instance);
        LabelEffect hintEffect = new LabelEffect(Res.getSmallFont(), small, Color.WHITE, Color.RED, 40, 160);
        hintEffect.setDelay(30);
        hintEffect.setLocation((float)(Puppytron.getWidth() / 2), (float)(Puppytron.getHeight() / 2 - 40));
        hintEffect.setVisible(true);
        hintEffect.spawn((Screen)GameScreen.instance);
    }

    public void reinit() {
        GameScreen.beginGame(this);
        this.doInitMessages("RESUMING GAME", "Hit ESC to save game and quit");
        Iterator i = this.entities.iterator();
        while (i.hasNext()) {
            Entity entity = (Entity)i.next();
            entity.respawn(GameScreen.instance);
        }
        GameScreen.initBackground();
        if (this.player == null || !this.player.isActive()) {
            Puppytron.endGame();
        }
    }

    void tick() {
        switch (this.getPhase()) {
            case 0: {
                if (GidrahFeature.getNumGidrahs() > 0) break;
                if (this.waitTick == 0) {
                    int levelsToBoss;
                    this.setLevel(this.getLevel() + 1);
                    this.maybeSetBestLevel();
                    LabelEffect newLevelEffect = new LabelEffect(Res.getBigFont(), GameScreen.isAssaultLevel() ? "ASSAULT LEVEL" : "Level " + GameScreen.getLevel(), Color.WHITE, Color.BLUE, 180, 60);
                    newLevelEffect.setLocation((float)(Puppytron.getWidth() / 2), (float)(Puppytron.getHeight() / 2 + 40));
                    newLevelEffect.setVisible(true);
                    newLevelEffect.setSound(Res.getBreatherBuffer());
                    newLevelEffect.spawn((Screen)GameScreen.instance);
                    if (this.getLevel() < GameScreen.instance.progressDisplay.getTotalBars()) {
                        GameScreen.instance.setVisible("progress", true);
                        GameScreen.instance.getArea("progress").setAlpha(192);
                        GameScreen.instance.progressInstance = GameScreen.instance.progressDisplay.spawn((Screen)GameScreen.instance);
                        GameScreen.instance.progressInstance.setUsed(this.getLevel() - 1);
                        GameScreen.instance.progressInstance.setAlpha(192);
                    }
                    this.player.incMultipler();
                    this.player.updateAccumulatedMultiplier();
                    if (this.player.getMultiplier() > 1) {
                        LabelEffect multiplierEffect = new LabelEffect(Res.getSmallFont(), "x" + this.player.getMultiplier() + " Multiplier Active", Color.WHITE, Color.BLUE, 180, 60);
                        multiplierEffect.setLocation((float)(Puppytron.getWidth() / 2), (float)(Puppytron.getHeight() / 2 + 20));
                        multiplierEffect.setVisible(true);
                        multiplierEffect.setDelay(120);
                        multiplierEffect.setSound(Res.getBonusIncreased(this.player.getMultiplier()));
                        multiplierEffect.spawn((Screen)GameScreen.instance);
                    }
                    int nextBossLevel = (1 + this.getLevel() / 10) * 10;
                    if (!(this.getLevel() < nextBossLevel - 3 && this.getLevel() % 10 != 0 || (levelsToBoss = nextBossLevel - this.getLevel()) >= 3 && levelsToBoss != 10 || this.getLevel() > 40)) {
                        LabelEffect multiplierEffect = new LabelEffect(Res.getSmallFont(), levelsToBoss == 10 ? String.valueOf(GameScreen.BOSS_NAMES[this.getLevel() / 10 - 1]) + " AWAITS" : String.valueOf(levelsToBoss) + " level" + (levelsToBoss == 1 ? "" : "s") + " until " + GameScreen.BOSS_NAMES[this.getLevel() / 10], Color.WHITE, Color.BLUE, 180, 60);
                        multiplierEffect.setLocation((float)(Puppytron.getWidth() / 2), (float)(Puppytron.getHeight() / 2 - 20));
                        multiplierEffect.setVisible(true);
                        multiplierEffect.setDelay(160);
                        multiplierEffect.spawn((Screen)GameScreen.instance);
                    }
                    GameScreen.initLevel();
                }
                ++this.waitTick;
                if (this.waitTick != 240) break;
                this.setPhase(1);
            }
            case 1: {
                int ld;
                this.setTick(this.getTick() + 1);
                if (this.getTick() < 96 && GameScreen.instance.getArea("progress").isVisible()) {
                    GameScreen.instance.getArea("progress").setAlpha(192 - this.getTick() * 2);
                    if (GameScreen.instance.progressInstance != null) {
                        GameScreen.instance.progressInstance.setAlpha(192 - this.getTick() * 2);
                    }
                } else if (this.getTick() == 96 && GameScreen.instance.getArea("progress").isVisible()) {
                    GameScreen.instance.setVisible("progress", false);
                    if (GameScreen.instance.progressInstance != null) {
                        GameScreen.instance.progressInstance.cleanup();
                        GameScreen.instance.progressInstance = null;
                    }
                }
                ++this.totalTicks;
                if (GameScreen.isAssaultLevel()) {
                    if (this.getTick() < 275) {
                        int botsMinimum = (int)(30.0f + 0.25f * (float)this.getLevel());
                        GidrahFeature.createAssault(this.getLevel() / 5 / 2, botsMinimum - GidrahFeature.getNumGidrahs());
                    }
                } else {
                    --this.nextBot;
                    if (this.nextBot <= 0 || GidrahFeature.getNumGidrahs() == 0) {
                        int diff = this.player.getAccumulatedMultiplier() / 4 + GameScreen.getLevel() * 2 + (12 - this.player.getRepeatRate()) * 1;
                        if (this.player.isBouncy()) {
                            diff += 2;
                        }
                        if (this.player.isThreeWay()) {
                            diff += 2;
                        }
                        this.nextBot = Math.max(30, 70 - diff);
                        GidrahFeature.createGidrah();
                    }
                }
                if (this.getLevel() >= 3) {
                    ++this.saucerTick;
                    if (this.saucerTick > Math.max(1000, 3000 - 50 * this.getLevel())) {
                        this.saucerTick = 0;
                        Saucer saucer = new Saucer();
                        saucer.spawn(GameScreen.instance);
                    }
                }
                int n = ld = GameScreen.isAssaultLevel() ? 550 : 2200;
                if (this.getTick() != ld) break;
                if (!Game.isRegistered() && Game.getConfiguration().getMaxLevel() > 0 && this.level > Game.getConfiguration().getMaxLevel()) {
                    this.expireDemo();
                    break;
                }
                if (GameScreen.getLevel() % 10 == 0) {
                    this.setPhase(2);
                    break;
                }
                if (GameScreen.getLevel() % 7 == 0) {
                    this.setPhase(6);
                    break;
                }
                this.setPhase(0);
                this.waitTick = 0;
                break;
            }
            case 6: {
                ++this.totalTicks;
                if (GidrahFeature.getNumGidrahs() > 0) break;
                this.setPhase(7);
                this.setTick(0);
                Saucer.resetChallenge();
                LabelEffect challengeEffect = new LabelEffect(Res.getBigFont(), "CHALLENGE STAGE", Color.YELLOW, Color.RED, 60, 240);
                challengeEffect.setLocation((float)(Puppytron.getWidth() / 2), (float)(Puppytron.getHeight() / 2 + 40));
                challengeEffect.setVisible(true);
                challengeEffect.spawn((Screen)GameScreen.instance);
                LabelEffect challengeEffect2 = new LabelEffect(Res.getSmallFont(), "Shoot all spidroids", Color.YELLOW, Color.RED, 60, 240);
                challengeEffect2.setLocation((float)(Puppytron.getWidth() / 2), (float)(Puppytron.getHeight() / 2));
                challengeEffect2.setVisible(true);
                challengeEffect2.spawn((Screen)GameScreen.instance);
                challengeEffect2.setDelay(120);
                LabelEffect challengeEffect3 = new LabelEffect(Res.getSmallFont(), "Player is shielded", Color.YELLOW, Color.RED, 60, 240);
                challengeEffect3.setLocation((float)(Puppytron.getWidth() / 2), (float)(Puppytron.getHeight() / 2 - 20));
                challengeEffect3.setVisible(true);
                challengeEffect3.spawn((Screen)GameScreen.instance);
                challengeEffect3.setDelay(240);
            }
            case 7: {
                this.setTick(this.getTick() + 1);
                if (this.getTick() < 360) break;
                this.setPhase(8);
                this.setTick(0);
            }
            case 8: {
                this.setTick(this.getTick() + 1);
                if (this.getTick() < 800 + 10 * this.getLevel()) {
                    if (this.getTick() % Math.max(20, 60 - 2 * this.getLevel()) != 0) break;
                    Saucer saucer = new Saucer();
                    saucer.setChallenge(true);
                    saucer.spawn(GameScreen.instance);
                    break;
                }
                if (Saucer.getNumberRemoved() < Saucer.getNumberSpawned()) break;
                this.setPhase(9);
                this.setTick(0);
                LabelEffect bonusEffect = new LabelEffect(Res.getBigFont(), "CHALLENGE COMPLETE", Color.YELLOW, Color.RED, 60, 240);
                bonusEffect.setLocation((float)(Puppytron.getWidth() / 2), (float)(Puppytron.getHeight() / 2 + 40));
                bonusEffect.setVisible(true);
                bonusEffect.setSound(Res.getWellDoneHumanoid());
                bonusEffect.spawn((Screen)GameScreen.instance);
                int ratio = 100 * Saucer.getNumberShot() / Saucer.getNumberSpawned();
                String message = ratio == 100 ? "PERFECT!" : "Shot " + Saucer.getNumberShot() + " / " + Saucer.getNumberSpawned() + " : " + ratio + "%";
                LabelEffect bonusEffect2 = new LabelEffect(Res.getSmallFont(), message, Color.YELLOW, Color.RED, 60, 240);
                bonusEffect2.setLocation((float)(Puppytron.getWidth() / 2), (float)(Puppytron.getHeight() / 2));
                bonusEffect2.setVisible(true);
                bonusEffect2.setDelay(120);
                bonusEffect2.setSound(Res.getChallengeBonus());
                bonusEffect2.spawn((Screen)GameScreen.instance);
                int rate = 100 * (1 + this.getLevel() / 7);
                int bonus = ratio * rate;
                LabelEffect bonusEffect3 = new LabelEffect(Res.getSmallFont(), "Bonus " + ratio + "% x " + rate + " = " + bonus + " points", Color.YELLOW, Color.RED, 60, 240);
                bonusEffect3.setLocation((float)(Puppytron.getWidth() / 2), (float)(Puppytron.getHeight() / 2 - 20));
                Puppytron.addScore(bonus);
                bonusEffect3.setVisible(true);
                bonusEffect3.setDelay(240);
                bonusEffect3.setSound(Res.getBombDetonated());
                bonusEffect3.spawn((Screen)GameScreen.instance);
            }
            case 9: {
                this.setTick(this.getTick() + 1);
                if (this.getTick() < 360) break;
                this.setPhase(0);
                this.waitTick = 0;
                break;
            }
            case 2: {
                ++this.totalTicks;
                if (GidrahFeature.getNumGidrahs() > 0) break;
                String bossName = this.getLevel() <= 40 ? GameScreen.BOSS_NAMES[this.getLevel() / 10 - 1] : "BOSS ROBOTS";
                LabelEffect destroyBossEffect = new LabelEffect(Res.getBigFont(), "DESTROY " + bossName + "!!!", Color.WHITE, Color.RED, 60, 240);
                destroyBossEffect.setLocation((float)(Puppytron.getWidth() / 2), (float)(Puppytron.getHeight() / 2));
                destroyBossEffect.setVisible(true);
                destroyBossEffect.spawn((Screen)GameScreen.instance);
                GameScreen.initArena();
                GidrahFeature.createBosses();
                this.setPhase(3);
                this.setTick(0);
            }
            case 3: {
                ++this.totalTicks;
                this.setTick(this.getTick() + 1);
                if (this.getTick() == 300 && !Game.isRegistered() && Game.getConfiguration().getMaxLevel() > 0 && this.level >= Game.getConfiguration().getMaxLevel()) {
                    this.expireDemo();
                    break;
                }
                if (GidrahFeature.getNumGidrahs() > 0) break;
                if (!Game.isRegistered()) {
                    this.expireDemo();
                    break;
                }
                LabelEffect congratsEffect = new LabelEffect(Res.getBigFont(), this.getLevel() == GameScreen.instance.progressDisplay.getTotalBars() ? "HUMAN RACE AVENGED!" : "WELL DONE!", Color.WHITE, Color.YELLOW, 180, 60);
                congratsEffect.setLocation((float)(Puppytron.getWidth() / 2), (float)(Puppytron.getHeight() / 2 + 20));
                congratsEffect.setVisible(true);
                congratsEffect.setDelay(400);
                congratsEffect.setSound(Res.getWellDoneHumanoid());
                congratsEffect.spawn((Screen)GameScreen.instance);
                this.setPhase(0);
                this.waitTick = -600;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.setTick(this.getTick() + 1);
                if (this.getTick() <= 240) break;
                Game.endGame();
            }
        }
    }

    private void expireDemo() {
        this.player.kill();
        LabelEffect nagEffect = new LabelEffect(Res.getBigFont(), "): ): DEMO EXPIRED :( :(", Color.YELLOW, Color.RED, 160, 240);
        nagEffect.setLocation((float)(Puppytron.getWidth() / 2), (float)(Puppytron.getHeight() / 2));
        nagEffect.setVisible(true);
        nagEffect.spawn((Screen)GameScreen.instance);
        Game.getPreferences().putBoolean("showregister", true);
    }

    void tickAllEntities() {
        int i = 0;
        while (i < this.entities.size()) {
            Entity src = (Entity)this.entities.get(i);
            if (!src.isActive()) {
                this.entities.remove(i);
                continue;
            }
            int j = i + 1;
            while (j < this.entities.size() && src.isActive()) {
                Entity dest = (Entity)this.entities.get(j);
                if (!dest.isActive()) {
                    this.entities.remove(j);
                    continue;
                }
                if (src.canCollide() && dest.canCollide() && src.isTouching(dest)) {
                    src.onCollision(dest);
                    dest.onCollision(src);
                }
                ++j;
            }
            ++i;
        }
    }

    private void maybeSetBestLevel() {
        if (!Game.isRegistered()) {
            Game.getPreferences().putInt("bestlevel" + Game.getInstallation(), Math.max(this.getBestLevel(), this.getLevel()));
        }
    }

    private int getBestLevel() {
        return Game.getPreferences().getInt("bestlevel" + Game.getInstallation(), 0);
    }

    void setLevel(int level) {
        this.level = level;
    }

    int getLevel() {
        return this.level;
    }

    void setTick(int tick) {
        this.tick = tick;
    }

    void addEntity(Entity entity) {
        this.entities.add(entity);
    }

    void incLevel() {
        ++this.level;
    }

    int getTick() {
        return this.tick;
    }

    void setPhase(int phase) {
        this.phase = phase;
    }

    int getPhase() {
        return this.phase;
    }

    Player getPlayer() {
        return this.player;
    }

    int getTotalTicks() {
        return this.totalTicks;
    }

    void resetTotalTicks() {
        this.totalTicks = 0;
    }

    void freezeGidrahs() {
        int n = this.entities.size();
        int i = 0;
        while (i < n) {
            Entity entity = (Entity)this.entities.get(i);
            if (entity instanceof Gidrah) {
                ((Gidrah)((Object)entity)).freeze();
            }
            ++i;
        }
    }

    Gidrah getRandomGidrah() {
        Entity entity;
        int n = this.entities.size();
        int i = Math.min(randomGidrahOffset + 1, n);
        while (i < n) {
            entity = (Entity)this.entities.get(i);
            if (entity instanceof Gidrah) {
                randomGidrahOffset = i;
                return (Gidrah)((Object)entity);
            }
            ++i;
        }
        i = 0;
        while (i < n && i <= randomGidrahOffset) {
            entity = (Entity)this.entities.get(i);
            if (entity instanceof Gidrah) {
                randomGidrahOffset = i;
                return (Gidrah)((Object)entity);
            }
            ++i;
        }
        return null;
    }

    public int getScore() {
        return this.score;
    }

    public void addScore(int delta) {
        this.score = Math.max(0, this.score + delta);
    }

    public boolean isPowerupDue() {
        if (this.score >= this.powerupScore) {
            this.powerupScore += this.POWERUP_SCORE + this.powerupDelay * GameScreen.getPlayer().getMultiplier();
            this.powerupDelay += this.POWERUP_DELAY_RATE * GameScreen.getPlayer().getMultiplier();
            return true;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(Saucer.getNumberSpawned());
        stream.writeInt(Saucer.getNumberShot());
        stream.writeInt(Saucer.getNumberRemoved());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int saucersSpawned = stream.readInt();
        int saucersShot = stream.readInt();
        int saucersRemoved = stream.readInt();
        Saucer.reinit(saucersSpawned, saucersShot, saucersRemoved);
    }
}

